function create(){

	document.getElementById("end_game").style.visibility = 'hidden';
	window.canvas = document.getElementById("canvas");
	var ctx = canvas.getContext("2d");
 	ctx.canvas.width  = window.innerWidth;
 	ctx.canvas.height = window.innerWidth;
	window.level = 10;
	window.count = 0;

	//create the Array board
	window.board = new Array(level);
	for (var i = 0; i < board.length; i++) {
		board[i] = new Array(level);
	}
	 
	for (var i = 0; i < board.length; i++){
		for(var j = 0; j < board[i].length; j++){
	  		var random = Math.floor(Math.random()*6+1);
	  		board[i][j] = random;
	  	}
	}
	
	colorBoard();
}

function colorBoard(){
	//Color the Array board
	for (var i = 0; i < board.length; i++){	
		for(var j = 0; j < board[i].length; j++){
			paint(board[i][j],i,j);
	  	}
	}
}

function paint(x,i,j){
	
	var canvas = document.getElementById('canvas');
	var ctx = canvas.getContext('2d');

	w = (.1 * canvas.width);
	i = i*w;
	j = j*w;

	if (x==1){
		ctx.fillStyle = "blue"
	    ctx.fillRect(i,j,w,w);
	}
	if (x==2){
		ctx.fillStyle = "red"
	    ctx.fillRect(i,j,w,w);
	}
	if (x==3){
	    ctx.fillStyle = "yellow"
	    ctx.fillRect(i,j,w,w);
	}
	if (x==4){
	    ctx.fillStyle = "green"
	    ctx.fillRect(i,j,w,w);
	}
	if (x==5){
	    ctx.fillStyle = "purple"
	    ctx.fillRect(i,j,w,w);
	}
	if (x==6){
	    ctx.fillStyle = "orange"
	    ctx.fillRect(i,j,w,w);
	}
}

function play(current, last, x, y){

	last = board[x][y];
	board[x][y] = current;

	//Limita colunas pra frente
	if(y < level-1 && y >= 0){
		if(board[x][y+1] == last){
			y++;
			play(current, last, x, y);
			y--;
		}
	}

	//Limita colunas para trás
	if(y < level && y >= 1){
		if(board[x][y-1] == last){
			y--;
			play(current,last,x,y);
			y++;
		}
	}
			
	//Limita linhas pra baixo
	if(x < level-1 && x >=0){
		if(board[x+1][y] == last){
			x++;
			play(current, last, x, y);
			x--;
		}
	}

	//Limita linhas pra cima
	if(x < level && x >= 1){
		if(board[x-1][y] == last){
			x--;
			play(current, last, x, y);
			x++;
		}
	}

	if(count < 18){
		colorBoard();
	}
}

function counter (){
				
	count++;				
	var current = board[0][0];
	var win = 1;

	for (var i = 0; i < board.length; i++){
		for(var j = 0; j < board[i].length; j++){
	  		if(current != board[i][j]){
	  			document.getElementById("counter").innerHTML= "Game Over!";
	  			win = 0;
	  		} 
	  	}
	}

	if (win == 1){ 
	  	document.getElementById("counter").innerHTML= "You Win!";
		document.getElementById("buttons").style.visibility = 'hidden';
	  	document.getElementById("end_game").style.visibility = 'visible';
	  	return;
	}
			
	if (count == 18 && win == 0){
	  	document.getElementById("counter").innerHTML= "Game Over!";
	  	document.getElementById("buttons").style.visibility = 'hidden';
	  	document.getElementById("end_game").style.visibility = 'visible';
	  	return;
	}

	if(count == 17) document.getElementById("counter").innerHTML = (18 - count) + " play left";
	else document.getElementById("counter").innerHTML = (18 - count) + " plays left";
}

document.addEventListener('DOMContentLoaded', function () {
	document.getElementById('b1').addEventListener('click', function() { play(1,0,0,0); counter();});
	document.getElementById('b2').addEventListener('click', function() { play(2,0,0,0); counter();});
	document.getElementById('b3').addEventListener('click', function() { play(3,0,0,0); counter();});
	document.getElementById('b4').addEventListener('click', function() { play(4,0,0,0); counter();});
	document.getElementById('b5').addEventListener('click', function() { play(5,0,0,0); counter();});
	document.getElementById('b6').addEventListener('click', function() { play(6,0,0,0); counter();});
	create();
});


