/*! Color-Guess 2014-08-27 */
"use strict";window.requestAnimationFrame=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame,window.cancelAnimationFrame=window.cancelAnimationFrame||window.mozCancelAnimationFrame,angular.module("color-guess",["ngRoute","ngSanitize"]).constant("MAX_INITIAL_COLORS",4).constant("MAX_TIME",5e3).constant("TIME_SUBSTRACT",250).config(["$routeProvider",function($routeProvider){$routeProvider.when("/",{templateUrl:"partials/welcome-screen.html",controller:"WelcomeScreenCtrl"}).when("/game-canvas",{templateUrl:"partials/game-screen-canvas.html",controller:"GameScreenCanvasCtrl"}).when("/game-svg",{templateUrl:"partials/game-screen-svg.html",controller:"GameScreenSVGCtrl"}).when("/game-end",{templateUrl:"partials/game-end-screen.html",controller:"GameEndScreenCtrl"}).when("/highscores",{templateUrl:"partials/highscores-screen.html",controller:"HighscoresScreenCtrl"}).when("/about",{templateUrl:"partials/about-screen.html",controller:"AboutScreenCtrl"}).otherwise("/")}]),angular.module("color-guess").service("GameService",["MAX_INITIAL_COLORS","MAX_TIME","TIME_SUBSTRACT","Colors",function(MAX_INITIAL_COLORS,MAX_TIME,TIME_SUBSTRACT,Colors){function randomNumber(max){return Math.floor(Math.random()*max)}var max_colors=MAX_INITIAL_COLORS,time=MAX_TIME,score=-1,color_idx=0,name_idx=0,previous_color_idx=0,previous_name_idx=0;return{getNextColor:function(){for(;color_idx==previous_color_idx&&name_idx==previous_name_idx;)color_idx=randomNumber(max_colors),name_idx=randomNumber(max_colors);return previous_color_idx=color_idx,previous_name_idx=name_idx,score+=1,time=MAX_TIME-score/10*TIME_SUBSTRACT,1e3>time&&(time=1e3),max_colors=Math.floor(MAX_INITIAL_COLORS+score/30),max_colors>Colors.length&&(max_colors=Colors.length),{score:score,color:Colors[color_idx].color,name:Colors[name_idx].name,answer:color_idx==name_idx,time:time}},newGame:function(){max_colors=MAX_INITIAL_COLORS,score=-1},getScore:function(){return score}}}]),angular.module("color-guess").service("HighscoresService",[function(){var highscores=angular.fromJson(window.localStorage.highscores)||[];return{getHighscores:function(){return highscores},addScore:function(score){score>0&&(highscores.push(score),highscores=highscores.sort(function(a,b){return b-a}).slice(0,5),window.localStorage.highscores=angular.toJson(highscores))}}}]),angular.module("color-guess").service("Colors",[function(){return[{color:"#ffff00",name:"yellow"},{color:"#0000ff",name:"blue"},{color:"#ff0000",name:"red"},{color:"#00cc00",name:"green"},{color:"#61380b",name:"brown"},{color:"#ff00ff",name:"pink"},{color:"#ff8000",name:"orange"},{color:"#6a0888",name:"purple"},{color:"#66ccff",name:"cyan"},{color:"#848484",name:"gray"},{color:"#000000",name:"black"}]}]),angular.module("color-guess").service("i18n",["strings_en","strings_es","strings_fr","strings_pt","strings_de",function(en,es,fr,pt,de){var current_language=null,setLanguageCode=function(code){current_language="en"===code?en:"es"===code?es:"fr"===code?fr:"pt"===code?pt:"de"===code?de:en},browserLanguage=navigator.language||navigator.browserLanguage||navigator.systemLanguage||navigator.userLanguage||"en";return setLanguageCode(browserLanguage.substring(0,2)),{setLanguage:function(code){setLanguageCode(code)},getString:function(name){var result="miss:"+name;return current_language[name]&&(result=current_language[name]),result}}}]),angular.module("color-guess").service("strings_en",[function(){return{yellow:"yellow",blue:"blue",red:"red",green:"green",cyan:"cyan",brown:"brown",pink:"pink",orange:"orange",purple:"purple",gray:"gray",black:"black",highscores:"Highscores",play:"Play!",back:"Back",about:'<p>This game is a demostration of the <a href="https://en.wikipedia.org/wiki/Stroop_effect" target="_blank">Stroop effect</a>.</p><p>The purpose of the game is to tell if the name of the color matches the color painted on the screen, before the time outs.</p><p>As you guess right more colors the game will get faster, new colors will appear and the game will become more difficult.</p><p>This game is inspired by the wonderful Android game <a href="https://play.google.com/store/apps/details?id=com.aurelhubert.truecolor&hl=en" target="_blank">True Color</a> by Aurélien Hubert.</p>'}}]),angular.module("color-guess").service("strings_es",[function(){return{yellow:"amarillo",blue:"azul",red:"rojo",green:"verde",cyan:"celeste",brown:"marrón",pink:"rosa",orange:"naranja",purple:"morado",gray:"gris",black:"negro",highscores:"Puntuaciones",play:"¡Jugar!",back:"Volver",about:'<p>Este juego es una demostración del <a href="https://es.wikipedia.org/wiki/Efecto_Stroop" target="_blank">efecto Stroop</a>.</p><p>El propósito del juego es determinar si el nombre del color coincide con el color pintado en la pantalla, antes de que el tiempo se acabe.</p><p>Según vayas acertando más colores, el juego se volverá más rápido y nuevos colores aparecerán para hacer la partida más difícil.</p><p>Este juego está inspirado en el divertido juego para Android <a href="https://play.google.com/store/apps/details?id=com.aurelhubert.truecolor&hl=es" target="_blank">True Color</a> por Aurélien Hubert.</p>'}}]),angular.module("color-guess").service("strings_de",[function(){return{yellow:"gelb",blue:"blau",red:"rot",green:"grün",cyan:"hellblau",brown:"braun",pink:"rosa",orange:"orange",purple:"lila",gray:"grau",black:"schwartz",highscores:"Highscores",play:"Play!",back:"Back",about:'<p>This game is a demostration of the <a href="https://de.wikipedia.org/wiki/Stroop-Effekt" target="_blank">Stroop effect</a>.</p><p>The purpose of the game is to tell if the name of the color matches the color painted on the screen, before the time outs.</p><p>As you guess right more colors the game will get faster, new colors will appear and the game will become more difficult.</p><p>This game is inspired by the wonderful Android game <a href="https://play.google.com/store/apps/details?id=com.aurelhubert.truecolor&hl=de" target="_blank">True Color</a> by Aurélien Hubert.</p>'}}]),angular.module("color-guess").service("strings_fr",[function(){return{yellow:"jaune",blue:"bleu",red:"rouge",green:"vert",cyan:"bleu clair",brown:"brun",pink:"rose",orange:"orange",purple:"pourpre",gray:"gris",black:"noir",highscores:"Highscores",play:"Jouer!",back:"Back",about:'<p>This game is a demostration of the <a href="https://fr.wikipedia.org/wiki/Effet_Stroop" target="_blank">Stroop effect</a>.</p><p>The purpose of the game is to tell if the name of the color matches the color painted on the screen, before the time outs.</p><p>As you guess right more colors the game will get faster, new colors will appear and the game will become more difficult.</p><p>This game is inspired by the wonderful Android game <a href="https://play.google.com/store/apps/details?id=com.aurelhubert.truecolor&hl=fr" target="_blank">True Color</a> by Aurélien Hubert.</p>'}}]),angular.module("color-guess").service("strings_pt",[function(){return{yellow:"amarelo",blue:"azul",red:"vermelho",green:"verde",cyan:"celeste",brown:"marrom",pink:"rosa",orange:"laranja",purple:"roxo",gray:"cinza",black:"preto",highscores:"Highscores",play:"Jogar!",back:"Atras",about:'<p>This game is a demostration of the <a href="https://pt.wikipedia.org/wiki/Efeito_Stroop" target="_blank">Stroop effect</a>.</p><p>The purpose of the game is to tell if the name of the color matches the color painted on the screen, before the time outs.</p><p>As you guess right more colors the game will get faster, new colors will appear and the game will become more difficult.</p><p>This game is inspired by the wonderful Android game <a href="https://play.google.com/store/apps/details?id=com.aurelhubert.truecolor&hl=pt" target="_blank">True Color</a> by Aurélien Hubert.</p>'}}]),angular.module("color-guess").controller("WelcomeScreenCtrl",["$scope","i18n",function($scope,i18n){$scope.i18n=i18n}]),angular.module("color-guess").controller("AboutScreenCtrl",["$scope","i18n",function($scope,i18n){$scope.i18n=i18n}]),angular.module("color-guess").controller("GameScreenCanvasCtrl",["$scope","i18n","GameService","$location","$timeout",function($scope,i18n,GameService,$location,$timeout){var setupCanvas=function(canvas){var container=document.getElementById("color-container");dimension=container.clientWidth>container.clientHeight?container.clientHeight:container.clientWidth,canvas.width=dimension,canvas.height=dimension,canvas.style.width=dimension+"px",canvas.style.height=dimension+"px",container.style.width=dimension+"px",container.style.margin="0 auto"};$scope.i18n=i18n,$scope.currentColor={},$scope.playing=!1,$scope.score=0;var dimension=0,animationId=null,startAnimationId=null,canvas=document.getElementById("color-wheel"),ctx=canvas.getContext("2d");setupCanvas(ctx.canvas);var timeElapsed=0,rads=0,radius=ctx.canvas.width/2-20,centerx=ctx.canvas.width/2,centery=ctx.canvas.height/2,arcStart=-(Math.PI/2),animationStart=null;$scope.buttonYes=function(){$scope.playing&&(1==$scope.currentColor.answer?nextColor():gameEnded())},$scope.buttonNo=function(){$scope.playing&&(0==$scope.currentColor.answer?nextColor():gameEnded())};var startNewGame=function(){$scope.playing=!0,GameService.newGame(),nextColor()},nextColor=function(){$scope.currentColor=GameService.getNextColor(),$scope.score=$scope.currentColor.score,animationStart=null,animationId&&window.cancelAnimationFrame(animationId),startAnimationId=window.requestAnimationFrame(animateColorWheel)},animateColorWheel=function(timestamp){startAnimationId&&window.cancelAnimationFrame(startAnimationId),null===animationStart&&(animationStart=timestamp),timeElapsed=timestamp-animationStart,timeElapsed>$scope.currentColor.time&&(timeElapsed=$scope.currentColor.time),rads=2*timeElapsed*Math.PI/$scope.currentColor.time+arcStart,ctx.clearRect(0,0,dimension,dimension),ctx.font="bold 30px Arial",ctx.textAlign="center",ctx.fillStyle=$scope.currentColor.color,ctx.fillText(i18n.getString($scope.currentColor.name).toUpperCase(),centerx,centery+10,2*radius),ctx.beginPath(),ctx.arc(centerx,centery,radius,arcStart,rads,!1),ctx.lineWidth=20,ctx.strokeStyle=$scope.currentColor.color,ctx.stroke(),$scope.playing&&timeElapsed<$scope.currentColor.time?animationId=window.requestAnimationFrame(animateColorWheel):timeExpired()},timeExpired=function(){gameEnded()},gameEnded=function(){$scope.playing=!1,$timeout(function(){$location.url("/game-end")},1e3)};startNewGame()}]),angular.module("color-guess").controller("GameEndScreenCtrl",["$scope","$location","GameService","i18n","HighscoresService",function($scope,$location,GameService,i18n,HighscoresService){$scope.i18n=i18n,$scope.score=GameService.getScore(),$scope.score>0&&HighscoresService.addScore($scope.score)}]),angular.module("color-guess").controller("HighscoresScreenCtrl",["$scope","i18n","HighscoresService",function($scope,i18n,HighscoresService){$scope.i18n=i18n,$scope.highscores=HighscoresService.getHighscores()}]);