$(document).bind('pageinit',function(){
	//canvas part
	var mycanvas = document.getElementById("mypallete");
	var mycontext = mycanvas.getContext("2d");
	var img = document.getElementById("mypalleteimage");
	mycontext.drawImage(img,0,0,300,350);

	//db part
	if(typeof localStorage['color-picker-database'] !== "undefined"){
		var data = JSON.parse(localStorage['color-picker-database']);
		data.forEach(function(color){
			$("#favorite").append("<div class='favorites' style='background:"+color+";'>"+color+"</div>");
		});
	}else{
		var colors = new Array();
		localStorage['color-picker-database'] = JSON.stringify(colors);
	}
	
	//
	$('#mypallete').click(function(e) {
		var pos = findPos(this);
		var x = e.pageX - pos.x;
		var y = e.pageY - pos.y;
		var coord = "x=" + x + ", y=" + y;
		var c = this.getContext('2d');
		var p = c.getImageData(x, y, 1, 1).data; 
		var hex = "#" + ("000000" + rgbToHex(p[0], p[1], p[2])).slice(-6);
		$('#status').val(hex);
		
		$("#color-preview").css({
			"background":hex
		});
	});
	
	$("#clipboard").click(function(){
			var color = $('#status').val();
			alert("Color has been copied on the clipboard");
	});
	
	$("#fav").click(function(){
			var colorArray = JSON.parse(localStorage['color-picker-database']);
			var color = $('#status').val();
			var flag = false;
			colorArray.forEach(function(cc){
				if(cc == color){
					flag = true;
				}
				
			});
			
			if(!flag){
					colorArray.push(color);
					localStorage['color-picker-database'] = JSON.stringify(colorArray);
					$("#favorite").append("<div class='favorites' style='background:"+color+";'>"+color+"</div>");
			}
	});
	
	$(document).on("click",".favorites",function(){
		var del = confirm("Delete this color in your favorites?");
		var colorArray = JSON.parse(localStorage['color-picker-database']);
		var newArray = new Array();
		var ac = '';
		
		if(del){
			$(this).fadeOut();
			ac = $(this).html();
		}
		colorArray.forEach(function(colors){
			if(colors != ac){
				newArray.push(colors);
			}
		});
		
		localStorage['color-picker-database'] = JSON.stringify(newArray);
	});

  
});

function findPos(obj) {
    var curleft = 0, curtop = 0;
    if (obj.offsetParent) {
        do {
            curleft += obj.offsetLeft;
            curtop += obj.offsetTop;
        } while (obj = obj.offsetParent);
        return { x: curleft, y: curtop };
    }
    return undefined;
}

function rgbToHex(r, g, b) {
    if (r > 255 || g > 255 || b > 255)
        throw "Invalid color component";
    return ((r << 16) | (g << 8) | b).toString(16);
}
