var canvas;
var selected_color = '';


$(document).ready(function() {
    
	navigator.getUserMedia = ( navigator.getUserMedia ||
                       navigator.webkitGetUserMedia ||
                       navigator.mozGetUserMedia ||
                       navigator.msGetUserMedia);

	if (navigator.getUserMedia) {
	   navigator.getUserMedia (

		  // constraints
		  {
			 video: true,
			 audio: true
		  },

		  // successCallback
		  function(localMediaStream) {
				var video = document.querySelector('video');
				video.src = window.URL.createObjectURL(localMediaStream);
				video.play();
				
				canvas = document.createElement("canvas");
				canvas.width = $('#myvideo').outerHeight(true)*2;		//"MAGIC"
				canvas.height = $('#myvideo').outerWidth(true)*2;		//"MAGIC"
								
				var el = document.getElementsByTagName("video")[0];
				el.addEventListener("touchmove", handleMove, false);
				
		  },

		  // errorCallback
		  function(err) {
			 console.log("The following error occured: " + err);
		  }
	   );
	} else {
	   console.log("getUserMedia not supported");
	}
	
	$( window ).unload(function() {
		if(selected_color != ''){
			saved_colors = getCookie("current_color");
			
			var temp_cookie;
			if(saved_colors != ""){
				temp_cookie = saved_colors + "@" + selected_color;
			}
			else{
				temp_cookie = selected_color;
			}
			
			setCookie("current_color", temp_cookie, 360);
			//setCookie("current_color", temp_cookie, 0);	
		}
	});
});

function handleMove(evt) {
	evt.preventDefault();
	var touches = evt.changedTouches;
	
	var video = $('#myvideo').get(0);
	var context = canvas.getContext('2d');
	
	context.drawImage(video,0,0,$('#myvideo').outerWidth(true), $('#myvideo').outerHeight(true));
	
	var x = touches[0].screenX;
	var y = touches[0].screenY - $('#myvideo').offset().top;
	
	var imgData = context.getImageData(x, y, 1, 1);
	var red = imgData.data[0];
	var green = imgData.data[1];
	var blue = imgData.data[2];
	//var color_alpha;
	
	//nem bírja
	/*for(var i = -1 ; i < 2; i ++){
		for(var j = -1 ; j < 2; j ++){
			var imgData = context.getImageData(x + i, y + j, 1, 1);
			red = (imgData.data[0] + red) / 2;
			green = (imgData.data[1] + green) / 2;
			blue = (imgData.data[2] + blue) / 2;
			//color_alpha = imgData.data[3];
		}
	}*/
	
	red = Math.floor(red);
	green = Math.floor(green);
	blue = Math.floor(blue);
	
	var hexa = rgb2hex(red,green,blue);
	
	selected_color = hexa;
	
	$('#color_name').html(search_color_name(hexa));
	$('#header > span').html(red + "," + green + "," + blue + " - " + hexa);
	$('#selected_color').css('background-color','rgb('+red+','+green+','+blue+')');
}

