function spectrum(elem){
    var hue = 'rgb(' + (Math.floor(Math.random() * 256)) + ',' + (Math.floor(Math.random() * 256)) + ',' + (Math.floor(Math.random() * 256)) + ')';
    $(elem).css('background-color',hue);
}

$(document).ready(function() {
	spectrum($('#footer_menu'));
	
	setInterval(function(){ 
		spectrum($('#footer_menu'));
	}, 2000);	
});

function hex2rgb(hex) {
    
	var bigint = parseInt(hex.substring(1, hex.length), 16);
    var r = (bigint >> 16) & 255;
    var g = (bigint >> 8) & 255;
    var b = bigint & 255;

    return r + "," + g + "," + b;
}

function rgb2hex(red, green, blue){
	
	var h_red;
	if((red).toString(16).length == 1){
		h_red = '0' + (red).toString(16);
	}
	else{
		h_red = (red).toString(16);
	}	
	var h_green;	
	if((green).toString(16).length == 1){
		h_green = '0' + (green).toString(16);
	}
	else{
		h_green = (green).toString(16);
	}	
	var h_blue;	
	if((blue).toString(16).length == 1){
		h_blue = '0' + (blue).toString(16);
	}
	else{
		h_blue = (blue).toString(16);
	}
	
	return ("#" + h_red + h_green + h_blue);
} 

function rgb2hsv (red, green, blue) {
    var rr, gg, bb,
        r = red / 255,
        g = green / 255,
        b = blue / 255,
        h, s,
        v = Math.max(r, g, b),
        diff = v - Math.min(r, g, b),
        diffc = function(c){
            return (v - c) / 6 / diff + 1 / 2;
        };

    if (diff == 0) {
        h = s = 0;
    } else {
        s = diff / v;
        rr = diffc(r);
        gg = diffc(g);
        bb = diffc(b);

        if (r === v) {
            h = bb - gg;
        }else if (g === v) {
            h = (1 / 3) + rr - bb;
        }else if (b === v) {
            h = (2 / 3) + gg - rr;
        }
        if (h < 0) {
            h += 1;
        }else if (h > 1) {
            h -= 1;
        }
    }
	
	var color = {
			hue: Math.round(h * 360),
			saturation: Math.round(s * 100),
			lightness: Math.round(v * 100)
		};
	
	return color;
}

function hsv2rgb(h, s, v) {
    h=h/360;
	s=s/100;
	v=v/100;
	var r, g, b, i, f, p, q, t;
    if (h && s === undefined && v === undefined) {
        s = h.s, v = h.v, h = h.h;
    }
    i = Math.floor(h * 6);
    f = h * 6 - i;
    p = v * (1 - s);
    q = v * (1 - f * s);
    t = v * (1 - (1 - f) * s);
    switch (i % 6) {
        case 0: r = v, g = t, b = p; break;
        case 1: r = q, g = v, b = p; break;
        case 2: r = p, g = v, b = t; break;
        case 3: r = p, g = q, b = v; break;
        case 4: r = t, g = p, b = v; break;
        case 5: r = v, g = p, b = q; break;
    }
    return {
        r: Math.floor(r * 255),
        g: Math.floor(g * 255),
        b: Math.floor(b * 255)
    };
}

function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays*24*60*60*1000));
    var expires = "expires="+d.toUTCString();
    document.cookie = cname + "=" + cvalue + "; " + expires;
}

function getCookie(cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for(var i=0; i<ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1);
        if (c.indexOf(name) != -1) return c.substring(name.length,c.length);
    }
    return "";
}

function clone(obj) {
    if (null == obj || "object" != typeof obj) return obj;
    var copy = obj.constructor();
    for (var attr in obj) {
        if (obj.hasOwnProperty(attr)) copy[attr] = obj[attr];
    }
    return copy;
}

function kelvin2rgb(kelvin_temperature){
	var temperature = kelvin_temperature / 100;
    
    //Calculate Red:
	var red;
    if (temperature <= 66)
        red = 255;
    else{
        red = temperature - 60;
        red = 329.698727446 * (red ^ -0.1332047592);
        if (red < 0) red = 0;
        if (red > 255) red = 255;
    }
    
    //Calculate green:
	var green;
    if (temperature <= 66){
        green = temperature;
        green = 99.4708025861 * Math.log(green) - 161.1195681661;
        if (green < 0) green = 0;
        if (green > 255) green = 255;
	}
    else{
        green = temperature - 60;
        green = 288.1221695283 * (green ^ -0.0755148492);
        if (green < 0) green = 0;
        if (green > 255) green = 255;
    }
    
    //Calculate blue:
	var blue;
    if (temperature >= 66)
        blue = 255;
    else{
        if (temperature <= 19)
            blue = 0;
        else{
            blue = temperature - 10;
            blue = 138.5177312231 * Math.log(blue) - 305.0447927307;
            if (blue < 0) blue = 0;
            if (blue > 255) blue = 255;
        }
	}
	var color = {
		r: red,
		g: green,
		b: blue
	};
	
	return color;
}