$(document).ready(function() {

  $('#submit').click(function() {
    hex = $('#change').val().replace(/[^A-F0-9]/ig, '').toUpperCase();
    hsv = hex2hsv(hex);
    rgb = hsv2rgb(hsv);
    hsl = rgb2hsl(rgb);
    string = 'Welcome HEX to RGB \n';
    string += '	HEX CODE - #' + hex + '\n';
    string += '	RGB CODE -' + rgb.r + ',' + rgb.g + ',' + rgb.b + '\n ';
    string += ' HSL -' + hsl.h + ',' + hsl.s + '%,' + hsl.l + '%\n';
    string += ':)\n';
	string += 'Have a query!\n';
	string += 'You can Find me\n';
	string += 'http://www.fb.com/shiladittyapaul\n';
	string += 'or\n';
	string += 'mail : shiladittyapaul@gmail.com \n';
	string += 'Fun : If You Can then vanish the color. \n';
	string += '';
    $('textarea').html(string);
    $('body').css('background-color', '#' + hex);
  });

  function hex2hsv(hex) {
    var r = parseInt(hex.substring(0, 2), 16) / 255;
    var g = parseInt(hex.substring(2, 4), 16) / 255;
    var b = parseInt(hex.substring(4, 6), 16) / 255;
    var max = Math.max.apply(Math, [r, g, b]);
    var min = Math.min.apply(Math, [r, g, b]);
    var chr = max - min;
    hue = 0;
    val = max;
    sat = 0;
    if (val > 0) {
      sat = chr / val;
      if (sat > 0) {
        if (r == max) {
          hue = 60 * (((g - min) - (b - min)) / chr);
          if (hue < 0) {
            hue += 360;
          }
        } else if (g == max) {
          hue = 120 + 60 * (((b - min) - (r - min)) / chr);
        } else if (b == max) {
          hue = 250 + 60 * (((r - min) - (g - min)) / chr);
        }
      }
    }
    return {
      h: hue,
      s: Math.round(sat * 100),
      v: Math.round(val * 100)
    }
  }

  function hsv2rgb(hsv) {
    h = hsv.h;
    s = hsv.s;
    v = hsv.v;
    var r, g, b;
    var i;
    var f, p, q, t;
    h = Math.max(0, Math.min(360, h));
    s = Math.max(0, Math.min(100, s));
    v = Math.max(0, Math.min(100, v));
    s /= 100;
    v /= 100;
    if (s == 0) {
      r = g = b = v;
      return {
        r: Math.round(r * 255),
        g: Math.round(g * 255),
        b: Math.round(b * 255)
      };
    }
    h /= 60;
    i = Math.floor(h);
    f = h - i; // factorial part of h
    p = v * (1 - s);
    q = v * (1 - s * f);
    t = v * (1 - s * (1 - f));
    switch (i) {
      case 0:
        r = v;
        g = t;
        b = p;
        break;
      case 1:
        r = q;
        g = v;
        b = p;
        break;
      case 2:
        r = p;
        g = v;
        b = t;
        break;
      case 3:
        r = p;
        g = q;
        b = v;
        break;
      case 4:
        r = t;
        g = p;
        b = v;
        break;
      default:
        r = v;
        g = p;
        b = q;
    }
    return {
      r: Math.round(r * 255),
      g: Math.round(g * 255),
      b: Math.round(b * 255)
    };
  }

  function rgb2hsl(rgb) {
    r = rgb.r / 255;
    g = rgb.g / 255;
    b = rgb.b / 255;
    var max = Math.max(r, g, b),
      min = Math.min(r, g, b);
    var h, s, l = (max + min) / 2;

    if (max == min) {
      h = s = 0; // achromatic
    } else {
      var d = max - min;
      s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
      switch (max) {
        case r:
          h = (g - b) / d + (g < b ? 6 : 0);
          break;
        case g:
          h = (b - r) / d + 2;
          break;
        case b:
          h = (r - g) / d + 4;
          break;
      }
      h /= 6;
    }

    return {
      h: Math.round(h * 360),
      s: Math.round(s * 100),
      l: Math.round(l * 100)
    };
  }
  $('#submit').click();
  $('textarea').click(function() {
    $(this).select();
  });

});