/*
 * L.Control.Close 
 */

L.Control.Close = L.Control.extend({
	options: {
		position: 'topleft',
		title: 'Close map',
		symbol: ''
		// symbol: ''
	},
	self: this,

	onAdd: function (map) {
		var zoomName = 'leaflet-control-close',
		    container = L.DomUtil.create('div', zoomName + ' leaflet-bar');

		this._map = map;

		this._button = this._createButton(
		        this.options.symbol, this.options.title,
		        zoomName + '-btn',  container, this._onClick,  this);

		return container;
	},

	_onClick: function (e) {
		if (typeof(this.options.onClick) == "function") {
			this.options.onClick(false);
		}
	},

	_createButton: function (html, title, className, container, fn, context) {
		var link = L.DomUtil.create('a', className, container);
		link.innerHTML = html;
		link.href = '#';
		link.title = title;

		var stop = L.DomEvent.stopPropagation;

		L.DomEvent
		    .on(link, 'click', stop)
		    .on(link, 'mousedown', stop)
		    .on(link, 'dblclick', stop)
		    .on(link, 'click', L.DomEvent.preventDefault)
		    .on(link, 'click', fn, context)
		    .on(link, 'click', this._refocusOnMap, context);

		return link;
	}
});


L.control.close = function (options) {
	return new L.Control.Close(options);
};