/*
 * L.Control.Fullscreen 
 */

L.Control.Fullscreen = L.Control.extend({
	options: {
		position: 'topleft',
		title: 'View map in full screen',
		symbolMaximize: '',
		symbolMinimize: ''
	},
	self: this,

	onAdd: function (map) {
		var zoomName = 'leaflet-control-fullscreen',
		    container = L.DomUtil.create('div', zoomName + ' leaflet-bar');

		this._map = map;

		this._button = this._createButton(
		        this.options.symbolMaximize, this.options.title,
		        zoomName + '-btn',  container, this._onClick,  this);

		return container;
	},

	_onClick: function (e) {
		if (L.DomUtil.hasClass(this._button, 'active')) {
			L.DomUtil.removeClass(this._button, 'active')
			this._button.innerHTML = this.options.symbolMaximize;
			if (typeof(this.options.onClick) == "function") {
				this.options.onClick(false);
			}
		} else {
			L.DomUtil.addClass(this._button, 'active')
			this._button.innerHTML = this.options.symbolMinimize;
			if (typeof(this.options.onClick) == "function") {
				this.options.onClick(true);
			}
		}
	},

	_createButton: function (html, title, className, container, fn, context) {
		var link = L.DomUtil.create('a', className, container);
		link.innerHTML = html;
		link.href = '#';
		link.title = title;

		var stop = L.DomEvent.stopPropagation;

		L.DomEvent
		    .on(link, 'click', stop)
		    .on(link, 'mousedown', stop)
		    .on(link, 'dblclick', stop)
		    .on(link, 'click', L.DomEvent.preventDefault)
		    .on(link, 'click', fn, context)
		    .on(link, 'click', this._refocusOnMap, context);

		return link;
	}
});


L.control.fullscreen = function (options) {
	return new L.Control.Fullscreen(options);
};