/*
 * L.Control.LocationMarker 
 */

L.Control.LocationMarker = L.Control.extend({
	options: {
		position: 'topleft',
		title: 'Show current location',
		msg: 'You are within $r meters from this point.',
		symbol: ''
	},
	self: this,

	onAdd: function (map) {
		var zoomName = 'leaflet-control-locationmarker',
		    container = L.DomUtil.create('div', zoomName + ' leaflet-bar');

		this._map = map;

		this._locationButton  = this._createButton(
		        this.options.symbol, this.options.title,
		        zoomName + '-btn',  container, this._locate,  this);
	
		this._markerLocationRequested = false;
		this._map.on('locationfound', this._onLocationFound, this);
		this._map.on('locationerror', this._onLocationError, this);
		this._spinner = new Spinner({color: '#fff', length: 4, lines: 15, radius: 8, width: 2}).spin(this._locationButton).stop();

		return container;
	},

	setMessage: function(text) {
		this.options.msg = text;
	},

	_onLocationFound: function(e) {
		if (this._markerLocationRequested) {
			this._spinner.stop();
		    var radius = parseInt(e.accuracy / 2);

		    this._marker = L.marker(e.latlng).addTo(this._map)
		        .bindPopup(this.options.msg.replace(/\$r/g, radius)).openPopup();

		    this._markerRadius = L.circle(e.latlng, radius).addTo(this._map);
		    this._markerLocationRequested = false;
		}
	},

	_onLocationError: function(e) {
		if (this._markerLocationRequested) {
			this._spinner.stop();
			L.DomUtil.removeClass(this._locationButton, 'active')
		    this._markerLocationRequested = false;
		}
	},

	_locate: function (e) {
		if (L.DomUtil.hasClass(this._locationButton, 'active')) {
			L.DomUtil.removeClass(this._locationButton, 'active')
			this._map.removeLayer(this._markerRadius);
			this._map.removeLayer(this._marker);
		} else {
			L.DomUtil.addClass(this._locationButton, 'active')
			// $(this._container).spin({color: '#fff', length: 4, lines: 15, radius: 8, width: 2});
			this._spinner.spin(this._locationButton);
			this._map.locate({setView: true, maxZoom: 6, maximumAge: 60000});
			this._markerLocationRequested = true;
		//	this._map.zoomIn(e.shiftKey ? 3 : 1);
		}
	},

	_createButton: function (html, title, className, container, fn, context) {
		var link = L.DomUtil.create('a', className, container);
		link.innerHTML = html;
		link.href = '#';
		link.title = title;

		var stop = L.DomEvent.stopPropagation;

		L.DomEvent
		    .on(link, 'click', stop)
		    .on(link, 'mousedown', stop)
		    .on(link, 'dblclick', stop)
		    .on(link, 'click', L.DomEvent.preventDefault)
		    .on(link, 'click', fn, context)
		    .on(link, 'click', this._refocusOnMap, context);

		return link;
	}
});


L.control.locationMarker = function (options) {
	return new L.Control.LocationMarker(options);
};