/*
 * L.Control.Message 
 */

L.Control.Message = L.Control.extend({
	options: {
		position: 'bottomleft',
		message: 'Message'
	},
	self: this,

	onAdd: function (map) {
		this.container = L.DomUtil.create('div', 'leaflet-control-message');
		this.container.innerHTML = '<p>'+this.options.message+'</p>';

		this._map = map;

		return this.container;
	},

	changeMessage: function(text) {
		this.container.innerHTML = '<p>'+text+'</p>';
	},

	hide: function() {
		L.DomUtil.addClass(this.container, 'hidden');
	},

	show: function(text) {
		if (text) {
			this.changeMessage(text);
		}
		L.DomUtil.removeClass(this.container, 'hidden');
	}	
});


L.control.message = function (options) {
	return new L.Control.Message(options);
};