var casper = require('casper').create({
});

casper.start('../index.html', function() {
})

casper.then(function() {
    var t = this.test;
    t.assertTitle('Compound Interest Calculator');
    t.assertVisible('#input');
    this.fill('#input form', {
        'amount': '1000',
        'rate': '5',
        'years': '10',
    });
    this.click('#input button');
    t.assertVisible('#results');
    t.assertNotVisible('#input');
    t.assertSelectorHasText('tr:nth-child(1) td:nth-child(2)', '1,628.91');
    t.assertNotVisible('#input');
    t.assertNotVisible('tr:nth-child(5)');
    this.clickLabel('Expand');
    t.assertVisible('tr:nth-child(5)');
    this.clickLabel('Back');
    t.assertVisible('#input');
    t.assertNotVisible('#results');
    this.fill('#input form', {
        'amount': '1000',
        'rate': '5',
        'years': 'xyz',
    });
    this.click('#input button');
    t.assertNotVisible('#results');
});

casper.run(function() {
    this.exit();
});
