/**
 * common.js
 *
 * contains common functions
 *
 * Copyright(c) 2013 Pavle Goloskokovic
 *
 * This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
 * http://creativecommons.org/licenses/by-nc-sa/3.0/
 */

/**
 * Function that returns width and height of browser's viewport
 * @returns {{width: *, height: *}}
 */
function viewport(){
    var e = window, a = 'inner';
    if (!( 'innerWidth' in window )){a = 'client';e = document.documentElement || document.body;}
    return { width : e[ a+'Width' ] , height : e[ a+'Height' ] }
}

/**
 * Function that examines whether the object is located within a certain radius in relation to our coordinates
 * @param obj - Object
 * @param myX - Our x coordinate
 * @param myY - Our y coordinate
 * @param radius - Radius value
 * @returns {boolean}
 */
function inCircle(obj, myX, myY, radius){
    return vectorMagnitude(myX,obj.x,myY,obj.y) <= radius;
}

/**
 * Function that returns the magnitude of a 2D vector
 * @param x1
 * @param x2
 * @param y1
 * @param y2
 * @returns {number}
 */
function vectorMagnitude(x1,x2,y1,y2){
    var dx = x1-x2;
    var dy = y1-y2;
    return Math.sqrt(dx*dx + dy*dy);
}
/**
 * Sign function
 * @param foo
 * @returns {number}
 */
function sign(foo){
    return foo<0?-1:1;
}
