/**
 * events.js
 *
 * contains logic for handling game canvas input events
 *
 * Copyright(c) 2013 Pavle Goloskokovic
 *
 * This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
 * http://creativecommons.org/licenses/by-nc-sa/3.0/
 */

/**
 * Global array of events
 * @type {Array}
 */
var gEvents = [];

/**
 * Callback function for onclick event for game canvas
 * @param event
 */
function onCanvasClick(event) {

    event = event || window.event;
    var x = event.pageX - event.currentTarget.offsetLeft;
    var y = event.pageY - event.currentTarget.offsetTop;

    var eventObj = {x:x,y:y};

    if(game.isPaused){
        checkPauseBtnEvent(eventObj);
    }else{
        gEvents.unshift(eventObj);
    }
}

/**
 * Function for handling cashed events, to be called from game loop function
 */
function handlePlayStateEvents(){
    while(true){
        var eventObj = gEvents.pop();
        if(eventObj === undefined){
            break;
        }
        __handlePlayStateEventInternal(eventObj);
    }
}

/**
 * Function that checks for pause button event
 * @param obj - Event object
 * @returns {boolean} - Returns whether the pause button was clicked
 */
function checkPauseBtnEvent(obj){
    var numOfMapItems = game.maps[game.level].mapItems.length;

    for(var i=0; i<numOfMapItems; i++){
        var item = game.maps[game.level].mapItems[i];
        if(item instanceof StatusBar){
            if(obj.x>item.x+65 && obj.x<item.x+95 && obj.y>item.y-15 && obj.y<item.y+15){
                game.togglePause();
                return true;
            }
        }
    }

    return false;
}

/**
 *  Function for mapping event coordinates to actions
 * @param obj - Event object
 * @private
 */
function __handlePlayStateEventInternal(obj){

    var eventMapped = checkPauseBtnEvent(obj);

    for(var i=0; i<game.platforms.length; i++){

        var platform = game.platforms[i];
		//obj.y = (obj.y-50);
		//obj.x = (obj.x-50);

        if(eventMapped){
            platform.displayDialog = false;
            continue;
        }
        if(!platform.displayDialog){
            if(inCircle(platform,obj.x,obj.y,30)){
                platform.displayDialog = true;
                pushPlatformInFront(platform);
                eventMapped = true;
            }
        }else{

            var pX = platform.x;
            var pY = platform.y;

            if(platform.tower !== null){

                if(obj.x>pX-40 && obj.x<pX-40+40 && obj.y>pY-55 && obj.y<pY-55+40){
                    game.status.money+=platform.tower.sellPrice;
                    platform.tower = null;
                    platform.displayDialog = false;
                    pushPlatformBehind(platform);

                    gSM.playSound("./audio/coins.ogg");

                    eventMapped = true;
                    continue;
                }
                else if(obj.x>pX && obj.x<pX+40 && obj.y>pY-55 && obj.y<pY-55+40){
                    platform.displayDialog = false;
                    pushPlatformBehind(platform);
                    eventMapped = true;
                    continue;
                }

            }else{

                var tower = null;

                if(obj.x>pX-58 && obj.x<pX-58+37 && obj.y>pY-61 && obj.y<pY-61+57){
                    tower = new JunkTower(platform);
                }
                else if(obj.x>pX-15 && obj.x<pX-15+37 && obj.y>pY-61 && obj.y<pY-61+57){
                    tower = new PlasmaTower(platform);
                }
                else if(obj.x>pX+27 && obj.x<pX+27+37 && obj.y>pY-61 && obj.y<pY-61+57){
                    tower = new RocketTower(platform);
                }
                else if(obj.x>pX+72 && obj.x<pX+72+20 && obj.y>pY-52 && obj.y<pY-52+20){
                    platform.displayDialog = false;
                    pushPlatformBehind(platform);
                    eventMapped = true;
                    continue;
                }

                if(tower!=null && game.status.money>=tower.buyPrice){
                    game.status.money-=tower.buyPrice;
                    platform.tower = tower;
                    platform.displayDialog = false;
                    pushPlatformBehind(platform);

                    gSM.playSound("./audio/coins.ogg");

                    eventMapped = true;
                    continue;
                }

                if(tower!=null && game.status.money<tower.buyPrice){
                    eventMapped = true;

                    continue;
                }
            }

            platform.displayDialog = false;
            pushPlatformBehind(platform);
        }
    }
}