/**
 * game.js

 */


var CANVAS_WIDTH = 788;
var CANVAS_HEIGHT = 1280;

/**
 * Enum for representing game states
 * @type {{MENU_STATE: number, PLAY_STATE: number, END_STATE: number}}
 */
var GameState = {
    MENU_STATE: 1,
    PLAY_STATE: 2,
    END_STATE: 3
};

/**

 */
var game = null;

/**
 */
window.onload = function(){
    initSoundManager();
    game = new Game();
    positionElements();
};

/**

 */
window.onresize = function(event) {
    positionElements();
};

window.onfocus = function(){
    if(game){
        if(game.isFocused){
            return;
        }
        game.isFocused = true;
        if(!game.wasPausedOnBlur){
            game.continueGame();
        }
    }
};
window.onblur = function(){
    if(game){
        if(!game.isFocused){
            return;
        }
        game.isFocused = false;
        game.wasPausedOnBlur = game.isPaused;
        if(!game.wasPausedOnBlur){
            game.pauseGame();
        }
    }
};
/**
 * Class that represents the game object
 * @type {*}
 */
var Game = Class.extend({
    /**
     * Game constructor
     */
    init: function(){

        this.canvas = document.getElementById('game_canvas');
		var v = viewport();
        this.canvas.width = CANVAS_WIDTH; //v.height;
        this.canvas.height = CANVAS_HEIGHT; //v.height;
        this.ctx = this.canvas.getContext('2d');
        this.clearCanvas();

        this.level = 0; // 1st level
        this.platforms = [];
        this.maps = [new TiledMapClass(this.ctx)];
        this.maps[0].load("tld/level1map.json");
        this.status = {};

        var thiz = this;
        xhrGet("tp/gameAtlas.json",function(){

            var response = this.response;
            var ssc = new SpriteSheetClass();

            ssc.load("tp/gameAtlas.png",function(){

                ssc.parseAtlasDefinition(response);
                thiz.initMenuState();

                thiz.canvas.onclick = onCanvasClick;

                thiz.background = new Background();
            });
        });
    },
    status: null,
    canvas: null,
    ctx: null,
    background: null,
    waveManager: null,
    platforms: null,
    bullets: null,
    enemies: null,
    animations: null,

    onPlayStateNextFrameIntervalId: 0,

    isPaused: false,
    wasPausedOnBlur: false,
    isFocused: true,

    clearCanvas: function(){
        this.ctx.fillStyle = "#000";
		//var v = viewport();
        //this.canvas.width = v.width;
        //this.canvas.height = v.height;
		//var CANVAS_WIDTH = 700;
       //var CANVAS_HEIGHT = 600;
        this.ctx.fillRect(0,0,CANVAS_WIDTH,CANVAS_HEIGHT);
    },

    /**
     * Main loop function
     */
    onPlayStateNextFrame: function(){

        if(game == null){return;}

        //update

        //update animation for map items
        for(i=0; i<game.maps[game.level].mapItems.length; i++){
            game.maps[game.level].mapItems[i].update();
        }
        //update enemies
        for(i=0; i<game.enemies.length; i++){
            game.enemies[i].update();
        }
        //update animations
        for(i=0; i<game.animations.length; i++){
            game.animations[i].update();
        }

        //sort enemies by their path progress for shooting
        game.enemies.sort(function(foo,bar){return (foo.progress>bar.progress?-1:1);});

        //update bullets
        for(i=0; i<game.bullets.length; i++){
            game.bullets[i].update();
        }
        //update all platforms
        for(i=0; i<game.platforms.length; i++){
            game.platforms[i].update();
        }

        //update wave manager
        game.waveManager.update();

        //sort enemies for next drawing
        game.enemies.sort(function(foo,bar){return (foo.y<bar.y?-1:1);});


        //handle events

        handlePlayStateEvents();


        //clear stage
        game.ctx.clearRect(0,0,CANVAS_WIDTH, CANVAS_HEIGHT);

        //draw

        //draw map
        game.maps[game.level].draw();

        //draw platforms behind enemies
        for(i=0; i<game.maps[game.level].platformsBehind.length; i++){
            game.maps[game.level].platformsBehind[i].drawPlatform();
        }
        //draw enemies
        for(i=0;i<game.enemies.length; i++){
            game.enemies[i].drawEnemy();
        }
        //draw animations
        for(i=0;i<game.animations.length; i++){
            game.animations[i].draw();
        }
        //draw map items
        for(var i=0; i<game.maps[game.level].mapItems.length; i++){
            game.maps[game.level].mapItems[i].drawMapItem();
        }
        //draw platforms in front of enemies
        for(i=0; i<game.maps[game.level].platformsInFront.length; i++){
            game.maps[game.level].platformsInFront[i].drawPlatform();
        }
        //draw bullets
        for(i=0; i<game.bullets.length; i++){
            game.bullets[i].drawBullet();
        }
    },

    /**
     * Function that handles game state change
     * @param nextState
     */
    changeState: function(nextState){

        if(nextState == this.status.state){return;}

        switch(nextState){
            case GameState.MENU_STATE:
                this.initMenuState();
                break;
            case GameState.PLAY_STATE:
                this.initPlayState();
                break;
            case GameState.END_STATE:
                this.initEndState();
                break;
        }

        this.status.state = nextState;
    },

    initMenuState: function(){

        if(this.status.state){
            gSM.stopAll();
            //gSM.playSound("./audio/menu.ogg",{looping:true,volume:0.07});
        }
        this.status = {
            state: GameState.MENU_STATE
        };
        var endState = document.getElementById('end_state');
        endState.style.display = '';
        var menuState = document.getElementById('menu_state');
        var muteBtn = document.getElementById('mute-toggle');
        menuState.style.display = muteBtn.style.display = 'block';
    },

    initPlayState: function(){

        gSM.stopAll();
        //gSM.playSound("./audio/play.ogg",{looping:true,volume:0.07});

        this.status = {
            state: GameState.PLAY_STATE,
            lives:20,
            money: 100
        };
        this.bullets = [];
        this.enemies = [];
        this.animations = [];

        this.waveManager = new WaveManager(2000);

        for(var i=0; i<game.platforms.length; i++){
            game.platforms[i].clearTower();
        }

        this.clearCanvas();

        var endState = document.getElementById('end_state');
        endState.style.display = '';
        var menuState = document.getElementById('menu_state');
        menuState.style.display = '';

        this.onPlayStateNextFrameIntervalId = setInterval(this.onPlayStateNextFrame, 1000/30);
    },

    initEndState: function(){
        this.clearCanvas();
        var endState = document.getElementById('end_state');
        endState.style.display = 'block';
        gSM.stopAll();
        if(game.status.lives>0){
            endState.classList.remove('end-state-lost');
            endState.classList.add('end-state-won');
            //gSM.playSound("./audio/end-win.ogg",{looping:true,volume:0.07});
        }else{
            endState.classList.remove('end-state-won');
            endState.classList.add('end-state-lost');
            //gSM.playSound("./audio/end-lost.ogg",{looping:true,volume:0.07});
        }
        this.status = {
            state: GameState.END_STATE
        };
    },

    endGame: function(){
        var thiz = this;
        setTimeout(function(){
            clearInterval(thiz.onPlayStateNextFrameIntervalId);
            thiz.onPlayStateNextFrameIntervalId = 0;
            thiz.changeState(GameState.END_STATE);
        }, 1500);
    },

    pauseGame: function(){

        if(this.status.state != GameState.PLAY_STATE || this.isPaused){
            return;
        }

        this.isPaused = true;

        var nowMs = new Date().getTime();

        if(this.waveManager && this.waveManager.ready){
            var w = this.waveManager.waves[this.waveManager.currWave];
            w.pausedDeltaTimeMs = nowMs - w.lastTickTime.getTime();
        }

        var numOfPlatforms = this.platforms.length;
        for(var i=0; i<numOfPlatforms; i++){
            var t = this.platforms[i].tower;
            if(t != null){
                t.pausedDeltaTimeMs = nowMs - t.lastTickTime.getTime();
            }
        }

        clearInterval(this.onPlayStateNextFrameIntervalId);
        this.onPlayStateNextFrameIntervalId = 0;
    },

    continueGame: function(){

        if(this.status.state != GameState.PLAY_STATE || !this.isPaused){
            return;
        }

        this.isPaused = false;

        var nowMs = new Date().getTime();

        if(this.waveManager && this.waveManager.ready){
            var w = this.waveManager.waves[this.waveManager.currWave];
            w.lastTickTime = new Date(nowMs - w.pausedDeltaTimeMs);
            w.pausedDeltaTimeMs = 0;
        }

        var numOfPlatforms = this.platforms.length;
        for(var i=0; i<numOfPlatforms; i++){
            var t = this.platforms[i].tower;
            if(t != null){
                t.lastTickTime = new Date(nowMs - t.pausedDeltaTimeMs);
                t.pausedDeltaTimeMs = 0;
            }
        }

        this.onPlayStateNextFrameIntervalId = setInterval(this.onPlayStateNextFrame, 1000/30);
    },

    togglePause: function(){
        if(this.isPaused){
            this.continueGame();
        }else{
            this.pauseGame();
        }
    }


});





