/**
 * wave.js
 *
 * contains all classes and logic for waves of enemies
 *
 * Copyright(c) 2013 Pavle Goloskokovic
 *
 * This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
 * http://creativecommons.org/licenses/by-nc-sa/3.0/
 */

/**
 * Class representing a wave manager object
 * This class is responsible for manipulating
 * waves of enemies and adding new enemies to the game
 * @type {*}
 */
var WaveManager = Class.extend({
    /**
     * WaveManager class constructor that takes
     * one param which represents amount of time
     * needed to pass before it starts adding enemies
     * to map
     * @param waitTime
     */
    init: function(waitTime){

        /**
         * Array of enemy waves which is being initialised inside
         * of this constructor
         * @type {Array}
         */
        this.waves = [];

        var wave = new Wave(5000,this,5000);
        wave.pushEnemyToEnd(Rabbit,3);
        this.waves.push(wave);

        wave = new Wave(5000,this,5000);
        wave.pushEnemyToEnd(Rabbit,6);
        this.waves.push(wave);

        wave = new Wave(5000,this,5000);
        wave.pushEnemyToEnd(Rabbit,9);
        this.waves.push(wave);

        wave = new Wave(5000,this,5000);
        wave.pushEnemyToEnd(Rabbit,15);
        this.waves.push(wave);

        wave = new Wave(5000,this,5000);
        wave.pushEnemyToEnd(Rabbit,5);
        this.waves.push(wave);

        wave = new Wave(10000,this,5000);
        for(var i=0; i<5; i++){
            //wave.pushEnemyToEnd(Dog,1);
            wave.pushEnemyToEnd(Rabbit,1);
        }
        this.waves.push(wave);

        wave = new Wave(5000,this,5000);
        //wave.pushEnemyToEnd(Dog,6);
        wave.pushEnemyToEnd(Rabbit,6);
        this.waves.push(wave);

        wave = new Wave(5000,this,5000);
        //wave.pushEnemyToEnd(Cat,6);
        wave.pushEnemyToEnd(Rabbit,6);
        this.waves.push(wave);

        wave = new Wave(5000,this,5000);
        wave.pushEnemyToEnd(Rabbit,5);
        //wave.pushEnemyToEnd(Dog,5);
        this.waves.push(wave);

        wave = new Wave(10000,this,0);
        //wave.pushEnemyToEnd(Cat,10);
        wave.pushEnemyToEnd(Rabbit,10);
        this.waves.push(wave);

        wave = new Wave(5000,this,0);
        wave.pushEnemyToEnd(Rabbit,3);
        this.waves.push(wave);

        setTimeout(function(){
            game.waveManager.ready = true;
        }, waitTime);

    },
    waves: null,
    currWave: 0,
    ready: false, ended: false,

    update : function(){
        if(this.ready && !this.ended){
            this.waves[this.currWave].tick();
        }
    },

    currentWaveFinished : function(){
        this.currWave++;
        if(this.currWave == this.waves.length){
            this.currWave--;
            this.ended = true;
        }
    }
});

/**
 * Class representing waves of enemies
 * @type {*}
 */
var Wave = Class.extend({

    /**
     * Wave class constructor that takes as params duration of this wave,
     * object of wave manager class and time that another wave should wait
     * after this wave finishes
     * @param interval
     * @param manager
     * @param timeAfter
     */
    init: function(interval, manager, timeAfter){
        this.interval = interval;
        this.manager = manager;
        this.timeAfter =  timeAfter;
        this.path = game.maps[game.level].path;
        this.numOfEnemies = [];
        this.enemyTypes = [];
    },

    interval: 0,
    tickInterval: 0,
    lastTickTime: null,
    pausedDeltaTimeMs: 0,
    timeAfter: 0,
    numOfEnemies: null,
    enemyTypes: null,
    index: 0,
    enemiesTogether: 0,
    manager: null,
    path: null,
    ended: false,

    /**
     * This function adds certain number of certain type of enemies
     * to this wave
     * @param enemyClass
     * @param enemiesCount
     */
    pushEnemyToEnd: function(enemyClass, enemiesCount){

        this.numOfEnemies.push(enemiesCount);
        this.enemyTypes.push(enemyClass);
        this.enemiesTogether += enemiesCount;
        this.tickInterval = this.interval / this.enemiesTogether;
    },

    /**
     * Function that measures time and checks if
     * enough time passed so that new enemy can be added
     * to the map
     */
    tick: function(){

        if(!this.ended){
            if(this.lastTickTime == null || (new Date()).getTime()-this.lastTickTime.getTime()>=this.tickInterval){
                if(this.lastTickTime == null){
                    this.lastTickTime = new Date();
                }else{
                    this.lastTickTime = new Date(this.lastTickTime.getTime() + this.tickInterval);
                }

                this.createEnemy();
            }
        }else{
            var now = new Date();
            this.timeAfter -= now.getTime()-this.lastTickTime.getTime();

            if(this.timeAfter <= 0){
                this.manager.currentWaveFinished();
            }else{
                this.lastTickTime = now;
            }
        }
    },

    createEnemy : function(){

        game.enemies.push(new this.enemyTypes[this.index]());
        this.numOfEnemies[this.index]--;
        if(this.numOfEnemies[this.index] <= 0){
            this.index++;
            if(this.index == this.numOfEnemies.length){
                this.ended = true;
            }
        }
    }
});