// El codigo y los datos son propiedad de Andres Felipe OSPINA BANOL cefiahb@hotmail.com

/*
 * Set the class attributes pre-selected
 */
function setClassPreSelected (element, listOptions) {
	var classList = "";
	for (index in listOptions) {
		classList += CLASS_LIST_OPTIONS[listOptions[index]];
	}
	element.setAttributeNode(cA(CLASS, classList));
}

/*
 * Capture the orientation change of device
 */
/*function handleOrientation (event, divListContacts, body) {
	try {
		resizeContactWaitingIcon (body);
		
	} catch (e) {
		alert(e);
	}
}*/

/*
 * Resize the contact's wait icon element when the size screen change 
 */
function resizeContactWaitingIcon (body) {
	try {
		if (gEBI("waitingIconMenu") != undefined) {
			createWaitingIcon(body, false);
			createWaitingIcon(body, true);
		}
	} catch (e) {
		alert(e);
	}
}

/*
 * Creation an destruction of waiting icon 
 */
function createWaitingIcon(body, active){
	try {
		
		if (active) {			
			var ss = screenSize();
					
			var img = cE("img");
			img.setAttributeNode(cA(CLASS, "waiting-icon"));
			img.setAttributeNode(cA("src", "img/icons/waiting_icon.gif"));
			
			var divW = cE("div");
			var styleW = "width:10rem;height:10rem;position:fixed;";
			divW.setAttributeNode(cA("style", styleW));
			divW.setAttributeNode(cA("id", "waitingIconMenu"));
			
			aC(divW,img);
			aC(body,divW);
			
			var divSize = {"width":divW.offsetWidth, "height":divW.offsetHeight};	
			divW.setAttributeNode(cA("style", styleW + "left:" + parseInt(ss.width / 2 - divSize.width / 2) + "px;top:" + parseInt(ss.height / 2 - divSize.height / 2) + "px;"));
						
		} else {
			if (existNoNull(gEBI("waitingIconMenu"))) {
				body.removeChild(gEBI("waitingIconMenu"));
			}	
		}
	} catch (e) {
		alert(e);
	}
}

/*
 * Creation of message label for the message screen
 */
function messageDomPreBuilder(msg){
	var trMsg = cE("tr");
	var tdMsg = cE("td");
	var spanMsg = cE("span");
	spanMsg.innerHTML = msg;
	aC(tdMsg, spanMsg);
	aC(trMsg, tdMsg);
	return trMsg;
}

/*
 * Creation of message button for the message screen
 */
function messageButtonDomPreBuilder(msg, onClickFunction){
	var trButton = cE("tr");
	var tdButton = cE("td");
	var buttonMsg = cE("button");
	buttonMsg.innerHTML = msg;
	buttonMsg.onclick = onClickFunction;
	aC(tdButton, buttonMsg);
	aC(trButton, tdButton);
	return trButton;
}

/*
 * Message screen alert
 */
function messageScreen (body, msg) {
	
	var ss = screenSize();
	
	var divMsg = cE("div");
	divMsg.setAttributeNode(cA("id", "divMsg"));
	divMsg.setAttributeNode(cA(CLASS, CLASS_MESSAGE_SCREEN));
	divMsg.setAttributeNode(cA("style", "width:" + ss.width + "px;height:" + ss.height + "px;"));
	
	var table = cE("table");
	
	aC(table, messageDomPreBuilder(msg));
	aC(table, messageButtonDomPreBuilder("OK", function () { body.removeChild(gEBI("divMsg")); }));
	
	var spanTable = cE("span");	
	aC(spanTable, table);		
	aC(divMsg, spanTable);
	aC(body,divMsg);
	spanTable.setAttributeNode(cA("style", "opacity:1;position:fixed;left:" + parseInt((ss.width / 2) - (table.offsetWidth / 2)) + "px;top:" + parseInt((ss.height / 2) - (table.offsetHeight / 2)) + "px;"));
	
}

/*
 * Message screen alert
 */
function messageConfirmScreen (body, msg, ifYes, ifNot) {
	
	var ss = screenSize();
	
	var divMsg = cE("div");
	divMsg.setAttributeNode(cA("id", "divMsg"));
	divMsg.setAttributeNode(cA(CLASS, CLASS_MESSAGE_SCREEN));
	divMsg.setAttributeNode(cA("style", "width:" + ss.width + "px;height:" + ss.height + "px;"));
	
	var table = cE("table");
	
	aC(table, messageDomPreBuilder(msg));
	aC(table, messageButtonDomPreBuilder("YES", function () { body.removeChild(gEBI("divMsg")); ifYes(); }));	
	aC(table, messageButtonDomPreBuilder("NO", function () { body.removeChild(gEBI("divMsg")); ifNot(); }));

	var spanTable = cE("span");	
	aC(spanTable, table);		
	aC(divMsg, spanTable);
	aC(body,divMsg);
	spanTable.setAttributeNode(cA("style", "opacity:1;position:fixed;left:" + parseInt((ss.width / 2) - (table.offsetWidth / 2)) + "px;top:" + parseInt((ss.height / 2) - (table.offsetHeight / 2)) + "px;"));
	
}

/*
 * Creation of button element for Action Menu
 */
function actionMenuButtonDomPreBuilder(onClickFunction, msg, classListButton){
	var tr = cE("tr");
	var button = cE("button");
	tr.onclick = onClickFunction;
	setClassPreSelected(button, classListButton);
	button.setAttributeNode(cA("style", "opacity:1;"));
	var tdB = cE("td");
	aC(tdB, button);
	aC(tr, tdB);
	var span = cE("span");
	span.innerHTML = msg;
	var tdS = cE("td");
	aC(tdS, span);
	aC(tr, tdS);
	return tr;
}

/*
 * Creation of button element for Actions contact
 * options:[{classIcon, textButton, onClickFunction}]
 */
function builderMenuActionsContact (dad, options) {
	var ul = cE('ul');
	setClassPreSelected(ul, [20]);
	for (var index = 0; index < options.length; index++) {
		var li = cE("li");
		li.onclick = options[index].onClickFunction;

		var photoDiv = cE("div");
		setClassPreSelected(photoDiv, options[index].classIcon);
		aC(li, photoDiv);

		var spanText = cE("span");
		spanText.innerHTML = options[index].textButton;
		aC(li, spanText);
		aC(ul, li);
	}
	aC(dad, ul);
}