// El codigo y los datos son propiedad de Andres Felipe OSPINA BANOL cefiahb@hotmail.com
	
/*
 * Create the button's elements for the contact list view
 */
function createSpanButtonForContactList(dad, onClickFunction, classesForButton, classesForSpanButton) {
	var button = cE("button");
	button.onclick = onClickFunction;
	setClassPreSelected(button, classesForButton);
	var spanButton = cE("span");
	setClassPreSelected(spanButton, classesForSpanButton);
	aC(spanButton,button);
	aC(dad,spanButton);
	return {'spanButton':spanButton, 'button':button};
}

/*
 * Creation of the contact's element of list
 * cn = text of contact
 * 
 */
function createContactlistElement(cn, id, photo){	
	var li = cE("li");
	li.setAttributeNode(cA("id", id)); 
	li.onclick = function () {
		if (!contactSelectedByMenu || actionsContact.getAttribute('isopen') === 'false' || contactSelectedByMenu.id === this.id) {
			switchMenu ('actionsContact', true);
		}
		contactSelectedByMenu = this;
		drawSelectedActionContact(contactSelectedByMenu.id);
	};
	li.setAttribute('isselected', 'false');
	setClassPreSelected(li, [3]);
	li.setAttributeNode(cA("data-open", "false"));

	var photoDiv = cE("div");
	if (photo != undefined) {
		setClassPreSelected(photoDiv, [3,4]);
		photoToDataURLCard(photoDiv, "style", "background: url(?) no-repeat scroll 0 0 / auto 100%", photo, 0);		
	} else {
		setClassPreSelected(photoDiv, [3,4,5]);
	}
	aC(li, photoDiv);

	var spanText = cE("span");
	spanText.innerHTML = cn;
	aC(li, spanText);

	return li;
}

/*
 * Creation of menus
 */
function createMenus () {
	actionsContact = gEBI('actionsContact');
	var optionsForActionContact = new Array();
	optionsForActionContact.push({'classIcon':[12], 'textButton':'Remove contact', 'onClickFunction':function(){removeContactElement(contactSelectedByMenu.id, this); switchMenu ('actionsContact', true);}});
	optionsForActionContact.push({'classIcon':[10], 'textButton':'Select contact', 'onClickFunction':function(){adminSelecButtonContactList(contactSelectedByMenu, null); switchMenu ('actionsContact', true);}});
	//optionsForActionContact.push({'classIcon':[10], 'textButton':'Call contact', 'onClickFunction':function(){callToContact(contactSelectedByMenu);}});	
	builderMenuActionsContact(actionsContact, optionsForActionContact);	

	actionsAllContacts = gEBI('actionsAllContacts');
	var optionsForActionAllContacts = new Array();
	optionsForActionAllContacts.push({'classIcon':[13], 'textButton':'Delete selected', 'onClickFunction':function(){removeAllSelectedContacts(); switchMenu ('actionsAllContacts', true);}});
	optionsForActionAllContacts.push({'classIcon':[15], 'textButton':'Export vCard', 'onClickFunction':function(){vCardFileGenerator(contactsSelectList, sdcard, body); switchMenu ('actionsAllContacts', true);}});	
	optionsForActionAllContacts.push({'classIcon':[15], 'textButton':'Export hCard', 'onClickFunction':function(){hCardFileGenerator(contactsSelectList, sdcard, body); switchMenu ('actionsAllContacts', true);}});
	optionsForActionAllContacts.push({'classIcon':[15], 'textButton':'Export hCard', 'onClickFunction':function(){xCardFileGenerator(contactsSelectList, sdcard, body); switchMenu ('actionsAllContacts', true);}});
	builderMenuActionsContact(actionsAllContacts, optionsForActionAllContacts);

	menusList.push(actionsContact);
	menusList.push(actionsAllContacts);		
}

/*
 * Creation of contact's list from device contacts
 */
function scanContactsFromDevice () {
	if (!allContacts.done) {
		var contact = allContacts.result;
		localContactList.add(contact.id, contact);
		aC(contactList,	createContactlistElement(contact.name, contact.id, contact.photo));
		allContacts.continue();
	} else {
		createWaitingIcon(body, false);
	}		
}

/*
 * Creation of contact for the test
 */
function makeTest (makeTest) {
	if (makeTest) {
		var testLength = 10;
		for (var index = 0; index < testLength; index++) {
			var nameTest = "test contact " + index;
			aC(contactList,	createContactlistElement(nameTest, index));
			contactsSelectList.push(nameTest);
		}
	}		
}

/*
 * init program
 */
function init() {
	
	// Buttons events
	gEBI('closeWindowButton').onclick = function () { closeWindow(); };
	gEBI('openMenuButton').onclick = function () { switchMenu('actionsAllContacts', true); };
	gEBI('linkSelectAllContacts').onclick = function () { selectAllsContactsAction(); };
	
	body = gEBI("body");
	contactList = gEBI('contactList');
	createWaitingIcon(body, true);
	
	// TEST contacts
	makeTest(false);
	// TEST contacts	
	
	var filter = {sortBy: "givenName",sortOrder: "ascending"};
	
	if (navigator.mozContacts) {
		allContacts = navigator.mozContacts.getAll(filter);
		allContacts.onsuccess = function() {
			scanContactsFromDevice ();
		};

		allContacts.onerror = function() {
			createWaitingIcon(body, false);
			messageScreen(body, "Uh! Something goes wrong, no result found!");
		};

		if (navigator.getDeviceStorage) {
			sdcard = navigator.getDeviceStorage('sdcard');
		} else {
			createWaitingIcon(body, false);
			messageScreen(body, "sdcard storage not supported");
		}
	} else {
		createWaitingIcon(body, false);
		messageScreen(body, "Search of contacts not supported");
	}

	// Create the menus
	createMenus ();
	
}

/*
 * Close Window
 */
function closeWindow () {
	window.close();
}

window.addEventListener('load', function () { init(); }, false);