// El codigo y los datos son propiedad de Andres Felipe OSPINA BANOL cefiahb@hotmail.com

/*
 * hCard file generator
 */
function hCardFileGenerator (contactsSelectList, sdcard, body) {
	try {
		
		createWaitingIcon(body, true);
		
		var fileStrings = new Array();
		fileStrings.push("<html><head><meta charset='UTF-8' name='viewport' content='width=device-width, user-scalable=false;'><link rel='profile' href='http://microformats.org/profile/hcard'><style>" + H_CARD_CSS + "</style></head><body>");
		
		if (contactsSelectList.length > 0) {
			for (index in contactsSelectList) {
				if (contactsSelectList[index]) {
					var contact = localContactList.get(contactsSelectList[index]);				
					fileStrings.push(hCardStringStreamGenerator(contact));	
				}
			}
			fileStrings.push('</body>');

			var file = new Blob(fileStrings, {type: "text/plain"});
			
			var d = new Date();
			var sufixFileName = d.getUTCFullYear() + "_" + d.getUTCMonth() + "_" + d.getUTCDate() + "_" + d.getUTCHours() + "_" + d.getUTCMinutes() + "_" + d.getUTCSeconds();
			var request = sdcard.addNamed(file, "hCard/hCardList_" + sufixFileName + ".html");
		
			request.onsuccess = function () {
				createWaitingIcon(body, false);
				var name = this.result;
				messageScreen('File "' + name + '" successfully wrote on the sdcard storage area');
			}

			// An error typically occur if a file with the same name already exist
			request.onerror = function () {
				createWaitingIcon(body, false);
				messageScreen('Unable to write the file: ' + this.error.name);
			}
		} else {
			createWaitingIcon(body, false);
		}
		
	} catch (e) {
		alert('hCardFileGenerator error ' + e);
	}
}


/*
 * hCard string stream generator
 */
function hCardStringStreamGenerator (contact) {
	var nextLine = "\r\n";
	var hCardString = "<div class='vcard' version='4.0'>" + nextLine;
	try {
				
		hCardString += hCardNParameterCreator(contact) + nextLine;
		if (existNoNull(contact.name)) {
			hCardString += hCardStringParameterCreator({'parameter':contact.name, 'classP':'fn', 'tag':'span'}) + nextLine;
		}
	    //hCardString += hCardGENDERParameterCreator(contact) + nextLine;	    
		//hCardString += hCardArrayStringParameterCreator(contact.nickname, "NICKNAME", ";") + nextLine;
		//hCardString += hCardStringParameterCreator( hCardStringParsingDateString(contact.bday), "BDAY") + nextLine;
		//hCardString += hCardStringParameterCreator( hCardStringParsingDateString(contact.bday), "ANNIVERSARY") + nextLine;
		if (existNoNull(contact.key)) {
			hCardString += hCardArrayStringParameterCreator({'parameter':contact.key, 'classParent':'key', 'tagParent':'span', 'tagChild':'span'}) + nextLine;
		}
		//hCardString += hCardArrayStringParameterCreator(contact.url, "URL", ";") + nextLine;		
		if (existNoNull(contact.photo)) {
			var photos = contact.photo.slice();
			for (var index = 0; index < photos.length; index++) {
				var rPhoto =  new PhotoToDataURL(photos[index]);
				hCardString += hCardStringParameterCreator({'parameter':rPhoto.urlPhoto, 'classP':'photo', 'tag':'span'}) + nextLine;
			}						
		}
		//hCardString += hCardArrayStringParameterCreator(contact.org, "ORG", ";") + nextLine;
		if (existNoNull(contact.email)) {
			var email = contact.email;
			for (var index = 0; index < email.length; index++) {
				hCardString += hCardArrayStringParameterCreator({'parameter':email[index], 'classParent':'email', 'tagParent':'div', 'tagChild':'span'}) + nextLine;
			}
		}	
		//hCardString += hCardArrayStringParameterCreator(contact.category, "CATEGORIES", ",") + nextLine;
		if (existNoNull(contact.adr)) {
			var adr = contact.adr;
			for (var index = 0; index < adr.length; index++) {
				hCardString += hCardArrayStringParameterCreator({'parameter':adr[index], 'classParent':'adr', 'tagParent':'address', 'tagChild':'span'}) + nextLine;
			}			
		}
		if (existNoNull(contact.tel)) {
			var tel = contact.tel;
			hCardString += "<div class='tel'>";
			for (var index = 0; index < tel.length; index++) {
				hCardString += hCardStringParameterCreator({'parameter':tel[index].value, 'classP':'tel', 'tag':'span'}) + nextLine;
			}
			hCardString += "</div>";
		}
		//hCardString += hCardArrayStringParameterCreator(contact.jobTitle, "TITLE", ";") + nextLine;
		if (existNoNull(contact.note)) {
			var note = contact.note;
			for (var index = 0; index < note.length; index++) {	
				hCardString += hCardStringParameterCreator({'parameter':note[index].value, 'classP':'note', 'tag':'span'}) + nextLine;
			}
		}
		if (existNoNull(contact.impp)) {
			var impp = contact.impp;
			for (var index = 0; index < impp.length; index++) {			
				hCardString += hCardStringParameterCreator({'parameter':impp[index].value, 'classP':'impp', 'tag':'span'}) + nextLine;
			}
		}
	} catch (e) {
		alert('hCardStringStreamGenerator error ' + e);
	}
	return hCardString + "</div>" + nextLine;
}

/*
 * Create hCard String parameter
 * {'parameter', 'classP', 'tag'}
 */ 
function hCardStringParameterCreator (obj) {
	return existNoNull(obj.parameter) ? "<" + obj.tag + " class='" + obj.classP + "'>" + obj.parameter + "</" + obj.tag + ">" : "";
}

/*
 * Parsing hCard Date to String
 */
function hCardStringParsingDateString (parameter) {
	var stringDate = "";
	if (existNoNull(parameter)) {
		stringDate += parameter.getUTCFullYear();
		stringDate += parameter.getUTCMonth();
		stringDate += parameter.getUTCDate() + "T";
		stringDate += parameter.getUTCHours();
		stringDate += parameter.getUTCMinutes();
		stringDate += parameter.getUTCSeconds() + "Z";
	}
	return stringDate;
}

/*
 * Create hCard Array String parameter
 * {'parameter', 'classParent', 'classChild', 'tagParent', 'tagChild'}
 */ 
function hCardArrayStringParameterCreator (obj) {
	var result = "";
	if (existNoNull(obj)) {
		result = "<" + obj.tagParent + " class='" + obj.classParent + "'>";
		var classChild = obj.classChild;
		for (index in obj.parameter) {
			if (obj.parameter[index] && obj.parameter[index].length > 0) {
				result += "<" + obj.tagChild + " class='" + (classChild ? classChild : obj.classParent) + "'>" + obj.parameter[index] + "</" + obj.tagChild + ">";
			}
		}
		result += "</" + obj.tagParent + ">";
	}
	return result;
}

/*
 * Create hCard N parameter
 */
function hCardNParameterCreator (contact) {
	var parameters = [contact.familyName, contact.givenName, contact.additionalName, contact.honorificPrefix, contact.honorificSuffix];	
	return hCardArrayStringParameterCreator({'parameter':parameters, 'classParent':'n', 'tagParent':'div', 'tagChild':'span'});
}

/*
 * Create hCard Address parameter to String
 */
function hCardAddressParameterToString (address) {
	var adrs = new Array();
	adrs.push(existNoNull(address.streetAddress) ? address.streetAddress : "");
	adrs.push(existNoNull(address.locality) ? address.locality : "");
	//adrs.push(existNoNull(address.region) ? address.region : "");
	adrs.push(existNoNull(address.postalCode) ? address.postalCode : "");
	adrs.push(existNoNull(address.countryName) ? address.countryName : "");
	return hCardArrayStringParameterCreator({'parameter':adrs, 'classParent':'addr', 'tagParent':'span', 'tagChild':'span'});
}

/*
 * Create hCard GENDER parameter
 */
function hCardGENDERParameterCreator (contact) {
	var nParameter = "GENDER:";
	nParameter += existNoNull(contact.sex) ? contact.sex + ";" : "";
	nParameter += existNoNull(contact.genderIdentity) ? contact.genderIdentity + ";" : "";
	return nParameter;
}