// El codigo y los datos son propiedad de Andres Felipe OSPINA BANOL cefiahb@hotmail.com

/*
 * vCard file generator
 */
function vCardFileGenerator (contactsSelectList, sdcard, body) {
	try {
		
		createWaitingIcon(body, true);
		
		var fileStrings = new Array();
		if (contactsSelectList.length > 0) {
			for (index in contactsSelectList) {
				if (contactsSelectList[index]) {
					var contact = localContactList.get(contactsSelectList[index]);
					fileStrings.push(vCardStringStreamGenerator(contact));	
				}
			}
			
			var file = new Blob(fileStrings, {type: "text/plain"});
			
			var d = new Date();
			var sufixFileName = d.getUTCFullYear() + "_" + d.getUTCMonth() + "_" + d.getUTCDate() + "_" + d.getUTCHours() + "_" + d.getUTCMinutes() + "_" + d.getUTCSeconds();
			var request = sdcard.addNamed(file, "vCard/vCardList_" + sufixFileName + ".vcard");
				
			request.onsuccess = function () {
				createWaitingIcon(body, false);
				var name = this.result;
				messageScreen('File "' + name + '" successfully wrote on the sdcard storage area');
			}

			// An error typically occur if a file with the same name already exist
			request.onerror = function () {
				createWaitingIcon(body, false);
				messageScreen('Unable to write the file: ' + this.error.name);
			}
		} else {
			createWaitingIcon(body, false);
		}
		
	} catch (e) {
		alert('vCardFileGenerator error ' + e);
	}
}


/*
 * vCard string stream generator
 */
function vCardStringStreamGenerator (contact) {
	var nextLine = "\r\n";
	var vCardString = "BEGIN:VCARD" + nextLine + "VERSION:4.0" + nextLine;
	try {
				
		vCardString += vCardNParameterCreator(contact) + nextLine;
		if (existNoNull(contact.name)) {
			vCardString += vCardStringParameterCreator(contact.name, "FN", ";") + nextLine;
		}
	    //vCardString += vCardGENDERParameterCreator(contact) + nextLine;	    
		//vCardString += vCardArrayStringParameterCreator(contact.nickname, "NICKNAME", ";") + nextLine;
		//vCardString += vCardStringParameterCreator( vCardStringParsingDateString(contact.bday), "BDAY") + nextLine;
		//vCardString += vCardStringParameterCreator( vCardStringParsingDateString(contact.bday), "ANNIVERSARY") + nextLine;
		if (existNoNull(contact.key)) {
			vCardString += vCardArrayStringParameterCreator(contact.key, "KEY", ";") + nextLine;
		}
		//vCardString += vCardArrayStringParameterCreator(contact.url, "URL", ";") + nextLine;		
		if (existNoNull(contact.photo)) {
			var photos = contact.photo.slice();
			for (var index = 0; index < photos.length; index++) {
				var rPhoto =  new PhotoToDataURL(photos[index]);
				vCardString += vCardStringParameterCreator(rPhoto.urlPhoto, "PHOTO") + nextLine;
			}						
		}
		//vCardString += vCardArrayStringParameterCreator(contact.org, "ORG", ";") + nextLine;
		if (existNoNull(contact.email)) {
			var email = contact.email;
			for (var index = 0; index < email.length; index++) {
				vCardString += vCardArrayStringParameterCreator(email[index], "EMAIL", ";") + nextLine;
			}
		}	
		//vCardString += vCardArrayStringParameterCreator(contact.category, "CATEGORIES", ",") + nextLine;
		if (existNoNull(contact.adr)) {
			var adr = contact.adr;
			for (var index = 0; index < adr.length; index++) {
				vCardString += vCardArrayStringParameterCreator(adr[index], "ADR", ";") + nextLine;
			}			
		}
		if (existNoNull(contact.tel)) {
			var tel = contact.tel;
			for (var index = 0; index < tel.length; index++) {			
				vCardString += vCardStringParameterCreator(tel[index].value, "TEL", ";") + nextLine;
			}
		}
		//vCardString += vCardArrayStringParameterCreator(contact.jobTitle, "TITLE", ";") + nextLine;
		if (existNoNull(contact.note)) {
			var note = contact.note;
			for (var index = 0; index < note.length; index++) {	
				vCardString += vCardStringParameterCreator(note[index].value, "NOTE", ";") + nextLine;
			}
		}
		if (existNoNull(contact.impp)) {
			var impp = contact.impp;
			for (var index = 0; index < impp.length; index++) {			
				vCardString += vCardStringParameterCreator(impp[index].value, "IMPP", ";") + nextLine;
			}
		}
	} catch (e) {
		alert(e);
	}
	return vCardString + "END:VCARD" + nextLine;
}

/*
 * Create vCard String parameter
 */
function vCardStringParameterCreator (parameter, nameParameter) {
	return existNoNull(parameter) ? nameParameter + ":" + parameter : "";
}

/*
 * Parsing vCard Date to String
 */
function vCardStringParsingDateString (parameter) {
	var stringDate = "";
	if (existNoNull(parameter)) {
		stringDate += parameter.getUTCFullYear();
		stringDate += parameter.getUTCMonth();
		stringDate += parameter.getUTCDate() + "T";
		stringDate += parameter.getUTCHours();
		stringDate += parameter.getUTCMinutes();
		stringDate += parameter.getUTCSeconds() + "Z";
	}
	return stringDate;
}

/*
 * Create vCard Array String parameter
 */
function vCardArrayStringParameterCreator (parameter, nameParameter, separator) {
	var result = "";
	if (existNoNull(parameter)) {
		result = nameParameter + ":";
		for (index in parameter) {
			result += parameter[index] + separator;
		}
		result = result.substring(0, result.length - 1);
	}
	return result;
}

/*
 * Create vCard Array String sub-parameter
 */
function vCardArrayStringSubParameterCreator (parameter) {
	var result = "";
	if (existNoNull(parameter)) {
		for (index in parameter) {
			result += parameter[index] + ",";
		}
		result = result.substring(0, result.length - 1);
	}
	return result;
}

/*
 * Create vCard N parameter
 */
function vCardNParameterCreator (contact) {
	var parameters = [contact.familyName, contact.givenName, contact.additionalName, contact.honorificPrefix, contact.honorificSuffix];	
	return vCardArrayStringParameterCreator(parameters, "N", ";");
}

/*
 * Create vCard Address parameter to String
 */
function vCardAddressParameterToString (address) {
	var adrs = new Array();
	adrs.push(existNoNull(address.streetAddress) ? address.streetAddress : "");
	adrs.push(existNoNull(address.locality) ? address.locality : "");
	//adrs.push(existNoNull(address.region) ? address.region : "");
	adrs.push(existNoNull(address.postalCode) ? address.postalCode : "");
	adrs.push(existNoNull(address.countryName) ? address.countryName : "");
	return vCardArrayStringSubParameterCreator(adrs);
}

/*
 * Create vCard GENDER parameter
 */
function vCardGENDERParameterCreator (contact) {
	var nParameter = "GENDER:";
	nParameter += existNoNull(contact.sex) ? contact.sex + ";" : "";
	nParameter += existNoNull(contact.genderIdentity) ? contact.genderIdentity + ";" : "";
	return nParameter;
}