// El codigo y los datos son propiedad de Andres Felipe OSPINA BANOL cefiahb@hotmail.com

/*
 * xCard file generator
 */
function xCardFileGenerator (contactsSelectList, sdcard, body) {
	try {
		
		createWaitingIcon(body, true);
		
		var fileStrings = new Array();
		fileStrings.push("<?xml version='1.0' encoding='UTF-8'?><contacts>");
		
		if (contactsSelectList.length > 0) {
			for (index in contactsSelectList) {
				if (contactsSelectList[index]) {
					var contact = localContactList.get(contactsSelectList[index]);				
					fileStrings.push(xCardStringStreamGenerator(contact));	
				}
			}
			fileStrings.push('</contacts>');

			var file = new Blob(fileStrings, {type: "text/plain"});
			
			var d = new Date();
			var sufixFileName = d.getUTCFullYear() + "_" + d.getUTCMonth() + "_" + d.getUTCDate() + "_" + d.getUTCHours() + "_" + d.getUTCMinutes() + "_" + d.getUTCSeconds();
			var request = sdcard.addNamed(file, "xCard/xCardList_" + sufixFileName + ".xml");
		
			request.onsuccess = function () {
				createWaitingIcon(body, false);
				var name = this.result;
				messageScreen('File "' + name + '" successfully wrote on the sdcard storage area');
			}

			// An error typically occur if a file with the same name already exist
			request.onerror = function () {
				createWaitingIcon(body, false);
				messageScreen('Unable to write the file: ' + this.error.name);
			}
		} else {
			createWaitingIcon(body, false);
		}
		
	} catch (e) {
		alert('xCardFileGenerator error ' + e);
	}
}


/*
 * xCard string stream generator
 */
function xCardStringStreamGenerator (contact) {
	var nextLine = "\r\n";
	var xCardString = "<div class='vcard' version='4.0'>" + nextLine;
	try {
				
		xCardString += xCardNParameterCreator(contact) + nextLine;
		if (existNoNull(contact.name)) {
			xCardString += xCardStringParameterCreator({'parameter':contact.name, 'tag':'fn'}) + nextLine;
		}
	    //xCardString += xCardGENDERParameterCreator(contact) + nextLine;	    
		//xCardString += xCardArrayStringParameterCreator(contact.nickname, "NICKNAME", ";") + nextLine;
		//xCardString += xCardStringParameterCreator( xCardStringParsingDateString(contact.bday), "BDAY") + nextLine;
		//xCardString += xCardStringParameterCreator( xCardStringParsingDateString(contact.bday), "ANNIVERSARY") + nextLine;
		if (existNoNull(contact.key)) {
			xCardString += xCardArrayStringParameterCreator({'parameter':contact.key, 'tagParent':'key', 'tagChild':'item'}) + nextLine;
		}
		//xCardString += xCardArrayStringParameterCreator(contact.url, "URL", ";") + nextLine;		
		if (existNoNull(contact.photo)) {
			var photos = contact.photo.slice();
			for (var index = 0; index < photos.length; index++) {
				var rPhoto =  new PhotoToDataURL(photos[index]);
				xCardString += xCardStringParameterCreator({'parameter':rPhoto.urlPhoto, 'tag':'photo'}) + nextLine;
			}						
		}
		//xCardString += xCardArrayStringParameterCreator(contact.org, "ORG", ";") + nextLine;
		if (existNoNull(contact.email)) {
			var email = contact.email;
			for (var index = 0; index < email.length; index++) {
				xCardString += xCardArrayStringParameterCreator({'parameter':email[index], 'tagParent':'email', 'tagChild':'item'}) + nextLine;
			}
		}	
		//xCardString += xCardArrayStringParameterCreator(contact.category, "CATEGORIES", ",") + nextLine;
		if (existNoNull(contact.adr)) {
			var adr = contact.adr;
			for (var index = 0; index < adr.length; index++) {
				xCardString += xCardArrayStringParameterCreator({'parameter':adr[index], 'tagParent':'adr', 'tagChild':'item'}) + nextLine;
			}			
		}
		if (existNoNull(contact.tel)) {
			var tel = contact.tel;
			xCardString += "<tel>";
			for (var index = 0; index < tel.length; index++) {
				xCardString += xCardStringParameterCreator({'parameter':tel[index].value, 'tag':'item'}) + nextLine;
			}
			xCardString += "</tel>";
		}
		//xCardString += xCardArrayStringParameterCreator(contact.jobTitle, "TITLE", ";") + nextLine;
		if (existNoNull(contact.note)) {
			var note = contact.note;
			for (var index = 0; index < note.length; index++) {	
				xCardString += xCardStringParameterCreator({'parameter':note[index].value, 'tag':'note'}) + nextLine;
			}
		}
		if (existNoNull(contact.impp)) {
			var impp = contact.impp;
			for (var index = 0; index < impp.length; index++) {			
				xCardString += xCardStringParameterCreator({'parameter':impp[index].value, 'tag':'impp'}) + nextLine;
			}
		}
	} catch (e) {
		alert('xCardStringStreamGenerator error ' + e);
	}
	return xCardString + "</div>" + nextLine;
}

/*
 * Create xCard String parameter
 * {'parameter', 'tag'}
 */ 
function xCardStringParameterCreator (obj) {
	return existNoNull(obj.parameter) ? "<" + obj.tag + ">" + obj.parameter + "</" + obj.tag + ">" : "";
}

/*
 * Parsing xCard Date to String
 */
function xCardStringParsingDateString (parameter) {
	var stringDate = "";
	if (existNoNull(parameter)) {
		stringDate += parameter.getUTCFullYear();
		stringDate += parameter.getUTCMonth();
		stringDate += parameter.getUTCDate() + "T";
		stringDate += parameter.getUTCHours();
		stringDate += parameter.getUTCMinutes();
		stringDate += parameter.getUTCSeconds() + "Z";
	}
	return stringDate;
}

/*
 * Create xCard Array String parameter
 * {'parameter', 'tagParent', 'tagChild'}
 */ 
function xCardArrayStringParameterCreator (obj) {
	var result = "";
	if (existNoNull(obj)) {
		result = "<" + obj.tagParent + ">";
		for (index in obj.parameter) {
			if (obj.parameter[index] && obj.parameter[index].length > 0) {
				result += "<" + obj.tagChild + ">" + obj.parameter[index] + "</" + obj.tagChild + ">";
			}
		}
		result += "</" + obj.tagParent + ">";
	}
	return result;
}

/*
 * Create xCard N parameter
 */
function xCardNParameterCreator (contact) {
	var parameters = [contact.familyName, contact.givenName, contact.additionalName, contact.honorificPrefix, contact.honorificSuffix];	
	return xCardArrayStringParameterCreator({'parameter':parameters, 'tagParent':'n', 'tagChild':'item'});
}

/*
 * Create xCard Address parameter to String
 */
function xCardAddressParameterToString (address) {
	var adrs = new Array();
	adrs.push(existNoNull(address.streetAddress) ? address.streetAddress : "");
	adrs.push(existNoNull(address.locality) ? address.locality : "");
	//adrs.push(existNoNull(address.region) ? address.region : "");
	adrs.push(existNoNull(address.postalCode) ? address.postalCode : "");
	adrs.push(existNoNull(address.countryName) ? address.countryName : "");
	return xCardArrayStringParameterCreator({'parameter':adrs, 'tagParent':'adr', 'tagChild':'item'});
}

/*
 * Create xCard GENDER parameter
 */
function xCardGENDERParameterCreator (contact) {
	var nParameter = "GENDER:";
	nParameter += existNoNull(contact.sex) ? contact.sex + ";" : "";
	nParameter += existNoNull(contact.genderIdentity) ? contact.genderIdentity + ";" : "";
	return nParameter;
}