window.onload = function() {
    calcular = document.getElementById("calcular");
    calcular.onclick = function() {
        tipotemperatura = document.getElementById("tipotemperatura");
        temperatura = document.getElementById("temperatura");
        if (temperatura.value === "") {
            status("Valor da Temperatura não informado!");
        } else {
            temperatura = parseFloat(temperatura.value);
            if (tipotemperatura.value === "Celsius") {
                criarArtigo();
                acrescentarResultado("Celsius para Kelvin", Conversor.celsiusParaKelvin(temperatura) + "ºK", "kelvin = " + temperatura + "ºC + 273.15");
                acrescentarResultado("Celsius para Fahrenheit", Conversor.celsiusParaFahrenheit(temperatura) + "ºF", "Fahrenheit = (9 * " + temperatura + "ºC + 160) / 5");
            } else if (tipotemperatura.value === "Kelvin") {
                criarArtigo();
                acrescentarResultado("Kelvin para Celsius", Conversor.kelvinParaCelsius(temperatura) + "ºC", "Celsius = " + temperatura + "ºK - 273.15");
                acrescentarResultado("Kelvin para Fahrenheit", Conversor.kelvinParaFahrenheit(temperatura) + "ºF", "Fahrenheit = (9 * (" + temperatura + "ºK - 273.15) + 160) / 5");

            } else if (tipotemperatura.value === "Fahrenheit") {
                criarArtigo();
                acrescentarResultado("Fahrenheit para Celsius", Conversor.fahrenheitParaCelsius(temperatura) + "ºC", "Celsius = ((" + temperatura + "ºF - 32) * 5) / 9");
                acrescentarResultado("Fahrenheit para Kelvin", Conversor.fahrenheitParaKelvin(temperatura) + "ºF", "Kelvin = (((" + temperatura + "ºF - 32) * 5) / 9) + 273.15");
            } else {
                status("Tipo de temperatura não suportado");
            }
        }
    };
    voltar = document.getElementById("voltar");
    voltar.onclick = voltarParaTelaInicial;
};

function criarArtigo() {
    article = document.getElementById("resultado");
    if (article !== null) {
        article.innerHTML = "";
    } else {
        article = document.createElement("article");
        article.setAttribute("data-type", "list");
        article.setAttribute("id", "resultado");
        document.getElementById("telaresultado").appendChild(article);
    }
}

function acrescentarResultado(titulo, resultado, formula) {
    article = document.getElementById("resultado");
    header = document.createElement("header");
    header.textContent = titulo;
    article.appendChild(header);
    ul = document.createElement("ul");
    li = document.createElement("li");
    p = document.createElement("p");
    pformula = document.createElement("p");
    pformula.textContent = formula;
    p.textContent = resultado;
    li.appendChild(p);
    li.appendChild(pformula);
    ul.appendChild(li);
    article.appendChild(ul);
    mostrarResultado();
}

function mostrarResultado() {
    telainicial = document.getElementById("telainicial");
    telainicial.className = "currentToLeft";
    telainicial.setAttribute("data-position", "left");
    telaresultado = document.getElementById("telaresultado");
    telaresultado.className = "rightToCurrent";
    telaresultado.setAttribute("data-position", "current");

}

function voltarParaTelaInicial() {
    current = document.querySelector("[data-position='current']");
    current.setAttribute("data-position", "right");
    current.className = "currentToRight";
    telainicial = document.getElementById("telainicial");
    telainicial.className = "leftToCurrent";
    telainicial.setAttribute("data-position", "current");
}

function status(mensagem) {
    statusExiste = document.getElementById("status");
    if (statusExiste !== null) {
        statusExiste.className = "onviewport";
        statusExiste.addEventListener("animationend", function() {
            statusExiste.className = "";
        }, false);
    } else {
        section = document.createElement("section");
        section.setAttribute("role", "status");
        section.setAttribute("id", "status");
        p = document.createElement("p");
        p.textContent = mensagem;
        section.appendChild(p);
        body = document.getElementsByTagName("body")[0];
        body.appendChild(section);
    }

}