function slugify(str) {
  str = str.replace(/^\s+|\s+$/g, ''); // trim
  str = str.toLowerCase();
  
  // remove accents, swap Ã± for n, etc
  var from = "Ã…Ã Ã¡Ã¤Ã¢Ã¨Ã©Ã«ÃªÃ¬Ã­Ã¯Ã®Ã²Ã³Ã¶Ã´Ã¹ÃºÃ¼Ã»Ã±Ã§Â·/_,:;";
  var to   = "aaaaaeeeeiiiioooouuuunc------";
  for (var i=0, l=from.length ; i<l ; i++) {
    str = str.replace(new RegExp(from.charAt(i), 'g'), to.charAt(i));
  }

  str = str.replace(/[^a-z0-9 -]/g, '') // remove invalid chars
    .replace(/\s+/g, '-') // collapse whitespace and replace by -
    .replace(/-+/g, '-'); // collapse dashes

  return str;
}

function convertDist(orig) {
  if(orig == 'from_dist') {
    var unit_from = $('#unit_from_dist').val();
    var unit_to = $('#unit_to_dist').val();
  } else {
    var unit_from = $('#unit_to_dist').val();
    var unit_to = $('#unit_from_dist').val();
  }

  var dist_orig = $('#' + orig).val();

  // calcular dato entrada en metros
  if(unit_from != 'm') {
    var dist_orig_m = dist_orig * units[unit_from + "_ref"];
  } else {
    var dist_orig_m = dist_orig;
  }

  // calcular distancia en metros a unidad final
  var dist_final = dist_orig_m * units["ref_" + unit_to];

  if(isNaN(dist_final))
    dist_final = '';

  if(orig == 'from_dist')
    $('#to_dist').val(dist_final);
  else 
    $('#from_dist').val(dist_final);
}

function convertSup(orig) {
  if(orig == 'from_sup') {
    var unit_from = $('#unit_from_sup').val();
    var unit_to = $('#unit_to_sup').val();
  } else {
    var unit_from = $('#unit_to_sup').val();
    var unit_to = $('#unit_from_sup').val();
  }

  var sup_orig = $('#' + orig).val();

  // calcular dato entrada en metros cuadrados
  if(unit_from != 'm2') {
    var sup_orig_m2 = sup_orig * units[unit_from + "_ref"];
  } else {
    var sup_orig_m2 = sup_orig;
  }

  // calcular superficie en metros cuadrado a unidad final
  var sup_final = sup_orig_m2 * units["ref_" + unit_to];

  if(isNaN(sup_final))
    sup_final = '';

  if(orig == 'from_sup')
    $('#to_sup').val(sup_final);
  else 
    $('#from_sup').val(sup_final);
}

function convertMass(orig) {
  if(orig == 'from_mass') {
    var unit_from = $('#unit_from_mass').val();
    var unit_to = $('#unit_to_mass').val();
  } else {
    var unit_from = $('#unit_to_mass').val();
    var unit_to = $('#unit_from_mass').val();
  }

  var mass_orig = $('#' + orig).val();

  // calcular dato entrada en kilogramos
  if(unit_from != 'kg') {
    var mass_orig_kg = mass_orig * units[unit_from + "_ref"];
  } else {
    var mass_orig_kg = mass_orig;
  }

  // calcular superficie en gramos a unidad final
  var mass_final = mass_orig_kg * units["ref_" + unit_to];

  if(isNaN(mass_final))
    mass_final = '';

  if(orig == 'from_mass')
    $('#to_mass').val(mass_final);
  else 
    $('#from_mass').val(mass_final);
}

function convertTime(orig) {
  if(orig == 'from_time') {
    var unit_from = $('#unit_from_time').val();
    var unit_to = $('#unit_to_time').val();
  } else {
    var unit_from = $('#unit_to_time').val();
    var unit_to = $('#unit_from_time').val();
  }

  var time_orig = $('#' + orig).val();

  // calcular dato entrada en segundos
  if(unit_from != 's') {
    var time_orig_s = time_orig * units[unit_from + "_ref"];
  } else {
    var time_orig_s = time_orig;
  }

  // calcular tiempo en segundos a unidad final
  var time_final = time_orig_s * units["ref_" + unit_to];
  
  if(isNaN(time_final))
    time_final = '';
  
  if(orig == 'from_time')
    $('#to_time').val(time_final);
  else 
    $('#from_time').val(time_final);
}


$(document).ready(function(){
  $('#from_dist, #to_dist').each(function() {
    $(this).data('oldValDist', $(this));
    $(this).bind("propertychange keyup input cut paste", function(event){
      if ($(this).data('oldValDist') != $(this).val()) {
        $(this).data('oldValDist', $(this).val());
        convertDist($(this).attr("id"));
      }
    });
  });
  $('#unit_from_dist, #unit_to_dist').change(function() {
    if($(this).attr("id") == 'unit_from_dist')
      convertDist('to_dist');
    else
      convertDist('from_dist');
  });


  $('#from_sup, #to_sup').each(function() {
    $(this).data('oldValSup', $(this));
    $(this).bind("propertychange keyup input cut paste", function(event){
      if ($(this).data('oldValSup') != $(this).val()) {
        $(this).data('oldValSup', $(this).val());
        convertSup($(this).attr("id"));
      }
    });
  });
  $('#unit_from_sup, #unit_to_sup').change(function() {
    if($(this).attr("id") == 'unit_from_sup')
      convertSup('to_sup');
    else
      convertSup('from_sup');
  });


  $('#from_mass, #to_mass').each(function() {
    $(this).data('oldValMass', $(this));
    $(this).bind("propertychange keyup input cut paste", function(event){
      if ($(this).data('oldValMass') != $(this).val()) {
        $(this).data('oldValMass', $(this).val());
        convertMass($(this).attr("id"));
      }
    });
  });
  $('#unit_from_mass, #unit_to_mass').change(function() {
    if($(this).attr("id") == 'unit_from_mass')
      convertMass('to_mass');
    else
      convertMass('from_mass');
  });


  $('#from_time, #to_time').each(function() {
    $(this).data('oldValTime', $(this));
    $(this).bind("propertychange keyup input cut paste", function(event){
      if ($(this).data('oldValTime') != $(this).val()) {
        $(this).data('oldValTime', $(this).val());
        convertTime($(this).attr("id"));
      }
    });
  });
  $('#unit_from_time, #unit_to_time').change(function() {
    if($(this).attr("time") == 'unit_from_time')
      convertTime('to_time');
    else
      convertTime('from_time');
  });

});


  /*$('#conv_sup').click(function(){
    var unit_from = $('#unit_from_sup').val();
    var unit_to = $('#unit_to_sup').val();
    var dist_orig = $('#sup').val();


    // calcular dato entrada en metros
    if(unit_from != 'm') {
      var dist_orig_m = dist_orig * units[unit_from + "_m"];
    } else {
      var dist_orig_m = dist_orig;
    }

    // calcular distancia en metros a unidad final
    var dist_final = dist_orig_m * units["m_" + unit_to];

    $('#total_sup').html(dist_final);
    $('#detalle_sup').html("<a href='/" + slugify(names[unit_from]) + "s-a-" + slugify(names[unit_to]) + "s'>MÃ¡s informaciÃ³n sobre la conversiÃ³n entre " + names[unit_from] + " y " + names[unit_to] + "</a>");
  });
});*/