// Bubble Pop Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Bubble Pop Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after the required number of bubbles for the round have been popped and eating by the catcher.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a bubble with a target item is touched.
//         
// Round Properties
//
//     numBubbles: Maximum number of bubbles visible on the screen at once.
//     background
//         Properties:
//            filename: Filename of the background image.
//     bubbleHighlight: Displayed behind the bubble when it is highlighted.
//     bubblePopAnimation: Displayed when a bubble is touched.
//     emptyBubble
//         Properties:
//             filename: Filename of the emoty bubble image.
//     catcher: A character would catches items that fall out of bubbles which are popped.
//         Available States:
//             WAIT: Displayed when the catcher is not active.
//             WAVE: Displayed at the beginning of each round.
//             MOVE: Displayed when the catcher is moving.
//             JUMP: Displayed when a popped bubble has dropped in range of the catcher.
//     target: A random item is selected at the start of each round to be the correct item.
//         Properties:
//             unpopped
//                 Properties:
//                     filename: Filename of the image displayed if the bubble has not been touched.
//             popped
//                 Properties:
//                     filename: Filename of the image displayed after bubble has been touched.
//             label
//                 Available States:
//                     NOTFOUND: Initial state of the label.
//                     FOUND: Displayed after the item is found.
//     distractors (Array): Array of objects that will be displayed with target bubbles that just pop when touch
//         Properties:
//             filename: Filename of the distractor image.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -64
		}
	},
	gameIcon: "mozilla_thumb_256x256_CookiesAnimalCrackers.png",
	audioEnabled: true,
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "start-bubblePop-animals.png",
	audioFilename: "BP_animals.mp3", //all audio including intro, payoff, and music is in one file found here
	audio: {
		states: [
			{
				name: "music", 
				startTime: 70,
				duration: 19,
				loop: true
			}
		]
	},
	hud: {
		sidebar: {
			type: "SIDEBAR",
			states: [
				{
					type: "Default",
					filename: "sidebar.png",
					numFrames: 12,
					autoStart: false
				}
			]
		}
	},
	rounds: [
		{
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 49,
						duration: 3
					}, {
						name: "payoff",
						startTime: 53,
						duration: 1
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "animalsinbubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "animals_bird_inbubble.png"
				},
				popped: {
					filename: "animals_bird_outofbubble.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "bird_purple.png"
						},{
							type: "Found",
							filename: "bird_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "animals_cat_inbubble.png"
				}, {
					filename: "animals_dog_inbubble.png"
				}, {
					filename: "animals_elephant_inbubble.png"
				}, {
					filename: "animals_fish_inbubble.png"
				}, {
					filename: "animals_hippo_inbubble.png"
				}, {
					filename: "animals_lion_inbubble.png"
				}, {
					filename: "animals_monkey_inbubble.png"
				}, {
					filename: "animals_rhino_inbubble.png"
				}, {
					filename: "animals_tiger_inbubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 28,
						duration: 3
					}, {
						name: "payoff",
						startTime: 32,
						duration: 1
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "animalsinbubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "animals_cat_inbubble.png"
				},
				popped: {
					filename: "animals_cat_outofbubble.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "cat_purple.png"
						},{
							type: "Found",
							filename: "cat_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "animals_bird_inbubble.png"
				}, {
					filename: "animals_dog_inbubble.png"
				}, {
					filename: "animals_elephant_inbubble.png"
				}, {
					filename: "animals_fish_inbubble.png"
				}, {
					filename: "animals_hippo_inbubble.png"
				//}, {
				//	filename: "animals_lion_inbubble.png"
				}, {
					filename: "animals_monkey_inbubble.png"
				}, {
					filename: "animals_rhino_inbubble.png"
				//}, {
				//	filename: "animals_tiger_inbubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 56,
						duration: 3
					}, {
						name: "payoff",
						startTime: 60,
						duration: 1
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "animalsinbubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "animals_dog_inbubble.png"
				},
				popped: {
					filename: "animals_dog_outofbubble.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "dog_purple.png"
						},{
							type: "Found",
							filename: "dog_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "animals_bird_inbubble.png"
				}, {
					filename: "animals_cat_inbubble.png"
				}, {
					filename: "animals_elephant_inbubble.png"
				}, {
					filename: "animals_fish_inbubble.png"
				}, {
					filename: "animals_hippo_inbubble.png"
				}, {
					filename: "animals_lion_inbubble.png"
				}, {
					filename: "animals_monkey_inbubble.png"
				}, {
					filename: "animals_rhino_inbubble.png"
				}, {
					filename: "animals_tiger_inbubble.png"
				}
			]
		}, /*{
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 0,
						duration: 3
					}, {
						name: "payoff",
						startTime: 4,
						duration: 1
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "animalsinbubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "animals_elephant_inbubble.png"
				},
				popped: {
					filename: "animals_elephant_outofbubble"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "elephant_purple.png"
						},{
							type: "Found",
							filename: "elephant_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "animals_bird_inbubble.png"
				}, {
					filename: "animals_cat_inbubble.png"
				}, {
					filename: "animals_dog_inbubble.png"
				}, {
					filename: "animals_fish_inbubble.png"
				}, {
					filename: "animals_hippo_inbubble.png"
				}, {
					filename: "animals_lion_inbubble.png"
				}, {
					filename: "animals_monkey_inbubble.png"
				}, {
					filename: "animals_rhino_inbubble.png"
				}, {
					filename: "animals_tiger_inbubble.png"
				}
			]
		}, */{
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 42,
						duration: 3
					}, {
						name: "payoff",
						startTime: 46,
						duration: 1
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "animalsinbubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "animals_fish_inbubble.png"
				},
				popped: {
					filename: "animals_fish_outofbubble.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "fish_purple.png"
						},{
							type: "Found",
							filename: "fish_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "animals_bird_inbubble.png"
				}, {
					filename: "animals_cat_inbubble.png"
				}, {
					filename: "animals_dog_inbubble.png"
				}, {
					filename: "animals_elephant_inbubble.png"
				}, {
					filename: "animals_hippo_inbubble.png"
				}, {
					filename: "animals_lion_inbubble.png"
				}, {
					filename: "animals_monkey_inbubble.png"
				}, {
					filename: "animals_rhino_inbubble.png"
				}, {
					filename: "animals_tiger_inbubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 35,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 39,
						duration: 1
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "animalsinbubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "animals_hippo_inbubble.png"
				},
				popped: {
					filename: "animals_hippo_outofbubble.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "hippo_purple.png"
						},{
							type: "Found",
							filename: "hippo_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "animals_bird_inbubble.png"
				}, {
					filename: "animals_cat_inbubble.png"
				}, {
					filename: "animals_dog_inbubble.png"
				}, {
					filename: "animals_elephant_inbubble.png"
				}, {
					filename: "animals_fish_inbubble.png"
				}, {
					filename: "animals_lion_inbubble.png"
				}, {
					filename: "animals_monkey_inbubble.png"
				//}, {
				//	filename: "animals_rhino_inbubble.png"
				}, {
					filename: "animals_tiger_inbubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 0,
						duration: 3
					}, {
						name: "payoff",
						startTime: 4,
						duration: 1
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "animalsinbubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "animals_lion_inbubble.png"
				},
				popped: {
					filename: "animals_lion_outofbubble.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "lion_purple.png"
						},{
							type: "Found",
							filename: "lion_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "animals_bird_inbubble.png"
				//}, {
				//	filename: "animals_cat_inbubble.png"
				}, {
					filename: "animals_dog_inbubble.png"
				}, {
					filename: "animals_elephant_inbubble.png"
				}, {
					filename: "animals_fish_inbubble.png"
				}, {
					filename: "animals_hippo_inbubble.png"
				}, {
					filename: "animals_monkey_inbubble.png"
				}, {
					filename: "animals_rhino_inbubble.png"
				//}, {
				//	filename: "animals_tiger_inbubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 21,
						duration: 3
					}, {
						name: "payoff",
						startTime: 25,
						duration: 1
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "animalsinbubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "animals_monkey_inbubble.png"
				},
				popped: {
					filename: "animals_monkey_outofbubble.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "monkey_purple.png"
						},{
							type: "Found",
							filename: "monkey_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "animals_bird_inbubble.png"
				}, {
					filename: "animals_cat_inbubble.png"
				}, {
					filename: "animals_dog_inbubble.png"
				}, {
					filename: "animals_elephant_inbubble.png"
				}, {
					filename: "animals_fish_inbubble.png"
				}, {
					filename: "animals_hippo_inbubble.png"
				}, {
					filename: "animals_lion_inbubble.png"
				}, {
					filename: "animals_rhino_inbubble.png"
				}, {
					filename: "animals_tiger_inbubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 63,
						duration: 3
					}, {
						name: "payoff",
						startTime: 67,
						duration: 1
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "animalsinbubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "animals_rhino_inbubble.png"
				},
				popped: {
					filename: "animals_rhino_outofbubble.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "rhino_purple.png"
						},{
							type: "Found",
							filename: "rhino_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "animals_bird_inbubble.png"
				}, {
					filename: "animals_cat_inbubble.png"
				}, {
					filename: "animals_dog_inbubble.png"
				//}, {
				//	filename: "animals_elephant_inbubble.png"
				}, {
					filename: "animals_fish_inbubble.png"
				//}, {
				//	filename: "animals_hippo_inbubble.png"
				}, {
					filename: "animals_lion_inbubble.png"
				}, {
					filename: "animals_monkey_inbubble.png"
				}, {
					filename: "animals_tiger_inbubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 7,
						duration: 3
					}, {
						name: "payoff",
						startTime: 11,
						duration: 1
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "animalsinbubbles_empty.png"
			},
			target: {
				unpopped: {
					filename: "animals_tiger_inbubble.png"
				},
				popped: {
					filename: "animals_tiger_outofbubble.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "tiger_purple.png"
						},{
							type: "Found",
							filename: "tiger_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "animals_bird_inbubble.png"
				//}, {
				//	filename: "animals_cat_inbubble.png"
				}, {
					filename: "animals_dog_inbubble.png"
				}, {
					filename: "animals_elephant_inbubble.png"
				}, {
					filename: "animals_fish_inbubble.png"
				}, {
					filename: "animals_hippo_inbubble.png"
				//}, {
				//	filename: "animals_lion_inbubble.png"
				}, {
					filename: "animals_monkey_inbubble.png"
				}, {
					filename: "animals_rhino_inbubble.png"
				}
			]
		}
	]
};