/**
*  Sesame Street
*
*  @author William Malone (www.williammalone.com)
*/

WM.commonHud = function (GLOBAL, WM, ctx, options) {
	
	var that = WM.view(GLOBAL, WM, ctx, options),
		exitButtonImg = new Image(),
		exitButtonImgLoaded = false,
		padding = 5,
		exitButtonSrc = options.exitButtonFilename !== undefined ? options.resourcePath + options.exitButtonFilename : "../../common/images/exit-button.png";
		
	that.type = "COMMON_HUD";
	
	that.render = function () {
		var pos = window.innerWidth;
		if(screen.mozOrientation == "portrait-primary" || screen.mozOrientation == "portrait-secondary")
			pos = window.innerWidth;
		if (that.dirty) {
			if (exitButtonImgLoaded) {
				that.ctx.drawImage(
					exitButtonImg,
					pos - exitButtonImg.width - padding,
					padding
				);
				
				that.dirty = false;
			}
		}
	};
	
	that.load = function () {

		exitButtonImg.onload = function () {
			exitButtonImgLoaded = true;
			that.dirty = true;
			that.render();
			that.dispatchEvent("READY");
		};
		exitButtonImg.src = exitButtonSrc;
		
	};
	
	that.touchEnd = function (point) {
		
		if (that.ctx === undefined) {
			WM.debug("common hud ctx undefined: " + that.ctx);
			return;
		}
		
		if (that.ctx === null) {
			WM.debug("common hud ctx null: " + that.ctx);
			return;
		}
		
		var pos = window.innerWidth;
		if(screen.mozOrientation == "portrait-primary" || screen.mozOrientation == "portrait-secondary")
			pos = window.innerWidth;
		
		if (WM.Util.rectCollision({
				x: point.x * window.innerWidth/1024,
				y: point.y * window.innerHeight/768,
				width: 1, 
				height: 1
			},{
				x: pos - exitButtonImg.width - padding, 
				y: padding, 
				width: exitButtonImg.width, 
				height: exitButtonImg.height
			})) {	
			that.dispatchEvent("EXIT_GAME");
		}
	};
	
	return that;
}