/**
*  Sesame Street Bubble Pop Game
*
*  @author William Malone (www.williammalone.com)
*/

WM.seekItem = function (GLOBAL, WM, ctx, options) {
	
	var that = WM.view(GLOBAL, WM, ctx, options),
		found = false;
	
	that.targetItem = options && options.target,
	that.maskItem = options && options.mask;	
	that.type = "SEEK";
	that.alwaysDirty = true;
	that.width = 100;
	that.height = 100;

	that.update = function () {
		
		that.targetItem.update();
		if (that.maskItem) {
			that.maskItem.update();
		}
	};
	
	that.render = function () {
		
		if (that.dirty || that.alwaysDirty) {
			that.targetItem.render();
			if (that.maskItem) {
				that.maskItem.render();
			}
			that.dirty = false;
		}
	};
	
	that.wiggle = function () {
		that.targetItem.wiggle();
	};
	
	that.setFound = function (isFound) {
		found = isFound;

		//that.targetItem.addEventListener("ANIMATION_COMPLETE", function () {
		//	that.targetItem.foundComplete();
		//});
		that.targetItem.setState("FOUND");
		if (that.maskItem) {
			that.maskItem.found = isFound;
		}
	};
	
	that.getFound = function () {
		return found;
	};
	
	that.touchStart = function (point) {
		that.targetItem.touchStart(point);
		if (that.maskItem) {
			that.maskItem.touchStart(point);
		}
	};
	
	that.touchMove = function (point) {
		that.targetItem.touchMove(point);
		if (that.maskItem) {
			that.maskItem.touchMove(point);
		}
	};
	
	that.touchEnd = function (point) {
		that.targetItem.touchEnd(point);
		if (that.maskItem) {
			that.maskItem.touchEnd(point);
		}
	};
	
	return that;
}