/**
 * Variáveis globais para manipulação da view
 */
var id    = 0,
    jogos = [],
    desc  = document.getElementById("itemdesc"),
    val   = document.getElementById("itemval"),
    list  = document.getElementById("itemList"),
    ltview  = document.getElementById("listView"),
    dtview  = document.getElementById("detailView"),
    loading  = document.getElementById("loading"),
    total  = document.getElementById("thetotal");

/**
 * Função responsável por obter os resultados dos jogos
 */
function getItens() {
    loading.classList.toggle("rotating");
    list.innerHTML = "<h2 style='text-align:center;margin-top:50px'>Carregando...</h2>";
    xhr("http://worldcup.sfg.io/matches?by_date=desc",function(items) {
        jogos = items;
        showItens();
        loading.classList.toggle("rotating");
        console.log(jogos[jogos.length-1]);
    });
}

/**
 * Função responsável pela Requisição HTTP
 */
function xhr(url, cb){
    var xmlHttp;
    try{
        xmlHttp= new window.XMLHttpRequest({mozSystem: true});
    } catch(e) {
        try{
            xmlHttp=new XMLHttpRequest(); 
        } catch(e) {
            try {
                xmlHttp=new ActiveXObject("Msxml2.XMLHTTP"); 
            } catch(e) {
                try {
                    xmlHttp=new ActiveXObject("Microsoft.XMLHTTP"); 
                } catch(e) {
                    alert("Seu navegador não suporta AJAX!"); 
                    return false;
                }
            }
        }
    }
    xmlHttp.timeout = 30000;
    xmlHttp.open("GET", url);
    xmlHttp.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
    xmlHttp.onload = function(){
        if (xmlHttp.readyState==4) {
            if ((xmlHttp.status == 200) || (xmlHttp.status == 0)) {
                if (cb != undefined) {
                    cb(JSON.parse(xmlHttp.response));
                } else {
                    return xmlHttp.response;
                }
            } else {
                loading.classList.toggle("rotating");
                list.innerHTML = "<h2 style='text-align:center;margin-top:50px'>"+
                    "Não foi possível carregar resultados</h2>" +
                    "<p style='text-align:center'>Verifique sua conexão com a internet</p>"+
                    "<p style='text-align:center'>Erro: "+xmlHttp.status;
            }
        }
    };
    xmlHttp.send(null);            
};
/**
 * Função para trocar a view da app.
 */
function switchView(view) {
    switch(view) {
        case "detail":
            ltview.style.left = "-100%";
            dtview.style.left = "0";
            break;
        case "list":
            ltview.style.left = "0";
            dtview.style.left = "100%";
            break;
        default:
            break;
    }
}

function getName(code) {
    switch(code) {
        case "BRA":
            return "Brasil";
            break;
        case "CRO":
            return "Croácia";
            break;
        case "CMR":
            return "Camarões";
            break;
        case "MEX":
            return "México";
            break;
        case "NED":
            return "Holanda";
            break;
        case "ESP":
            return "Espanha";
            break;
        case "AUS":
            return "Austrália";
            break;
        case "CHI":
            return "Chile";
            break;
        case "GRE":
            return "Grécia";
            break;
        case "COL":
            return "Colômbia";
            break;
        case "CRC":
            return "Costa Rica";
            break;
        case "URU":
            return "Uruguai";
            break;
        case "ITA":
            return "Itália";
            break;
        case "ENG":
            return "Inglaterra";
            break;
        case "JPN":
            return "Japão";
            break;
        case "CIV":
            return "Costa do Marfim";
            break;
        case "ECU":
            return "Equador";
            break;
        case "SUI":
            return "Suíça";
            break;
        case "HON":
            return "Honduras";
            break;
        case "FRA":
            return "França";
            break;
        case "BIH":
            return "Bósnia";
            break;
        case "ARG":
            return "Argentina";
            break;
        case "POR":
            return "Portugal";
            break;
        case "GER":
            return "Alemanha";
            break;
        case "NGA":
            return "Nigéria";
            break;
        case "IRN":
            return "Irã";
            break;
        case "USA":
            return "Estados Unidos";
            break;
        case "GHA":
            return "Gana";
            break;
        case "ALG":
            return "Argélia";
            break;
        case "BEL":
            return "Bélgica";
            break;
        case "KOR":
            return "Coréia";
            break;
        case "RUS":
            return "Rússia";
            break;
        default:
            return code;
            break;
    }
}

/**
 * Função para mostrar os detalhes do jogo.
 */
function detail(id) {
    switchView("detail");
    var home = document.getElementById("hometeam"),
        away = document.getElementById("awayteam"),
        jogoid = document.getElementById("jogoid"),
        local = document.getElementById("local"),
        datajogo = document.getElementById("datajogo"),
        etapa = document.getElementById("etapa"),
        data = new Date(jogos[id].datetime);
    
    jogoid.textContent = "#"+jogos[id].match_number;
    local.textContent = jogos[id].location;
    etapa.textContent = getEtapa(jogos[id].match_number);
    datajogo.textContent = [pad(data.getDate()), pad(data.getMonth()+1), data.getFullYear()].join('/')
    home.innerHTML = "<div class='flags "+ jogos[id].home_team.code+"'></div><div>"+ getName(jogos[id].home_team.code) +"<br>"+jogos[id].home_team.goals+"</div>";
    away.innerHTML = "<div class='flags "+ jogos[id].away_team.code+"'></div><div>"+ getName(jogos[id].away_team.code) +"<br>"+jogos[id].away_team.goals+"</div>";
    var events = jogos[id].home_team_events;
    events = events.concat(jogos[id].away_team_events);
    events.sort(function(a,b) { return parseFloat(a.time.substring(0, 2)) - parseFloat(b.time.substring(0, 2)) } );
    showEvents(events);
    function pad(s) { return (s < 10) ? '0' + s : s; }
    function getEtapa(t) {
        if (t<49) {
            return "Classificatória";
        } else if(t>=49 && t<57) {
            return "Oitavas de Final";
        } else if(t>=57 && t<61) {
            return "Quartas de Final";
        } else if (t==61 || t==62) {
            return "Semi-final";
        } else if (t==63) {
            return "Disputa 3º Lugar";
        } else {
            return "Final";
        }
    }          
}

function showEvents(jogo) {
    eventList = document.getElementById("eventList");
    eventList.innerHTML = "";
    for(i=0;i<jogo.length;i++) {
        var li = document.createElement("li");
        li.innerHTML = "<span class='time'>"+jogo[i].time+"'</span><span class='player'>"+jogo[i].player+"</span><span class='type'> "+tType(jogo[i].type_of_event)+"</span>";
        eventList.appendChild(li);
    }
    function tType(s) {
        switch(s){
            case "goal-own":
                return "Gol Contra";
                break;
            case "goal":
                return "Gol";
                break;
            case "yellow-card":
                return "Cartão Amarelo";
                break;
            case "yellow-card-second":
                return "2&deg; Cartão Amarelo";
                break;
            case "red-card":
                return "Cartão Vermelho";
                break;
            case "goal-penalty":
                return "Gol de Penalty";
                break;
            case "penalty-wrong":
                return "Penalty defendido";
                break;
            case "substitution-out":
                return "Saiu";
                break;
            case "substitution-in":
                return "Entrou";
                break;
            case "substitution-in halftime":
                return "Saiu <sup>1/2</sup> Tempo";
                break;
            case "substitution-out halftime":
                return "Entrou <sup>1/2</sup> Tempo";
                break;
            default:
                return s;
                break;
        }
    }
}
/**
 * Função para mostrar os resultados dos jogos na tela.
 */
function showItens() {   
    list.innerHTML = '';
    var tot = 0,
        rest = 0;
    for(i=0;i<jogos.length;i++) {
        if(jogos[i].status != "completed") {
            rest++;
            continue;
        }
        tot++;
        var li = document.createElement("li"),
            d = document.createElement("span"),
            o = document.createElement("span"),
            clear = document.createElement("div");
        
        li.setAttribute("id", i);
        li.addEventListener("click", function(e) {
            detail(this.id);
        });
        
        d.innerHTML = "<span class='flags "+jogos[i].away_team.code+"'></span><span class='placar'>"+jogos[i].away_team.code+" "+jogos[i].away_team.goals + " x "+ jogos[i].home_team.goals +" "+jogos[i].home_team.code+"</span><span class='flags "+jogos[i].home_team.code+"'></span>";
        d.className = "desc";
        o.className = "icon-arrow-right";
        clear.className = "clear";
        li.appendChild(d);
        li.appendChild(o);
        li.appendChild(clear);
        list.appendChild(li);
    }
    total.textContent = "Total: "+tot+" | Jogos Restantes: "+rest;
}

/**
 * Inicializando o aplicativo
 */
document.getElementById("backList").addEventListener("click",function(){switchView("list")});
loading.addEventListener("click",getItens);
getItens();