var lang = "en";
var originalLang="en";
var langs = ["en", "fr"];

$(function() {

	try {
		var l = document.webL10n.getLanguage();
		//console.log("Detected lang is "+l);
		if (l && l.indexOf('-') != -1) {
			l = l.split('-');
			for (var i in langs) {
				if (langs[i] == l[0]) {
					lang = l[0];
					originalLang=lang;
				}
			}
		}
	} catch (e) {
		lang = "fr";
	}
	//console.log("lang is now "+lang);
	zero = "000";
	useLocalStorage = true;
	defaultFontSize = 16;

	var current_soura = 1;

	nextSoura = function() {
		id = current_soura;
		if (id == 114)
			id = 0;
		viewSoura(++id);
	};
	prevSoura = function() {
		id = current_soura;
		if (id == 1)
			id = 115;
		viewSoura(--id);
	};


	initSettings = function() {
		forceLang = $("#settingForceLanguage");
		forceLang.empty();
		forceLang.append(new Option(document.webL10n.get("none"), ""));
		for (var l in langs) {
			forceLang.append(new Option(document.webL10n.get(langs[l]), langs[l]));
			//console.log("appended lang "+langs[l]+" as "+document.webL10n.get(langs[l]));
		}
		for (var s in settings) {
			var keyName = settings[s];
			$('#setting' + keyName).val(localStorage[keyName]);
		}
		
		//console.log('init setting with lang '+lang);
	};

	saveSettings = function() {
		if (useLocalStorage) {
			for (var key in options) {
				keyName = options[key];
				localStorage.setItem(keyName, $('#' + keyName).is(':checked'));
			}
			localStorage.setItem('fontSize', $('#fontSize').val());
			localStorage.setItem('current_soura', current_soura);
			for (var s in settings) {
				var keyName = settings[s];
				localStorage.setItem(keyName, $('#setting' + keyName).val());
			}
		}
		loadConfig();
		updateUI();
		
	};

	/********/
	var options = ['translation', 'transliteration', 'ayaNumber','listOnStartup','audio'];
	var settings = ['ForceLanguage'];

	fr_titles = ["Prologue", "La vache", "La famille d'Imran", "Les femmes", "La table servie", "Les bestiaux", "Al-Araf", "Le butin", "Le repentir", "Jonas", "Hud", "Joseph", "Le tonnerre", "Abraham", "Al-Hijr", "Les abeilles", "Le voyage nocturne", "La caverne", "Marie", "Ta-Ha", "Les prophètes", "Le pélerinage", "Les croyants", "La lumière", "Le discernement", "Les poètes", "Les fourmis", "Le récit", "L'araignée", "Les romains", "Luqman", "La prosternation", "Les coalisés", "Saba", "Le Créateur", "Ya-Sin", "Les rangés", "Sad", "Les groupes", "Le pardonneur", "Les versets détaillés", "La consultation", "L'ornement", "La fumée", "L'agenouillée", "Al-Ahqaf", "Muhammad", "La victoire éclatante", "Les appartements", "Qaf", "Qui éparpillent", "At-Tur", "L'étoile", "La lune", "Le Tout Miséricordieux", "L'événement", "Le fer", "La discussion", "L'exode", "L'éprouvée", "Le rang", "Le vendredi", "Les hypocrites", "La grande perte", "Le divorce", "L'interdiction", "La royauté", "La plume", "Celle qui montre la vérité", "Les voies d'ascension", "Noé", "Les djinns", "L'enveloppé", "Le revêtu d'un manteau", "La résurrection", "L'homme", "Les envoyés", "La nouvelle", "Les anges qui arrachent les âmes", "Il s'est renfrogné", "L'obscurcissement", "La rupture", "Les fraudeurs", "La déchirure", "Les constellations", "L'astre nocturne", "Le Très-Haut", "L'enveloppante", "L'aube", "La cité", "Le soleil", "La nuit", "Le jour montant", "L'ouverture", "Le figuier", "L'adhérence", "La Destinée", "La preuve", "La secousse", "Les coursiers", "Le fracas", "La course aux richesses", "Le temps", "Les calomniateurs", "L'éléphant", "Qoraïsh", "L'ustensile", "L'abondance", "Les infidèles", "Les secours", "Les fibres", "Le monothéisme pur", "L'aube naissante", "Les hommes"];

	loadConfig = function() {
		if (useLocalStorage && localStorage.getItem('fontSize')) {
			for (var key in options) {
				keyName = options[key];
				$('#' + keyName).prop('checked', localStorage[keyName] == "true");
			}
			if (localStorage['current_soura'])
				current_soura = localStorage['current_soura'];
			if (localStorage['ForceLanguage']) {
				lang = localStorage['ForceLanguage'];
				//save-changes = Save changes;
				//console.log('force lang to ' + lang+' type'+typeof(lang));
				document.webL10n.setLanguage(lang);
			} else if (lang!=originalLang) {
				//console.log("Restore original lang "+originalLang);
				lang=originalLang;
				document.webL10n.setLanguage(originalLang);
			}
			var fontSize = localStorage['fontSize'];
			if (!fontSize || fontSize == '')
				fontSize = defaultFontSize;
			$('#fontSize').val(fontSize);
		}

		if (!$('#fontSize').val()) {
			$('#fontSize').val(defaultFontSize);
		}
	};
	updateUI = function() {
		//console.log("Updating UI with lang "+lang);
		/*
		if (lang && lang!="null") {
			console.log(' force lang to ' + lang+' type'+typeof(lang));
			document.webL10n.setLanguage(lang);
		}*/
		$('.ayaNumber').css('visibility', $('#ayaNumber').is(':checked') ? "visible" : "hidden");
		for (var l in langs) {
			$('.' + langs[l] + '.main').css('display', "none");
		}
		$('.' + lang + '.main').css('display', $('#translation').is(':checked') ? "block" : "none");
		$('.en.translit').css('display', $('#transliteration').is(':checked') ? "block" : "none");
		//audio

		//console.log("set font size to "+$('#fontSize').val());
		$('body').css('font-size', ($('#fontSize').val() / 16) + 'em');

		$('#sourasNav').empty();
		for (var i = 1; i < QuranData.Sura.length - 1; i++) {
			var name = i + ":";
			if (lang == 'fr')
				name = name + " " + fr_titles[i - 1];
			name = name + " " + QuranData.Sura[i][5];
			name = name + " " + QuranData.Sura[i][4];
			classNames = (current_soura == i) ? 'btn active' : 'btn btn-default';
			$('#sourasNav').append('<button type="button" class="' + classNames + '" onclick="viewSoura(' + i + ');" data-dismiss="modal">' + name + "</button>");
		}
	};
	updateSouraTitle = function(id) {
		trTitle=(lang=="fr")?fr_titles[parseInt(id - 1)]:QuranData.Sura[parseInt(id)][6];
		$('#souraTitle').text(trTitle + " - " + QuranData.Sura[parseInt(id)][5] + " (" + QuranData.Sura[parseInt(id)][4] + ")");
	};
	viewSoura = function(id) {
		current_soura = id;
		if (id.length != 3) {
			id = (zero + id).slice(-zero.length);
		}
		if (useLocalStorage)
			localStorage['current_soura'] = current_soura;

		trTitle='<span class="fr main">'+fr_titles[parseInt(id - 1)]+'</span> <span class="en main">'+QuranData.Sura[parseInt(id)][6]+'</span>';
		$('#souraTitle').html(trTitle + " " + QuranData.Sura[parseInt(id)][5] + " (" + QuranData.Sura[parseInt(id)][4] + ")");

		$('#souraContent').load('data/' + id + '.html', function() {
			updateUI();
		});

		//console.log("Done " + 'data/' + id + '.html');
		//alert(lang+' = '+nextSouraLabel);
	};

	/* events */
	$('.souraNext').click(nextSoura);
	$('.souraPrevious').click(prevSoura);
	$('#settingClose').click(updateUI);
	$('#settingSave').click(saveSettings);
	
	
	/* initialisation */
	loadConfig();
	updateUI();
	viewSoura(current_soura);
	window.addEventListener('localized', function() {
		//console.log("localize done");
		initSettings();
		//console.log("localize done");
	},false);
	//console.log("Init done");

	/* end */
});

