// #######################################################################################
//
// Corrente by Thomas Sturm 2013
//
// #######################################################################################

(function () {

	var CorrenteVersion = '1.0.8';

	// initialize the brick cards deck
	var deck;
	document.addEventListener('DOMComponentsLoaded', function(){
		deck = document.querySelector("x-deck");
	});
	
	
	// user language detection
	var lang=navigator.browserLanguage||navigator.language;
	var langpack = 'en';
	var langpacks=[];
	langpacks['en']='|en|en-au|en-bz|en-ca|en-ie|en-jm|en-nz|en-ph|en-za|en-tt|en-gb|en-us|en-zw|';
	langpacks['es']='|es|es-ar|es-bo|es-cl|es-co|es-cr|es-do|es-ec|es-sv|es-gt|es-hn|es-mx|es-ni|es-pa|es-py|es-pe|es-pr|es-es|es-uy|es-ve|';
	langpacks['de']='|de|de-at|de-de|de-li|de-lu|de-ch|';
	langpacks['pt']='|pt|pt-br|pt-pt|';
	langpacks['it']='|it|it-ch|it-it|';
	if (lang!='') {
		for (var item in langpacks) {
			if (langpacks.hasOwnProperty(item)) {
				if (langpacks[item].indexOf('|'+lang.toLowerCase()+'|')!=-1) {
					langpack=item;
				}
			}
		}
	}


	// override with stored language preset
	var langStore = localStorage.getItem('languagepreset');
	if (langStore != null) {
		langpack = langStore;
	}


	var language_bundle = [];
	
	// English
	language_bundle['en'] = [];
	language_bundle['en']['statheader'] = 'Statistics';
	language_bundle['en']['exportheader'] = 'Export Data';
	language_bundle['en']['export-data'] = 'Export';
	language_bundle['en']['config-done'] = 'Done';
	language_bundle['en']['newnotecontent'] = 'Touch to edit';
	language_bundle['en']['deletecontentoneitem'] = ' (This entry contains one other item)';
	language_bundle['en']['deletecontentmultiple'] = ' (This entry contains several other items)';
	language_bundle['en']['thiswilldelete'] = 'This will delete';
	language_bundle['en']['areyousure'] = 'Are you sure?';
	
	// Spanish
	language_bundle['es'] = [];
	language_bundle['es']['statheader'] = 'Estadística';
	language_bundle['es']['exportheader'] = 'Exportar datos';
	language_bundle['es']['export-data'] = 'Exportar';
	language_bundle['es']['config-done'] = 'Hecho';
	language_bundle['es']['newnotecontent'] = 'Toque para editar';
	language_bundle['es']['deletecontentoneitem'] = ' (Esta entrada contiene otro elemento)';
	language_bundle['es']['deletecontentmultiple'] = ' (Este registro contiene varios otros artículos)';
	language_bundle['es']['thiswilldelete'] = 'Esto eliminará';
	language_bundle['es']['areyousure'] = '¿Está seguro?';

	// German
	language_bundle['de'] = [];
	language_bundle['de']['statheader'] = 'Statistik';
	language_bundle['de']['exportheader'] = 'Datenexport';
	language_bundle['de']['export-data'] = 'Export';
	language_bundle['de']['config-done'] = 'Fertig';
	language_bundle['de']['newnotecontent'] = 'Hier Berühren';
	language_bundle['de']['deletecontentoneitem'] = ' (Dieser Eintrag enthält eine weitere Notiz)';
	language_bundle['de']['deletecontentmultiple'] = ' (Dieser Eintrag enthält mehrere weitere Notizen)';
	language_bundle['de']['thiswilldelete'] = 'Bitte Bestätigen Sie die Löschung von';
	language_bundle['de']['areyousure'] = 'Sind Sie sicher?';
	
	// Portuguese
	language_bundle['pt'] = [];
	language_bundle['pt']['statheader'] = 'Estatística';
	language_bundle['pt']['exportheader'] = 'Os dados de exportação';
	language_bundle['pt']['export-data'] = 'Exportar';
	language_bundle['pt']['config-done'] = 'Feito';
	language_bundle['pt']['newnotecontent'] = 'Toque para editar';
	language_bundle['pt']['deletecontentoneitem'] = ' (Esta entrada contém um outro item)';
	language_bundle['pt']['deletecontentmultiple'] = ' (Esta entrada contém vários outros itens)';
	language_bundle['pt']['thiswilldelete'] = 'Isto irá apagar';
	language_bundle['pt']['areyousure'] = 'Você tem certeza?';
	
	// Italian
	language_bundle['it'] = [];
	language_bundle['it']['statheader'] = 'Statistiche';
	language_bundle['it']['exportheader'] = 'Esporta dati';
	language_bundle['it']['export-data'] = 'Esportazione';
	language_bundle['it']['config-done'] = 'Fatto';
	language_bundle['it']['newnotecontent'] = 'Toccare per modificare';
	language_bundle['it']['deletecontentoneitem'] = ' (Questa voce contiene un altro elemento)';
	language_bundle['it']['deletecontentmultiple'] = ' (Questa voce contiene diversi altri elementi)';
	language_bundle['it']['thiswilldelete'] = 'Questo cancellerà';
	language_bundle['it']['areyousure'] = 'Sei sicuro?';


	setHTMLLanguage();


	var dataStore = '';
	dataList = new Array();		// id()parent_id()text()checked()timestamp()geolat()geolng()active()theme_id

	// retrieve previously stored data list
	dataStore = localStorage.getItem('datastore');
	if (dataStore != null) {
		dataList = dataStore.split('|');
	}

	var currentParent = 0;


	// UI presets
	var backColor = [];
	backColor['unchecked'] = '#e1f2ff';
	backColor['checked'] = '#a5c0d4';


	// buttons and UI widgets
    var addNote = document.querySelector('#add-note');
    var editNotes = document.querySelector('#edit-notes');
    var goBack = document.querySelector('#go-back');
    var configApp = document.querySelector('#config-app');
    var configDone = document.querySelector('#config-done');
    var correnteLanguage = document.querySelector('#corrente-language');
//    var exportData = document.querySelector('#export-data');

	
	// content containers
    var levelHeader = document.querySelector('#levelheader');

    notesContainer = new Array();
    for (var a=0;a<10;a++) {
		notesContainer[a] = document.querySelector('#notescontainer'+a);
	}


	// preset status variables
	var notesContainerActive = 0;
	var editMode = 'edit';


	// select the correct language in the config language selector
	for (var a=0;a<correnteLanguage.options.length;a++) {
		if (correnteLanguage.options[a].value == langpack) {
			correnteLanguage.options.selectedIndex = a;
		}
	}

	// for parent==0, set go-back button to hidden
	goBack.style.opacity = '0.3';


	// run through the data and add all active items with parent==0 to the initial screen
	if (dataList.length != 0) {
		for (var a=0;a<dataList.length;a++) {
			d = dataList[a].split('()');
			if (d[1] == 0  &&  d[7] == 1) {
				createNewNote(d[0], d[2], d[3], notesContainerActive);
			}
		}
	}


	if (correnteLanguage) {
		correnteLanguage.onchange = function() {
			langpack = correnteLanguage.options[correnteLanguage.options.selectedIndex].value;
			storeLanguagePreset();
			setHTMLLanguage();
		};
	}


    if (addNote) {
        addNote.onclick = function () {
			if (deck.selectedCard.id != 'notesconfig') {
				cancelDeleteMode();
				var newID = createUniqueID();
				var geoLat = 0;
				var geoLng = 0;
				var timestamp = new Date().getTime();
				createNewNote(newID, language_bundle[langpack]['newnotecontent'], 0, notesContainerActive);
				storeNote(newID, currentParent, language_bundle[langpack]['newnotecontent'], 0, timestamp, geoLat, geoLng, 1, 0);
			}
        };
    }


    if (editNotes) {
        editNotes.onclick = function () {
			if (deck.selectedCard.id != 'notesconfig') {
				if (editMode == 'edit') {
					editMode = 'delete'
					els = notesContainer[notesContainerActive].getElementsByClassName('notewidget');
					for (var a=0;a<els.length;a++) {
						var i = els[a].getElementsByTagName('img');
						i[0].setAttribute('src', 'images/corrente/delete-v2.png');
					}
				} else {
					cancelDeleteMode();
				}
			}
        };
    }


    if (goBack) {
        goBack.onclick = function () {
			if (deck.selectedCard.id != 'notesconfig') {
				cancelDeleteMode();
				if (notesContainerActive > 0) {
					notesContainerActive--;
					// find parent for currentParent, re-render container for that parent
					for (var a=0;a<dataList.length;a++) {
						d = dataList[a].split('()');
						// see if it's a child
						if (d[0] == currentParent) {
							var pp = d[1];
						}
					}
					// empty the card			
					notesContainer[notesContainerActive].innerHTML = '';
					// render the container
					if (dataList.length != 0) {
						for (var a=0;a<dataList.length;a++) {
							d = dataList[a].split('()');
							if (d[1] == pp  &&  d[7] == 1) {
								createNewNote(d[0], d[2], d[3], notesContainerActive);
							}
						}
					}
					// set currentParent to that parent
					currentParent = pp;
					deck.shufflePrev();
					document.querySelector('body').scrollIntoView(true);
					// are we all the way back at the top?
					if (notesContainerActive == 0) {
						levelHeader.innerHTML = '';
						levelHeader.style.visibility = 'hidden';
						// hide the back button
						goBack.style.opacity = '0.3';
					} else {
						// find the id of the first notes container in the deck
						var firstChildID = notesContainer[notesContainerActive].children[0].getAttribute('id');
						// find the parent for this child
						for (var a=0;a<dataList.length;a++) {
							d = dataList[a].split('()');
							if (d[0] == firstChildID) {
								var firstChildParentID = d[1];
							}
						}
						// find the parent text
						for (var a=0;a<dataList.length;a++) {
							d = dataList[a].split('()');
							if (d[0] == firstChildParentID) {
								levelHeader.innerHTML = d[2];
							}
						}
					}
				}
			}
        };
    }


    if (configApp) {
        configApp.onclick = function () {
			if (deck.selectedCard.id != 'notesconfig') {
				levelHeader.style.visibility = 'hidden';
				// update statistics
				var activeNodes = 0;
				for (var a=0;a<dataList.length;a++) {
					var d = dataList[a].split('()');
					// see if it's a child
					if (d[7] == 1) {
						activeNodes++;
					}
				}
				document.getElementById('correnteStats').innerHTML = 'App Version: ' + CorrenteVersion + '<br>Nodes: '+activeNodes;
				// show config card
				deck.shuffleTo(10);
			}
        };
    }


    if (configDone) {
        configDone.onclick = function () {
        	if (notesContainerActive != 0) {
				levelHeader.style.visibility = 'visible';
			}
			deck.shuffleTo(notesContainerActive);
        };
    }

/*
    if (exportData) {
        exportData.onclick = function () {
        
			var emailList = getPrintableList(0);
//console.log('emailList: '+emailList);
			var body = encodeURIComponent(emailList);
			var createEmail = new MozActivity({
				name: "new",
				data: {
					type : "mail",
					url: "mailto:?subject=Corrente%20Data&body=" + body,
				}
			});
			deck.shuffleTo(notesContainerActive);
        };
    }
*/

	// recursively create list of children from a parent, formatted for export
	function getPrintableList(pid) {
//console.log('pid:'+pid)
		var ds = '';
		for (var i in dataList) {
			if (dataList.hasOwnProperty(i)) {
				var d = dataList[i].split('()');
				if (d[7] == 1  &&  d[1] == pid) {
					ds = ds + d[2] + '<br>';
					ds = ds + getPrintableList(d[0]);
				}
			}
		}
//console.log('ds:'+ds)
		if (ds != '') {
			ds = '--------<br>children:<br>' + ds + '--------<br>';
		}
		return ds;
	}

	
	
	function storeLanguagePreset() {
		localStorage.setItem('languagepreset', langpack);
	}


	function setHTMLLanguage() {
		// modify HTML innerTexts with the correct language
		document.getElementById('statheader').innerHTML = language_bundle[langpack]['statheader'];
//		document.getElementById('exportheader').innerHTML = language_bundle[langpack]['exportheader'];
//		document.getElementById('export-data').innerHTML = language_bundle[langpack]['export-data'];
		document.getElementById('config-done').innerHTML = language_bundle[langpack]['config-done'];
	}


	function cancelDeleteMode() {
		editMode = 'edit'
		els = notesContainer[notesContainerActive].getElementsByClassName('notewidget');
		for (var a=0;a<els.length;a++) {
			var i = els[a].getElementsByTagName('img');
			// check object parent ID and then check datalist if there are any children, if so use _contains
			var thisID = i[0].parentNode.parentNode.getAttribute('id');
			// see if there are any children
			var widget_extension = '';
			var childNum = 0;
			for (var b=0;b<dataList.length;b++) {
				d = dataList[b].split('()');
				// see if it's a child
				if (d[1] == thisID  &&  d[7] == 1) {
					childNum++;
				}
			}
			if (childNum > 0) {
				widget_extension = '_contains';
				// check if all children are checked, if so use _complete
				if (anyChildrenUnchecked(thisID)) {
					widget_extension = '_complete';
				}
			}
			i[0].setAttribute('src', 'images/corrente/handle_wide'+widget_extension+'-v1.png');
		}
	}


	function createNewNote(newID, newText, newCheck, container) {
		var newDiv = document.createElement('div');
		newDiv.setAttribute('class', 'onenote');
		newDiv.setAttribute('id', newID);
		if (newCheck == 1) {
			newDiv.style.backgroundColor = backColor['checked'];
		}

		var checkDiv = document.createElement('div');
		var checkImg = document.createElement('img');
		if (newCheck == 1) {
			checkImg.setAttribute('src','images/corrente/box-checked-v1.png');
		} else {
			checkImg.setAttribute('src','images/corrente/box-unchecked-v1.png');
		}
		checkDiv.appendChild(checkImg);
		checkDiv.setAttribute('class','notecheck');
		newDiv.appendChild(checkDiv);

		var contentDiv = document.createElement('div');
		var newContent = document.createTextNode(newText);
		contentDiv.appendChild(newContent);
		contentDiv.setAttribute('class','notecontent');
		contentDiv.setAttribute('contentEditable','true');
		newDiv.appendChild(contentDiv);

		var widget_extension = '';
		// see if there are any children
		var childNum = 0;
		for (var a=0;a<dataList.length;a++) {
			d = dataList[a].split('()');
			// see if it's a child
			if (d[1] == newID  &&  d[7] == 1) {
				childNum++;
			}
		}
		if (childNum > 0) {
			widget_extension = '_contains';
			// check if all children are checked, if so use _complete
			if (anyChildrenUnchecked(newID)) {
				widget_extension = '_complete';
			}
		}

		var widgetDiv = document.createElement('div');
		var widgetImg = document.createElement('img');
		widgetImg.setAttribute('src','images/corrente/handle_wide' + widget_extension + '-v1.png');
		widgetDiv.appendChild(widgetImg);
		widgetDiv.setAttribute('class','notewidget');
		newDiv.appendChild(widgetDiv);

		var breakDiv = document.createElement('br');
		breakDiv.setAttribute('class','breakcontent');
		newDiv.appendChild(breakDiv);

		notesContainer[container].appendChild(newDiv);

		checkImg.addEventListener('click', function(){toggleCheck(this)}, false);
		widgetImg.addEventListener('click', function(){widgetClick(this)}, false);
		contentDiv.addEventListener('click', function(){clearNew(this)}, false);
		contentDiv.addEventListener('blur', function(){cleanContent(this)}, false);
		contentDiv.addEventListener('input', function(){watchContent(this)}, false);
	}


	function anyChildrenUnchecked(pid) {
		// check if all children are checked (not recursive)
		var childchecked = true;
		for (var a=0;a<dataList.length;a++) {
			d = dataList[a].split('()');
			// see if it's a child
			if (d[1] == pid  &&  d[7] == 1  &&  d[3] == 0) {
				childchecked = false;
			}
		}
		return childchecked;
	}


	function toggleCheck(el) {
		var state = el.getAttribute('src');
		var s = 0;
		if (state.indexOf('unchecked') != -1) {
			el.setAttribute('src','images/corrente/box-checked-v1.png');
			el.parentNode.parentNode.style.backgroundColor = backColor['checked'];
			s = 1;
		} else {
			el.setAttribute('src','images/corrente/box-unchecked-v1.png');
			el.parentNode.parentNode.style.backgroundColor = backColor['unchecked'];
		}
		oldID = el.parentNode.parentNode.getAttribute('id');
		changeNote(oldID, null, null, s, null, null, null, null, null);
	}


	// if the user touches a note and it hadn't been modified yet, remove the boilerplate text
	function clearNew(el) {
		if (el.textContent == language_bundle[langpack]['newnotecontent']) {
			el.textContent = ' ';
		}
	}


	// called on item blur, clean content before storing the data
	function cleanContent(el) {
		if (el.textContent.substring(el.textContent.length-1,el.textContent.length) == ' ') {
			el.textContent = el.textContent.substring(0,el.textContent.length-1);
		}
		// remove all "()" instances and replace with "[]"
		el.textContent = el.textContent.replace(/\(\)/g, "[]");
		oldID = el.parentNode.getAttribute('id');
		changeNote(oldID,null,el.textContent,null,null,null,null,null,null);
	}


	// Whenever a note content is modified by the user we check for some display exceptions here
	function watchContent(el) {
		// the user hit return, remove the breaks and blur the item which will trigger a call to cleanContent()
		if (el.innerHTML.indexOf('<br><br>') != -1) {
			el.textContent = el.textContent.substring(0,el.innerHTML.indexOf('<br><br>'));
			el.blur();
		}
	}


	// user touch on the tool area at the right side of the note
	function widgetClick(el) {
		if (editMode == 'edit') {				// default mode, move one level down
			// show the back button
			goBack.style.opacity = '1';
		
			// get the next card in the deck
			if (notesContainerActive < 9) {
				notesContainerActive++;
			}
			// empty the new card			
			notesContainer[notesContainerActive].innerHTML = '';
			// get the data for the new level and fill the card
			currentParent = el.parentNode.parentNode.getAttribute('id');
			for (var a=0;a<dataList.length;a++) {
				d = dataList[a].split('()');
				// see if it's a child
				if (d[1] == currentParent  &&  d[7] == 1) {
					createNewNote(d[0], d[2], d[3], notesContainerActive);
				}
				// see if it's the parent, put the text into the header
				if (d[0] == currentParent) {
					// for the header we do only show the first few words
					var lh = d[2].substring(0,38);
					if (d[2].length > 38) {
						lh += '...';
					}
					levelHeader.innerHTML = lh;
					levelHeader.style.visibility = 'visible';
				}
			}
			deck.shuffleNext();
			document.querySelector('body').scrollIntoView(true);
		} else {							// user has initiated delete mode, delete this item
			// see if there are any children
			var childNum = 0;
			for (var a=0;a<dataList.length;a++) {
				d = dataList[a].split('()');
				// see if it's a child
				if (d[1] == el.parentNode.parentNode.getAttribute('id')  &&  d[7] == 1) {
					childNum++;
				}
			}
			if (childNum > 0) {
				if (childNum == 1) {
					var childText = language_bundle[langpack]['deletecontentoneitem'];
				} else {
					var childText = language_bundle[langpack]['deletecontentmultiple'];
				}
			} else {
				var childText = '';
			}
			// confirm with the user
			var c = confirm(language_bundle[langpack]['thiswilldelete']+' "'+el.parentNode.parentNode.textContent+'"'+childText+'. '+language_bundle[langpack]['areyousure']);
			if (c == true) {
				// delete the note
				deleteNote(el.parentNode.parentNode.getAttribute('id'));						// delete note and all its children
				el.parentNode.parentNode.parentNode.removeChild(el.parentNode.parentNode);		// remove the note from DOM
			}
			cancelDeleteMode();
		}
	}


	// delete a node and all linked children recursively
	function deleteNote(nid) {
		changeNote(nid, null, null, null, null, null, null, 0, null);
		// find any children
		for (var a=0;a<dataList.length;a++) {
			d = dataList[a].split('()');
			if (d[1] == nid  &&  d[7] == 1) {
				deleteNote(d[0]);
			}
		}
	}


	// unique id numbers for newly created notes
	function createUniqueID() {
		var all_zeros = '0000000000';
		var id = new Date().getTime();
		// randomize the script id thoroughly by multiplying/dividing the timestamp with two random numbers
		do { r1 = Math.floor(Math.random() * 500); } while (r1 < 1 || 100 < r1);      /* 1...99 */
		do { r2 = Math.floor(Math.random() * 500); } while (r2 < 101 || 200 < r2);    /* 101...199 */
		id = Math.floor((id * r1) / r2);
		var fixed_width_id = id.toString().substring(0,10);
		if (fixed_width_id.length < 10) {
			fixed_width_id = fixed_width_id + all_zeros.substring(0,10-fixed_width_id.length);
		}
		return id;
	}

	
	// create a new note entry and trigger storage event
	function storeNote(id,parent,text,checked,tstmp,geoLat,geoLng,active,theme) {
		dataList.push(id+'()'+parent+'()'+text+'()'+checked+'()'+tstmp+'()'+geoLat+'()'+geoLng+'()'+active+'()'+theme);
		updateDataStore();
	}


	// modify an existing note and store the change
	function changeNote(id,parent,text,checked,tstmp,geoLat,geoLng,active,theme) {
		for (var i in dataList) {
			if (dataList.hasOwnProperty(i)) {
				if (dataList[i].indexOf(id) == 0) {
					d = dataList[i].split('()');
					if (text != null) {
						d[2] = text;
					}
					if (checked != null) {
						d[3] = checked;
					}
					if (active != null) {
						d[7] = active;
					}
					if (checked != null) {
						d[8] = theme;
					}
					dataList[i] = d[0]+'()'+d[1]+'()'+d[2]+'()'+d[3]+'()'+d[4]+'()'+d[5]+'()'+d[6]+'()'+d[7]+'()'+d[8];
				}
			}
		}
		updateDataStore();
	}


	// store all active notes in localStorage - this will delete all notes marked as inactive
	function updateDataStore() {
		var ds = '';
		for (var i in dataList) {
			if (dataList.hasOwnProperty(i)) {
				d = dataList[i].split('()');
				if (d[7] == 1) {
					ds = ds + dataList[i] + '|';
				}
			}
		}
		ds = ds.substring(0,ds.length-1);
		localStorage.setItem('datastore', ds);
	}




    
})(); 
