﻿/*
 * index/bindingHandlers.js
 *
 * Copyright (c) CorvusGPS.com, 2015. All rights reserved.
 */

// binding handler for the single device/group toggle button
ko.bindingHandlers.groupToggle = {
    init: function (element, valueAccessor) {
        var currentValue = valueAccessor();
        if (currentValue === true) {
            $(element).attr("src", "images/single-device.svg");
        } else {
            $(element).attr("src", "images/group.svg");
        }
    },
    update: function (element, valueAccessor) {
        var currentValue = valueAccessor();
        if (currentValue === true) {
            $(element).attr("src", "images/single-device.svg");
        } else {
            $(element).attr("src", "images/group.svg");
        }
    }
};

// binding handler for the latest position/interval toggle button
ko.bindingHandlers.modeToggle = {
    init: function (element, valueAccessor) {
        var currentValue = valueAccessor();
        if (currentValue === true) {
            $(element).attr("src", "images/latest-position.svg");
        } else {
            $(element).attr("src", "images/interval.svg");
        }
    },
    update: function (element, valueAccessor) {
        var currentValue = valueAccessor();
        if (currentValue === true) {
            $(element).attr("src", "images/latest-position.svg");
        } else {
            $(element).attr("src", "images/interval.svg");
        }
    }
};

// binding handler for the manual update button
ko.bindingHandlers.manualUpdateAvailable = {
    init: function (element, valueAccessor) {
        var currentValue = valueAccessor();
        if (currentValue === true) {
            $(element).attr("src", "images/update-map.svg");
        } else {
            $(element).attr("src", "images/update-map-disabled.svg");
        }
    },
    update: function (element, valueAccessor) {
        var currentValue = valueAccessor();
        if (currentValue === true) {
            $(element).attr("src", "images/update-map.svg");
        } else {
            $(element).attr("src", "images/update-map-disabled.svg");
        }
    }
};