/*
 * login.js
 *
 * Copyright (c) CorvusGPS.com, 2015. All rights reserved.
 */

(function () {
    "use strict";

    /**
     * Handles the app's "pause" event. This function should save the app state.
     */
    function onPause() {
        // TODO: This application has been suspended. Save application state here.
    };

    /**
     * Handles the app's "resume" event. This function should restore the app state.
     */
    function onResume() {
        // TODO: This application has been reactivated. Restore application state here.
    };

    /**
     * Handles the "backbutton" event.
     * 
     * @param {Object} e Event source.
     */
    function onBackKeyDown(e) {
        // doesn't do the default action, no way, never, ever, it's quite unpredictable
        e.preventDefault();
        window.localStorage.setItem("isCleanStartup", true);

        // instead closes the app
        navigator.app.exitApp();
    };

    /**
 * Handles the "offline" event, when an application goes offline, and the device is not connected to the Internet.
 */
    function onOffline() {
        // TODO: handle offline event
        console.log("login.js/onOffline(): Network connectivity has been lost.");
        // TODO: in case of losing the network connectivity, a message should be displayed
    }

    /**
     * Handles the "online" event, when an application goes online, and the device becomes connected to the Internet.
     */
    function onOnline() {
        // TODO: Handle the online event
        console.log("login.js/onOnline(): Network connectivity has been restored.");
        // performs re-authentication
        corvusGps.refreshLogin();

        // when the network connectivity has been restored, try to authenticate
        corvusGps.refreshLogin(function () {
            window.location.replace("index.html");
        });
    }

    /**
     * Handles the app's "deviceready" event. The Cordova specific initialization should take place here.
     */
    function onDeviceReady() {
        // Handle the Cordova pause and resume events
        document.addEventListener("pause", onPause.bind(this), false);
        document.addEventListener("resume", onResume.bind(this), false);

        // TODO: Cordova has been loaded. Perform any initialization that requires Cordova here.
        document.addEventListener("backbutton", onBackKeyDown.bind(this), false);
        document.addEventListener("offline", onOffline.bind(this), false);
        document.addEventListener("online", onOnline.bind(this), false);
        try {
            window.open = cordova.InAppBrowser.open;
        } catch (ex) {
            console.log(ex.toLocaleString());
        }
    };

    document.addEventListener("deviceready", onDeviceReady.bind(this), false);
})();

if (window.localStorage.getItem("isCleanStartup") === true) {
    // at the app startup, clears any previously stored view states
    window.localStorage.removeItem("indexViewState");
    window.localStorage.removeItem("lastMapState");
}

window.localStorage.setItem("isCleanStartup", false);
corvusGps.refreshLogin(function () {
    window.location.replace("index.html");
});
