/*
 * login/viewmodel.js
 *
 * Copyright (c) CorvusGPS.com, 2015. All rights reserved.
 */

// This is a simple *viewmodel* - JavaScript that defines the data and behavior of your UI
function LoginViewModel() {
    this.form_name = "login";
    this.email = ko.observable("");
    this.password = ko.observable("");
    this.performLogin = function () {
        if (!this.email() || !this.password()) {
            // Toast is for Android only
            showAlert("No email or password was provided.", function () { return false; }, "Login failed", "OK");
        } else {
            corvusGps.performLogin(
                "",
                $("#login_form").serialize(),
                function (data) {
                    corvusGps.persistAuthenticationData(data, $("#login_form").serialize());
                    window.location.replace("index.html");
                    return true;
                },
                function () {
                    showAlert("Wrong email or password was provided, or the network is unavailable. Please try again.", function () { return false; }, "Login failed", "OK");
                    console.error("Authentication was not successful.");
                }
            );
        }

        return false;
    };
}

// Activates knockout.js
var options = {
    attribute: "data-bind",        // default "data-sbind"
    globals: window,               // default {}
    bindings: ko.bindingHandlers,  // default ko.bindingHandlers
    noVirtualElements: false       // default true
};
ko.bindingProvider.instance = new ko.secureBindingsProvider(options);
ko.applyBindings(new LoginViewModel());