var alert_count = -1;
var message_count = -1;

var open_popup = function (page, text)
{
    $(".loader").show();
    var container = $('.popup_overlay_container');
    var popup_count = container.children().length-1;
    var random_number = Math.floor((Math.random() * 10) + 1);
    var popup = $("<div>", {"id": random_number, "class": "popup_window draggable"});
    popup.css({"margin-top": (-200+(popup_count*35))+"px", "margin-left": (-400+(popup_count*35))+"px"});
    var popup_overlay = $("<div>", { "class": "popup_overlay"});
    var popup_title_bar = $("<div>", { "class": "popup_title_bar"});
    var popup_title = $("<div>", { "class": "popup_title"});
    var popup_close_button = $("<div>", { "class": "popup_close"});
    /*var text = $(event.target).text();
    if (text == "")
        text = $(event.target).attr("title");*/
    popup_title_bar.text(text);
    popup_title_bar.append(popup_close_button);
    popup.append(popup_title_bar);
    popup.append(popup_overlay);
    popup.hide();
    container.append(popup);
    container.show();

    popup_focus(popup.children(".popup_title_bar"));

    $(popup_overlay).load(page, function(responseText, status)
    {
        if (!(responseText == "" || responseText == null) || status == "error")
        {
            var message_wrapper = $(".messages_wrapper");
            popup.show();
            convert_to_locale_date();
            bind_popups();
            bind_wizard();
            message_wrapper.scrollTop(message_wrapper.height() - $(".messages_wrapper:last-child").height());
            $(".loader").hide();

        }
    });
};

$(document).ready(function()
	{
		var jsutils = new JSUtils();

		$(function() {$( ".draggable" ).draggable({handle: ".popup_title_bar"});});

		$('.body').click (function(event)
		{
			event.stopPropagation();

			$(".alerts_window").hide();
			$(".messages_window").hide();
			$(".login_window").hide();
			$(".profile_window").hide();

		});

		$('.login_window').click (function(event)
		{
			event.stopPropagation();
		});

		$('.login_show').click (function(event)
		{
			event.preventDefault();
			event.stopPropagation();
			$(".login_window").toggle();
		});

		$('.alerts_show').click (function(event)
		{
			event.preventDefault();
			event.stopPropagation();
			$(".messages_window").hide();
			$(".profile_window").hide();
			$(".alerts_window").toggle()

		});
		$('.messages_show').click (function(event)
		{
			event.preventDefault();
			event.stopPropagation();
			$(".alerts_window").hide();
			$(".profile_window").hide();
			$(".messages_window").toggle();
		});
		$('.profile_show').click (function(event)
		{
			event.preventDefault();
			event.stopPropagation();
			$(".alerts_window").hide();
			$(".messages_window").hide();
			$(".profile_window").toggle();
		});

	});


function JSUtils()
	{

		var owner = this;
		set_login_expiration_alert();
		check_notifications();
		update_notifications();
		refresh_notification_bar();
		default_email();
		default_password();
		convert_to_locale_date();
		check_password_matching();
		bind_popups();

		function logout()
			{
				$('.login_overlay').load("./popup.php?page=login-box&borderless=true", function ()
				{
					$('.login_overlay_container').show();

					convert_to_locale_date();
					bind_popups();
					set_cookie("logged_in", "false");
					clearInterval(owner.login_expiration);
				});
			}


		function set_login_expiration_alert()
			{
				if (get_cookie("logged_in") == "true")
					{
                        console.log("loggedin" + get_cookie("logged_in"))
						if(owner.login_expiration != "undefined")
							{
								clearInterval(owner.login_expiration);
							}
						owner.login_expiration = setInterval(function ()
							{

								var time_left = (get_cookie("session_expiration") - Math.round(new Date() / 1000));
								var minutes =  Math.floor(time_left/60);
								var seconds = time_left%60;
								if (seconds < 10)
									seconds = "0" + seconds;
								if (minutes < 10)
									minutes = "0" + minutes;
								$('.session_expiration').html( minutes + ":" + seconds );
								if (time_left < 1 )
									{
                                        if (get_cookie("logged_in") == "true")
                                        logout();
									}
							}, 1000);
					}
			}

		function refresh_notification_bar()
			{
				if (get_cookie("logged_in") == "true")
					{
						if(owner.notification_refresh != "undefined")
							{
								clearInterval(owner.notification_refresh);
							}
						owner.notification_refresh = setInterval(function ()
							{
								update_notifications();
							}, 10000);
					}

			}


		function check_notifications()
	{
		if(owner.notification_check != "undefined")
			{
				clearInterval(owner.notification_check);
			}
		owner.notification_check = setInterval(function ()
		{
			var element = $('.notification_overlay');
			if (get_cookie("notification") == "true")
				{
					element.load("./popup.php?page=notification-box&borderless=true", function ()
					{
						$('.notification_overlay:hidden').show();
						clearTimeout(owner.hide_notifications);
						owner.hide_notifications = setTimeout(function(){$('.notification_overlay:visible').hide();},5000);
					});
				}
			if (element.is(":empty"))
				{
					$('.notification_overlay:visible').hide();
				}

		}, 1000);
	}

}

function convert_to_locale_date()
{
    $('.date').each(function(i, obj)
    {
        if (check_if_number(obj.innerHTML))
            obj.innerHTML = new Date(obj.innerHTML*1000).toLocaleDateString();
    });
	$('.datetime').each(function(i, obj)
	{
		if (check_if_number(obj.innerHTML))
			{
				var date = new Date(obj.innerHTML*1000);
				obj.innerHTML = date.toLocaleDateString() + " " + date.toLocaleTimeString();
			}

	});

}
function submit_enable(resultItem, message)
	{
		var submitButton = resultItem.closest("form").find(":submit");
		if ($(resultItem).html() != message)
			{
				$(resultItem).html(message);
				$(submitButton).removeAttr("disabled");
			}
	}
function submit_disable(resultItem, message)
	{
		var submitButton = resultItem.closest("form").find(":submit");
		if ($(resultItem).html() != message)
			{
				$(resultItem).html(message);
				$(submitButton).attr("disabled", "disabled");
			}

	}

function check_password_matching()
	{
		if ($(".password_repeat").length !== 0)
			{
				$(".matching").remove();
				$('.password_repeat').after("<div class='matching'></div>");
			}

		$(document).keyup(function ()
		{
			var resultItem = $('.matching');
			var repeatField = $(".password_repeat");
			var passwordField = $(".password");
			if (repeatField.length !== 0 && passwordField.length !== 0)
				{

					if (passwordField.val().length !== 0 && repeatField.val().length !== 0)
						{
							if(repeatField.val() != passwordField.val())
								{
									submit_disable(resultItem, "<div class='bool_fail' title='Passwords not matching!'></div>");
								}
							else
								{
									submit_enable(resultItem, "<div class='bool_ok'></div>");
								}
						}
					else
						{
							submit_disable(resultItem, "<div class='bool_fail' title='Cannot be blank!'></div>");
						}
				}
		});

	}

function check_availability()
	{
		var json_string = document.forms["wizard"].elements["unique_test"].value;
		console.log(json_string);
		var json = jQuery.parseJSON(json_string);
		console.log(json);
		var value;
		if(document.getElementById('check_imei'))
			value = document.getElementById('check_imei').value;
		else if (document.getElementById('check_meid'))
			value = document.getElementById('check_meid').value;
		else if (document.getElementById('check_text'))
			value = document.getElementById('check_text').value;
		var wizard_id = json.wizard_id;
		var table_name = json.table_name;
		var db_name = json.db_name;
		var resultItem = $('#available');
		$.post("./check.php", { "db_name": db_name, "wizard_id": wizard_id, "value": value, "table_name": table_name },
			function(result)
			{
				if(result == 1)
				{
					submit_disable(resultItem, "<div class='bool_fail' title='" + value + " is already registered." + "'></div> " + value + " is already registered.");
				}
				else if (result == 0)
				{
					submit_enable(resultItem, "<div class='bool_ok'></div>");
				}
			}, "text");
    }

function validate_email(email)
	{
		var resultItem = $('#available');
		$.post("./check_mail.php", { "email": email },
			function(result)
			{
				if(result != "ok")
				{
					submit_disable(resultItem, "<div class='bool_fail' title='" + result + "'></div>");
				}
				else if (result == "ok")
				{
					submit_enable(resultItem, "<div class='bool_ok'></div>");
				}
			}, "text");
	}

function get_url_param(param)
	{
		var query = window.location.search.substring(1);
		var vars = query.split("&");
		for (var i=0;i<vars.length;i++) {
			var pair = vars[i].split("=");
			if(pair[0] == param){return pair[1];}
		}
		return(false);
	}

function update_notifications()
	{
		$.getJSON("./interfaces/counters_interface.php",
			function (result)
			{
				if (result["messages"] != message_count)
					{
						message_count = result["messages"];
						if (result["messages"] != 0)
							{
								$('.m_counter').html(result["messages"]).show();
							}
						else
							{
								$('.m_counter').hide();
							}
						$('.messages_content').load("./interfaces/messages_interface.php", function ()
						{
							convert_to_locale_date();
							bind_popups();

						});
						if (get_url_param("subpage") == "messages")
							{
								popup_refresh();
							}
					}
				if (result["alerts"] != alert_count)
					{
						alert_count = result["alerts"];
						if (result["alerts"] != 0)
							{
								$('.a_counter').html(result["alerts"]).show();
							}
						else
							{
								$('.a_counter').hide();
							}
						$('.alerts_content').load("./interfaces/alerts_interface.php", function ()
						{
							convert_to_locale_date();
							bind_popups();
						});
					}

			});
	}

function set_cookie(name, value)
	{
		$.cookie(name, value, { expires: 60, path: '/' });
	}

function get_cookie(name)
	{
		return $.cookie(name);
	}

function default_email()
	{
		if (document.getElementById('bar_email') && document.getElementById('bar_email').value == '')
			{
				if (get_cookie("login_email") != null)
					document.getElementById('bar_email').value = get_cookie("login_email");
				else
					document.getElementById('bar_email').value = "E-mail";
			}
	}

function default_password()
	{
		if (document.getElementById('bar_password') && document.getElementById('bar_password').value == '' && get_cookie("login_email") == null)
			document.getElementById('bar_password').value = 'Password';
	}

function check_if_number(n)
	{
		return !isNaN(parseFloat(n)) && isFinite(n);
	}

function check_if_hexa(hex)
	{
		return (hex.search(/[0-9A-F]/gi) !== -1);
	}

function validate_imei(n)
	{
		var temp, rem, digitsum, i, summary = 0;
		for (i = 0; i < n.length; i++)
			{
				if( i % 2 == 0)
					summary += parseInt(n[i]);
				else
					{
						digitsum = 0;
						temp = parseInt(n[i])*2;
						while (temp>0)
							{
								rem = (temp % 10);
								digitsum += rem;
								temp = (temp - rem)/10;
							}
						summary += digitsum;
					}
			}
		return (summary%10 == 0)
	}

function display_centered_overlay(message)
	{
		var element = $(".overlay");
		if (element.html() != "<div class='exact_center'>" + message + "</div>")
			element.html("<div class='exact_center'>" + message + "</div>");
		element.show();
	}

function hide_overlay()
	{
		var element = $(".overlay");
		element.hide();
	}

function validate_text(form, db_name, title)
	 {
		 var x=document.forms[form][db_name].value;
		 if (x==null || x=="")
			 {
				 alert(title +" must be filled out!");
				 return false;
			 }
		 else
		 	return true;
	 }

function popup_focus(target)
	{
		var container = $('.popup_overlay_container');
		container.children(".popup_window").each(
			function ()
			{
				$(this).css({"z-index": "105"});
				$(this).css({"opacity": "0.7"});
			}
		);
		$(target).parents(".popup_window").css({"z-index": "115"});
		$(target).parents(".popup_window").css({"opacity": "1.0"});
	}

function popup_refresh()
	{
		if ($("#subject").val() == "remove_alert" || $(".messages_wrapper").val() == "remove_alert")
			update_notifications();
		if (get_cookie("logged_in") == "true")
			{
				var url = document.URL;
				if (document.URL.indexOf("?") != -1)
					url += "&popup_refresh=true";
				else
					url += "?popup_refresh=true";
				$('.content').load(url, function ()
				{
					convert_to_locale_date();
					bind_popups();
				});
			}
		else
			{
				window.location.replace("./index.php");
			}
	}
function bind_popups()
	{
		$(function() {$( ".draggable" ).draggable({handle: ".popup_title_bar"});});

		if ($(".password_repeat").length !== 0)
			{
				$(".matching").remove();
				$('.password_repeat').after("<div class='matching'></div>");
			}

		$(document).keyup(function ()
		{
			var resultItem = $('.matching');
			var repeatField = $(".password_repeat");
			var passwordField = $(".password");
			if (repeatField.length !== 0 && passwordField.length !== 0)
				{

					if (passwordField.val().length !== 0 && repeatField.val().length !== 0)
						{
							if(repeatField.val() != passwordField.val())
								{
									submit_disable(resultItem, "<div class='bool_fail' title='Passwords not matching!'></div>");
								}
							else
								{
									submit_enable(resultItem, "<div class='bool_ok'></div>");
								}
						}
					else
						{
							submit_disable(resultItem, "<div class='bool_fail' title='Cannot be blank!'></div>");
						}
				}
		});

		$("#available").remove();
		$('#check_imei').after("<div id='available'></div>");
		$('#check_email').after("<div id='available'></div>");
		var message_text = $('.message_text');
		message_text.focus(function()
		{
			if (message_text.val() == "Write the message here ...")
				message_text.val("");
		});
		message_text.blur(function()
		{
			if (message_text.val() == "")
				message_text.val("Write the message here ...");
		});
		var subject_text = $('.subject');
		subject_text.focus(function()
		{
			if (subject_text.val() == "Subject")
				subject_text.val("");
		});
		subject_text.blur(function()
		{
			if (subject_text.val() == "")
				subject_text.val("Subject");
		});

		$('.popup_title_bar').click ( function(event)
		{
			event.preventDefault();
			event.stopPropagation();
			popup_focus(event.target);
		});
		$('.popup_close, .cancel, .popup_overlay_container, .popup_overlay_background').click ( function(event)
		{
			if ($(".messages_wrapper").length !== 0)
				update_notifications();
			event.preventDefault();
			event.stopPropagation();
			popup_close(event.target);
		});

		$('.popup_overlay').click ( function(event) {
			event.stopPropagation();
		});

        $('.popup, .popup_reopen').unbind('click').click ( function(event)
        {
			event.preventDefault();
			event.stopPropagation();
			popup_close('.popup_reopen');
			$(".loader").show();
			var container = $('.popup_overlay_container');
			var popup_count = container.children().length-1;
			var page = ($(this).attr("href")).replace("index.php", "popup.php");
			var random_number = Math.floor((Math.random() * 10) + 1);
			var popup = $("<div>", {"id": random_number, "class": "popup_window draggable"});
			popup.css({"margin-top": (-200+(popup_count*35))+"px", "margin-left": (-400+(popup_count*35))+"px"});
			var popup_overlay = $("<div>", { "class": "popup_overlay"});
			var popup_title_bar = $("<div>", { "class": "popup_title_bar"});
			var popup_title = $("<div>", { "class": "popup_title"});
			var popup_close_button = $("<div>", { "class": "popup_close"});
			var text = $(event.target).text();
			if (text == "")
				text = $(event.target).attr("title");
			popup_title_bar.text(text);
			popup_title_bar.append(popup_close_button);
			popup.append(popup_title_bar);
			popup.append(popup_overlay);
			popup.hide();
			container.append(popup);
			container.show();

			popup_focus(popup.children(".popup_title_bar"));

			$(popup_overlay).load(page, function(responseText, status)
			{
				if (!(responseText == "" || responseText == null) || status == "error")
					{
						var message_wrapper = $(".messages_wrapper");
						popup.show();
						convert_to_locale_date();
						bind_popups();
						bind_wizard();
						message_wrapper.scrollTop(message_wrapper.height() - $(".messages_wrapper:last-child").height());
						$(".loader").hide();

					}
			});
        });

		$('.wizard_back').unbind('click').click ( function(event)
		{
			event.preventDefault();
			event.stopPropagation();

			$('.popup_overlay').load($(this).attr("href") + "&is_popup=true", function()
			{
				$('.popup_overlay_container').show();
				$('.popup_title').text($(event.target).text());

				convert_to_locale_date();
				bind_popups();
			});
		});

		$('.popup_form').ajaxForm(
			{
				beforeSubmit: function()
					{
                        $('.popup_form').children(":submit").first().attr("disabled", "disabled");
						$(".loader").show();
					},
				success: function()
					{
						popup_refresh();
						$(".loader").hide();
						popup_close('.popup_form');
					}
			}
			);
		$('.popup_wizard').ajaxForm(
		{
			beforeSubmit: function()
				{
					$(".loader").show();
				},
			success: function(responseText/*, statusText, xhr, $form*/)
				{
					$('.popup_overlay').html(responseText);
					$("#popup_content").find("script").each(function() {
						eval($(this).text());
					});
					convert_to_locale_date();
					bind_popups();
					bind_wizard();
					$(".loader").hide();
				}
		});
		$('.popup_pseudo_wizard').ajaxForm( function()
		{
			$('.popup_overlay').load("./index.php?page=wizard&id=" + document.getElementById("pseudo_select").value + "&step=1&is_popup=true", function()
			{
				convert_to_locale_date();
				bind_popups();
				bind_wizard();
			});
		});
		get_geoip();
		get_timezone();
    }

function bind_wizard()
	{
		var min_chars = 7;
		if (document.getElementById('check_email'))
			{
				$('#check_email').on('change keypress paste input keyup', function ()
				{
					if (document.getElementById('check_email').value.length > min_chars)
						{
							validate_email(document.getElementById('check_email').value);
							var submitButton = $('.matching').parents("form:first").children(":submit").first();
							$(submitButton).attr("disabled", "disabled");
						}
				});

			}
		if ((document.forms["wizard"]) && (document.getElementById("check_meid") || document.getElementById("check_imei")))
			{

				var value;
				var length;
				var resultItem = $('#available');

				if (document.getElementById("check_meid") || document.getElementById("check_imei"))
					submit_disable(resultItem, "<div class='bool_fail' title='You will have to fill this field with your device`s IMEI/MEID number.' ></div> You will have to fill this field with your device`s IMEI/MEID number.");
				$(document).keyup(function ()
				{
					if (document.getElementById("check_imei"))
						{
							value = document.forms["wizard"].elements["check_imei"].value;
							length = document.forms["wizard"].elements["check_imei"].value.length;
							if (!check_if_number(value))
								submit_disable(resultItem, "<div class='bool_fail' title='You should use only numbers in this step.' ></div> You should use only numbers in this step.");
							else if (length < 15)
								submit_disable(resultItem, "<div class='bool_fail' title='IMEI numbers should be 15 digits long, you have less than that.'></div> IMEI numbers should be 15 digits long, you have less than that.");
							else if (length > 15)
								submit_disable(resultItem, "<div class='bool_fail' title='IMEI numbers should be 15 digits long, you have more than that.' ></div> IMEI numbers should be 15 digits long, you have more than that.");
							else if (length == 15)
								{
									if (!validate_imei(value))
										submit_disable(resultItem, "<div class='bool_fail' title='IMEI number is invalid.'></div> IMEI number is invalid.");
									else
										check_availability();
								}
						}
					else if (document.getElementById("check_meid"))
						{
							value = document.forms["wizard"].elements["check_meid"].value;
							length = document.forms["wizard"].elements["check_meid"].value.length;
							if (!check_if_hexa(value))
								submit_disable(resultItem, "<div class='bool_fail' title='You should use only hexadecimal numbers (numbers from 0 to 9 and a, b, c, d, e, f characters in this step.' ></div> You should use only hexadecimal numbers (numbers from 0 to 9 and a, b, c, d, e, f characters in this step.");
							else if (length < 14)
								submit_disable(resultItem, "<div class='bool_fail' title='MEID numbers should be 14 digits long, you have less than that.' ></div> MEID numbers should be 14 digits long, you have less than that.");
							else if (length > 14)
								submit_disable(resultItem, "<div class='bool_fail' title='MEID numbers should be 14 digits long, you have more than that.' ></div> MEID numbers should be 14 digits long, you have more than that.");
							else if (length == 14)
								{
									check_availability();
								}
						}
					else if (document.forms["wizard"].elements[0].value.length < min_chars)
						submit_disable(resultItem, "<div class='bool_fail' title='Minimum amount of characters is 7'></div> Minimum amount of characters is 7");
					else
						check_availability();
				});
			}
	}

function popup_close(target)
	{
		var container = $('.popup_overlay_container');
		$(target).parents(".popup_window").remove();
		popup_refresh();
		if (container.children().length <= 1)
			container.hide();
		else
			{
				popup_focus(container.children(".popup_window").last().children(".popup_title_bar"));
			}
	}

function display_map_overlay(message)
	{
		var element = $(".map_overlay");
		if (element.html() != "<div class='exact_center'>" + message + "</div>")
			element.html("<div class='exact_center'>" + message + "</div>");
		element.show();
	}

function hide_map_overlay()
	{
		var element = $(".map_overlay");
		element.hide();
	}

function display_alert_overlay(message)
	{
		var element = $(".alert_overlay");
		if (element.html() != "<div class='exact_center'>" + message + "</div>")
			element.html("<div class='exact_center'>" + message + "</div>");
		element.show();
		setTimeout(function(){$(".alert_overlay").hide()},5000)
	}

function map_hide_advanced_controls()
	{
		$("#map_advanced_controls").hide();
		$("#map_show_advanced_controls").show();
	}

function map_show_advanced_controls()
	{
		$("#map_show_advanced_controls").hide();
		$("#map_advanced_controls").show();
	}

function map_hide_eventlist()
	{
		$("#map_eventlist").hide();
		$("#map_show_eventlist").show();
	}

function map_show_eventlist()
	{
		$("#map_show_eventlist").hide();
		$("#map_eventlist").show();
	}

function disable_map_submit()
	{
		var submit_button = $("#button_map_submit");
		submit_button.attr('disabled', 'disabled');
		setTimeout(function(){submit_button.removeAttr('disabled')},5000)
	}

function get_timezone()
	{
		if (document.getElementById('timezone'))
			{
				var d = new Date();
				var usertime = d.toLocaleString();

				// Some browsers / OSs provide the timezone name in their local string:
				var tzsregex = /\b(ACDT|ACST|ACT|ADT|AEDT|AEST|AFT|AKDT|AKST|AMST|AMT|ART|AST|AWDT|AWST|AZOST|AZT|BDT|BIOT|BIT|BOT|BRT|BST|BTT|CAT|CCT|CDT|CEDT|CEST|CET|CHADT|CHAST|CIST|CKT|CLST|CLT|COST|COT|CST|CT|CVT|CXT|CHST|DFT|EAST|EAT|ECT|EDT|EEDT|EEST|EET|EST|FJT|FKST|FKT|GALT|GET|GFT|GILT|GIT|GMT|GST|GYT|HADT|HAEC|HAST|HKT|HMT|HST|ICT|IDT|IRKT|IRST|IST|JST|KRAT|KST|LHST|LINT|MART|MAGT|MDT|MET|MEST|MIT|MSD|MSK|MST|MUT|MYT|NDT|NFT|NPT|NST|NT|NZDT|NZST|OMST|PDT|PETT|PHOT|PKT|PST|RET|SAMT|SAST|SBT|SCT|SGT|SLT|SST|TAHT|THA|UYST|UYT|VET|VLAT|WAT|WEDT|WEST|WET|WST|YAKT|YEKT)\b/gi;

				// In other browsers the timezone needs to be estimated based on the offset:
				var timezonenames = {"UTC+0":"GMT","UTC+1":"CET","UTC+2":"EET","UTC+3":"EEDT","UTC+3.5":"IRST","UTC+4":"MSD","UTC+4.5":"AFT","UTC+5":"PKT","UTC+5.5":"IST","UTC+6":"BST","UTC+6.5":"MST","UTC+7":"THA","UTC+8":"AWST","UTC+9":"AWDT","UTC+9.5":"ACST","UTC+10":"AEST","UTC+10.5":"ACDT","UTC+11":"AEDT","UTC+11.5":"NFT","UTC+12":"NZST","UTC-1":"AZOST","UTC-2":"GST","UTC-3":"BRT","UTC-3.5":"NST","UTC-4":"CLT","UTC-4.5":"VET","UTC-5":"EST","UTC-6":"CST","UTC-7":"MST","UTC-8":"PST","UTC-9":"AKST","UTC-9.5":"MIT","UTC-10":"HST","UTC-11":"SST","UTC-12":"BIT"};

				var timezone = usertime.match(tzsregex);
				if (timezone)
					{
						timezone = timezone[timezone.length-1];
					}
				else
					{
						var offset = -1*d.getTimezoneOffset()/60;
						offset = "GMT" + (offset >= 0 ? "+" + offset : offset);
						timezone = timezonenames[offset];
					}


				document.getElementById('timezone').value = offset;
			}
	}

function get_geoip()
	{
		if (document.getElementById('country'))
			{
				document.getElementById('country').value = geoplugin_countryName();
			}
	}



