
function MappingControls()
	{
		var owner = this;

		this.setMinMaxDate = function(element)
			{
				var val = $(element).val();
				var x = null;
				if (element == ".end")
					{
						x = $(".start").datetimepicker("getDate");
						if (x != null)
							{
								$(element).datetimepicker("option", "minDateTime", x);
								$(element).datetimepicker("option", "minDate", x);
								$(".start_text").html($('.start').val());

							}
					}
				else if (element == ".start")
					{
						x = $(".end").datetimepicker("getDate");
						if (x != null)
							{
								$(element).datetimepicker("option", "maxDateTime", x);
								$(element).datetimepicker("option", "maxDate", x);
								if (this.current() == "true")
									$.event.trigger("toggle_current");
								else
									$(".end_text").html($('.end').val());
							}
					}
				$(element).val(val);
			};


		this.init_datepickers = function()
			{
				var startInput = $('.start');
				var endInput = $('.end');
				$('.start_text, #start_calendar').click(function ()
				{
					startInput.datetimepicker('option', 'maxDateTime', new Date());
					startInput.datepicker('show');
				});
				$('.end_text, #end_calendar').click(function ()
				{
					endInput.datetimepicker('option', 'maxDateTime', new Date());
					endInput.datepicker('show');
				});

				startInput.datetimepicker({
					addSliderAccess: true,
					sliderAccessArgs: { touchonly: false },
					showOn:"button",
					numberOfMonths: 2,
					buttonText:"",
					buttonImageOnly:true,
                    buttonImage:"./elements/images/dropdown.png",
					dateFormat:"yy/mm/dd",
					timeFormat:'HH:mm:ss',
					separator: ' ',
					alwaysSetTime:true,
					hourGrid:0,
					minuteGrid:0,
					stepHour:1,
					stepMinute:1,
					//showButtonPanel:false,
					minDate:-60,
					maxDate:0,
					onSelect:function () /*selectedDateTime*/
						{
							owner.setMinMaxDate(".end");
						}
				});
				var startDate = new Date(new Date().getTime()-3600000);
				startInput.datepicker('setDate',startDate);

				this.setMinMaxDate(".end");
				endInput.datetimepicker({
					addSliderAccess: true,
					sliderAccessArgs: { touchonly: false },
					showOn:"button",
					numberOfMonths: 2,
					buttonText:"",
					buttonImageOnly:true,
					buttonImage:"./elements/images/dropdown.png",
					dateFormat:"yy/mm/dd",
					timeFormat:'HH:mm:ss',
					separator: ' ',
					alwaysSetTime:true,
					hourGrid:0,
					minuteGrid:0,
					stepHour:1,
					stepMinute:1,
					maxDate:0,
					onSelect:function () /*selectedDateTime*/
						{
							owner.setMinMaxDate(".start");
						}
				});
				var timestamp = get_url_param("timestamp");
				if (timestamp && !ignore_timestamp)
					endInput.datepicker('setDate', new Date(timestamp*1000));
				else
					endInput.datepicker('setDate', new Date());
				if (owner.single_or_multi() == "multi" && !timestamp)
					{
						endInput.datetimepicker("option", "minDateTime", startInput.datetimepicker("getDate"));
						endInput.datetimepicker("option", "minDate", startInput.datetimepicker("getDate"));
					}
				this.setMinMaxDate(".start");
				if (!timestamp || ignore_timestamp)
				$.event.trigger("toggle_current");
			};

		this.single_or_multi = function()
			{
				if(document.getElementById('switch_single_or_multi') != undefined)
					return document.getElementById('switch_single_or_multi').value;
				else return null;
			};

		this.device_or_group = function()
			{
				if(document.getElementById('switch_device_or_group') != undefined)
					return document.getElementById('switch_device_or_group').value;
				else return null;
			};

		this.current = function()
			{
				if(document.getElementById('current') != undefined)
					return document.getElementById('current').value;
				else return null;
			};

		this.load_device_or_group = function()
			{
				var focus = $("#switch_focus");
				var resultItem = document.getElementById('device_or_group');
				var routes = $('#routes');
				var last = focus.find("option[value='last']");
				var all =focus.find("option[value='all']");
				$.post("./mapping/device_or_group.php", { "device_or_group": this.device_or_group(), "selected_device": get_url_param("did"), "selected_group": get_url_param("gid")},
					function (result)
					{
						if (owner.device_or_group() == "group")
							{
								last.attr('disabled', true );
								all.attr('disabled', false);
								focus.val("all");
								routes.prop('checked', false);
								routes.prop('disabled', true);
							}
						else
							{
								last.attr('disabled', false );
								routes.prop('checked', true);
								routes.prop('disabled', false);
							}
						$(resultItem).html(result);
						owner.load_single_or_multi();
					}, "text");
			};

		this.load_single_or_multi = function()
			{
				var resultItem = document.getElementById('single_or_multi');
				var all = $("#switch_focus").find("option[value='all']");
				var routes = $('#routes');
				$.post("./mapping/timepicker.php", {"single_or_multi": this.single_or_multi() },
					function (result)
					{
						if (owner.single_or_multi() == "single")
							{
								all.attr('disabled', true );
								$("#switch_focus").val("last");
								routes.prop('checked', false);
								routes.prop('disabled', true);
							}
						else if (owner.single_or_multi() == "multi")
							{
								all.attr('disabled', false );
								$("#switch_focus").val("all");
								routes.prop('checked', true);
								routes.prop('disabled', false);
							}
						$(resultItem).html(result);
						owner.init_datepickers();

					}, "text");
			};
	}
