function EventlistGenerator()
	{
		var owner = this;

		var hasSource = false;
		var hasAddress = false;
		var hasBattery = false;
		var hasPrecision = false;
		var hasSatellite = false;

		var events = [];

		owner.insert = function(event)
			{

				if (!hasSource && event.source != undefined)
					hasSource = true;
				if (!hasAddress && !(event.address == null || event.address == undefined))
					hasAddress = true;
				if (!hasBattery && event.battery != -1)
					hasBattery = true;
				if (!hasPrecision && event.precision != -2)
					hasPrecision = true;
				if (!hasSatellite && event.satellites != -1)
					hasSatellite = true;

				events.push(event);
			};
		owner.create = function()
			{
				var units = $("#units");
				owner.eventlist = "";
				owner.eventlist_head = "<tr>";

				owner.eventlist_head += "<th>#</th><th>Name</th><th>Type</th><th>Date</th><th>Latitude</th><th>Longitude</th><th>Altitude</th><th>Speed</th>";
				if (hasSource)
					owner.eventlist_head += "<th>Source</th>";
				if (hasAddress)
					owner.eventlist_head += "<th>Address</th>";
				if (hasBattery)
					owner.eventlist_head += "<th>Battery</th>";
				if (hasPrecision)
					owner.eventlist_head += "<th>Accuracy</th>";
				if (hasSatellite)
					owner.eventlist_head += "<th>Satellites</th>";
				owner.eventlist_head += "</tr>";

				for(var i = 0; i < events.length; i++)
					{
						var event = events[i];
						var line = "";
						var speed = (units.val() == "metric")?((event.speed).toFixed(0) + " km/h"):((event.speed*0.621371192).toFixed(0) + " mph");
						var height = (units.val() == "metric")?((event.alt).toFixed(0) + " m"):((event.alt*3.2808399).toFixed(0) + " ft");
                        var type = get_event_type(event.type);
                        if (type == "SOS")
						    line += "<tr class='eventlist_item red'>";
                        else if(type == "Impact")
                            line += "<tr class='eventlist_item red'>";
                        else if (type == "Check-in")
                            line += "<tr class='eventlist_item yellow'>";
                        else if(type == "Low Battery")
                            line += "<tr class='eventlist_item yellow'>";
                        else if(type == "Speeding")
                            line += "<tr class='eventlist_item yellow'>";
                        else
                            line += (i%2)?"<tr class='eventlist_item'>":"<tr class='eventlist_item dark'>";

                        line +=
							"<td>" + (i+1) + "</td>" +
								"<td>" + jQuery.parseJSON(event.name)+ "</td>" +
								"<td>" + type + "</td>"+
								"<td>" + (new Date(event.date*1000).toLocaleString()) + "</td>" +
								"<td>" + parseFloat(event.lat).toFixed(6) + "</td>" +
								"<td>" + parseFloat(event.lng).toFixed(6)	+ "</td>" +
								"<td>" + height + "</td>" +
								"<td>" + speed + "</td>";
						if (hasSource)
							line += "<td>" + ((event.source == "cell")?"wifi/cell":event.source) + "</td>";
						if (hasAddress)
							line += "<td>" + ((event.address != null)?event.address:"n/a") + "</td>";
						if (hasBattery)
							line += "<td>" + ((event.battery != -1)?event.battery:"n/a") + "</td>";
						if (hasPrecision)
							line += "<td>" + ((event.precision != -2)?((event.precision != -1)?event.precision:"invalid"):"n/a") + "</td>";
						if (hasSatellite)
							line += "<td>" + ((event.satellites != -1)?event.satellites:"n/a") + "</td>";
						line += "</tr>";
						owner.eventlist = line + owner.eventlist;
					}
				return owner.eventlist_head + owner.eventlist;

			};
	}