function countDown() {
	var hrSpan = $('#hr');
	var minSpan = $('#min');
	var secSpan = $('#sec');

	var hr = parseFloat(hrSpan.html());
	var min = parseFloat(minSpan.html());
	var sec = parseFloat(secSpan.html());

	sec--;

	if(sec < 0) {
	  sec = 59;
	  min--;
	}

	if(min < 0) {
	  min = 59;
	  hr--;
	}

	hrSpan.html("0".substring(hr >= 10) + hr);
	minSpan.html("0".substring(min >= 10) + min);
	secSpan.html("0".substring(sec >= 10) + sec);

	if(checkZero()) {
		$('#reset_button').trigger('click');
	}
}

function startStopWatch() {
	return setInterval(countDown, 1000);
}

function stopStopWatch(timer) {
	clearInterval(timer);
}

function reset(timer) {
	stopStopWatch(timer);
	$('#hr').html("00");
	$('#min').html("00");
	$('#sec').html("00");
}

function checkZero() {
	var hr = parseFloat($('#hr').html());
	var min = parseFloat($('#min').html());
	var sec = parseFloat($('#sec').html());

	if(sec == 0 && min == 0 && hr == 0) {
		return true;
	} else {
		false;
	}
}

$(function() {
	var snd = new Audio("media/22627__corsica-s__timer.wav");

	var timer = null;
	var isStarted = false;

	$('#start_button').click(function() {

		if(checkZero()) {
			return;
		}
		
		if(!isStarted) {
			timer = startStopWatch();
			$("#start_button").prev('span').find('.ui-btn-text').text('Pause');
			isStarted = true;
		} else {
			stopStopWatch(timer);
			$("#start_button").prev('span').find('.ui-btn-text').text('Resume');
			isStarted = false;
		}		
	});

	$('#reset_button').click(function() {
		reset(timer);
		timer = null;
		$("#start_button").prev('span').find('.ui-btn-text').text('Start');
		isStarted = false;
		snd.play();
	});

	$('#action_clear').click(function() {
		reset(timer);
		timer = null;
		$("#start_button").prev('span').find('.ui-btn-text').text('Start');
		isStarted = false;
	});

	$('#submit_time').click(function() {
		if(timer != null) {
			reset(timer);
			timer = null;
			$("#start_button").prev('span').find('.ui-btn-text').text('Start');
			isStarted = false;
		}

		var hr = $('#hr_input').val();
		var min = $('#min_input').val();
		var sec = $('#sec_input').val();

		hr = (hr == "") ? "0" : hr;
		min = (min == "") ? "0" : min;
		sec = (sec == "") ? "0" : sec;

		$('#hr').html("0".substring(hr >= 10) + hr);
		$('#min').html("0".substring(min >= 10) + min);
		$('#sec').html("0".substring(sec >= 10) + sec);

		$('.ui-dialog').dialog('close');
	});

	$('#clear_time_input').click(function() {
		$('#hr_input').val("");
		$('#min_input').val("");
		$('#sec_input').val("");
	});
});