(function(global) {
    "use strict;"

	/* ====================================
	 *	定数
	 * ==================================== */

	const KEY_PANEL_CNT = "panel_cnt";
	const KEY_COUNT_1   = "count_1";
	const KEY_COUNT_2   = "count_2";
	const KEY_COUNT_3   = "count_3";
	const KEY_COUNT_4   = "count_4";
	const KEY_NAME_1    = "name_1";
	const KEY_NAME_2    = "name_2";
	const KEY_NAME_3    = "name_3";
	const KEY_NAME_4    = "name_4";
	const KEY_COLOR_1   = "color_1";
	const KEY_COLOR_2   = "color_2";
	const KEY_COLOR_3   = "color_3";
	const KEY_COLOR_4   = "color_4";

	const PREFIX_BLOCK     = "block_";
	const PREFIX_VALUE     = "counter_value_";
	const PREFIX_NAME      = "counter_name_";
	const PREFIX_MENU      = "menu_color_";
	const PREFIX_KEY_COUNT = "count_";
	const PREFIX_KEY_NAME  = "name_";
	const PREFIX_KEY_COLOR = "color_";

	const DEFAULT_VALUE = "0";
	const DEFAULT_NAME  = "COUNT";

	const MSG_CONFIRM_RESET  = "Are you sure you want to remove this counter?";

	const IMG_ICON_MINUS = "img/icon_minus.svg";
	const IMG_ICON_RESET = "img/icon_reset.svg";

	const COLOR_1 = "#5f9b0a";
	const COLOR_2 = "#00aacc";
	const COLOR_3 = "#ff9500";
	const COLOR_4 = "#b90000";
	const COLOR_5 = "#AB47BC";
	const COLOR_6 = "#ff4e00";
	const COLOR_7 = "#00539f";
	const COLOR_8 = "#5D4037";
	const COLOR_9 = "#4d4e53";

	const COLOR_LIST = [
		COLOR_1,
		COLOR_2,
		COLOR_3,
		COLOR_4,
		COLOR_5,
		COLOR_6,
		COLOR_7,
		COLOR_8,
		COLOR_9
	];

	const MAX_COUNTER_COUNT = 4;
	const MIN_VALUE         = 0;
	const MAX_VALUE         = 999999;
	const MAX_CHAR          = 6;


	/* ====================================
	 *	変数
	 * ==================================== */

	var btnEdit;
	var btnAdd;
	var btnDone; 
	var btnControl;

	var editMode = false; 
	var panelCnt = 1;


	/* ====================================
	 *	イベントハンドラ
	 * ==================================== */

	/**
	 * レイヤー クリックイベントハンドラ
	 *　@param	element	対象要素
	 *　@param	num		番号
	 */
	function divLayerOnClick(event, num) {
		event.stopPropagation();

		// 編集モードではない場合、無視
		if(editMode) {
			return;
		}

		countUp(PREFIX_VALUE + num);
	}

	/**
	 * 操作ボタン クリックイベントハンドラ
	 * @param	event	イベント
	 *　@param	num		番号
	 */
	function btnControlOnClick(event, num) {
		event.stopPropagation();

		// 編集モードの場合、リセット
		// 編集モードではない場合、カウントダウン
		if(editMode) {
			resetCount(PREFIX_VALUE + num);
		} else {
			countDown(PREFIX_VALUE + num);
		}
	}
	
	/**
	 * 削除ボタン クリックイベントハンドラ
	 * @param	event	イベント
	 *　@param	num		番号
	 */
	function btnDeleteOnClick(event, num) {
		event.stopPropagation();

		var wrap = document.getElementById("wrap");

		if(confirm(MSG_CONFIRM_RESET)) {
			saveData();

			deleteCounterData(num);

			panelCnt--;
			savePanelCnt();

			// editMode = false;

			changeMode();
			changeAddButtonState();
			changeHeader();
			redraw();
		}
	}

	/**
	 * カウンター情報削除
	 * @param	event	イベント
	 *　@param	num		番号
	 */
	function deleteCounterData(num) {
		var no;
		var tmpCount;
		var tmpName;
		var tmpColor;
		var childNo = num % 10;
		var groupNo = parseInt(num / 10);

		for(no = childNo; no <= groupNo; no++) {
			if(no < groupNo) {
				tmpCount = localStorage.getItem(PREFIX_KEY_COUNT + (no + 1));
				tmpName  = localStorage.getItem(PREFIX_KEY_NAME + (no + 1));
				tmpColor = localStorage.getItem(PREFIX_KEY_COLOR + (no + 1));

				localStorage.setItem(PREFIX_KEY_COUNT + no, tmpCount);
				localStorage.setItem(PREFIX_KEY_NAME + no,  tmpName);
				localStorage.setItem(PREFIX_KEY_COLOR + no, tmpColor);
			} else {
				localStorage.setItem(PREFIX_KEY_COUNT + no, DEFAULT_VALUE);
				localStorage.setItem(PREFIX_KEY_NAME + no,  DEFAULT_NAME);
				localStorage.setItem(PREFIX_KEY_COLOR + no, COLOR_1);
			}
		}
	}


	/**
	 * メニュー クリックイベントハンドラ
	 * @param	event	イベント
	 */
	function menuColorOnClick(event) {
		event.stopPropagation();
	}

	/**
	 * 閉じるボタン クリックイベントハンドラ
	 * @param	event	イベント
	 *　@param	num		番号
	 */
	function btnCloseOnClick(event, num) {
		event.stopPropagation();

		document.getElementById(PREFIX_MENU + num).style.display = "none";
	}

	/**
	 * 色ボタン クリックイベントハンドラ
	 * @param	event	イベント
	 *　@param	num		番号
	 *　@param	color	色情報
	 */
	function btnChooseColorOnClick(event, num, color) {
		event.stopPropagation();

		document.getElementById(PREFIX_BLOCK + num).style.backgroundColor = color;

		saveColor(num, color);

		document.getElementById(PREFIX_MENU + num).style.display = "none";
	}

	/**
	 * 色ボタン クリックイベントハンドラ
	 * @param	event	イベント
	 *　@param	num		番号
	 */
	function btnColorOnClick(event, num) {
		event.stopPropagation();

		document.getElementById(PREFIX_MENU + num).style.display = "block";
	}

	/**
	 * カウンター追加ボタン クリックイベントハンドラ
	 * @param	event	イベント
	 */
	function btnAddOnClick(event) {
		event.stopPropagation();

		var wrap = document.getElementById("wrap");

		saveData();

		panelCnt++;
		
		switch(panelCnt) {
			case 2:
				localStorage.setItem(PREFIX_KEY_COLOR + 2, getUnuseColor(2));
				break;

			case 3:
				localStorage.setItem(PREFIX_KEY_COLOR + 3, getUnuseColor(3));
				break;

			case 4:
				localStorage.setItem(PREFIX_KEY_COLOR + 4, getUnuseColor(4));
				break;
		}

		wrap.scrollLeft += window.innerWidth;

		changeAddButtonState();
		redraw();
	}

	/**
	 * 編集ボタン クリックイベントハンドラ
	 * @param	event	イベント
	 */
	function btnEditOnClick(event) {
		event.stopPropagation();

		editMode = true;

		changeHeader();
		changeMode();
	}

	/**
	 * 完了ボタン クリックイベントハンドラ
	 * @param	event	イベント
	 */
	function btnDoneOnClick(event) {
		event.stopPropagation();

		editMode = false;

		changeHeader();
		changeMode();
	}

	/**
	 * 値テキストボックス フォーカスアウトイベントハンドラ
	 * @param	num	番号
	 */
	function txiValueOnBlur(num) {
		var value  = document.getElementById(PREFIX_VALUE　+ num).value;
		var ary;

		// 空文字またはカンマが入力された場合、ゼロを設定
		if(value.length == 0) {
			value = "0";
		}

		ary = value.split('.');
		if(ary.length > 1) {
			value = ary.join('');
		}

		// 最大入力数を超えている場合、
		if (value.length > MAX_CHAR) {
			value = value.splice(0,　MAX_CHAR); 
		}

		document.getElementById(PREFIX_VALUE　 + num).value = parseInt(value);
	}

	/**
	 * 表示変更イベントハンドラ
	 */
	function onVisibilityChange() {
		saveData();
		savePanelCnt();
	}


	/* ====================================
	 *	カウンター操作
	 * ==================================== */

	/**
	 * カウントアップ
	 *　@param	id	ID
	 */
	function countUp(id) {
		var element = document.getElementById(id);
		var value 　 = parseInt(element.value);

		if(value == MAX_VALUE) {
			return;
		}

		value += 1;

		element.value = value;
	}

	/**
	 * カウントダウン
	 *　@param	id	ID
	 */
	function countDown(id) {
		var element = document.getElementById(id);
		var value   = parseInt(element.value);

		if(value == MIN_VALUE) {
			return;
		}

		value -= 1;

		element.value = value;
	}

	/**
	 * カウントリセット
	 *　@param	id	ID
	 */
	function resetCount(id) {
		var element = document.getElementById(id);

		element.value = 0;
	}


	/* ====================================
	 *	その他
	 * ==================================== */

	/**
	 * 番号取得
	 *　@param	element	対象要素
	 * @return		番号
	 */
	 function getNum(element) {
		var ary = element.id.split("_");
		var num = ary[ary.length - 1];

	 	return num;
	 }

	/**
	 * 全イベントリスナー登録
	 */
	function setAllEventListener() {
		setEventListener(11);

		setEventListener(21);
		setEventListener(22);

		setEventListener(31);
		setEventListener(32);
		setEventListener(33);

		setEventListener(41);
		setEventListener(42);
		setEventListener(43);
		setEventListener(44);
	}

	/**
	 * イベントリスナー登録
	 * @param	num	番号
	 */
	function setEventListener(num) {
		var divLayer   = document.getElementById("layer_" + num);
		var btnControl = document.getElementById("btn_control_" + num);
		var btnColor   = document.getElementById("btn_color_" + num);
		var btnDelete  = document.getElementById("btn_delete_" + num);
		var menuColor  = document.getElementById("menu_color_" + num);
		var btnClose   = document.getElementById("btn_close_" + num);
		var btnColor1  = document.getElementById("btn_color_1_" + num);
		var btnColor2  = document.getElementById("btn_color_2_" + num);
		var btnColor3  = document.getElementById("btn_color_3_" + num);
		var btnColor4  = document.getElementById("btn_color_4_" + num);
		var btnColor5  = document.getElementById("btn_color_5_" + num);
		var btnColor6  = document.getElementById("btn_color_6_" + num);
		var btnColor7  = document.getElementById("btn_color_7_" + num);
		var btnColor8  = document.getElementById("btn_color_8_" + num);
		var btnColor9  = document.getElementById("btn_color_9_" + num);
		var txiValue   = document.getElementById("counter_value_" + num);

		divLayer.onclick   = function(evt) { divLayerOnClick(evt, num) };
		btnControl.onclick = function(evt) { btnControlOnClick(evt, num) };
		btnColor.onclick   = function(evt) { btnColorOnClick(evt, num) };
		btnDelete.onclick  = function(evt) { btnDeleteOnClick(evt, num) };
		menuColor.onclick  = function(evt) { menuColorOnClick(evt) };
		btnClose.onclick 　 = function(evt) { btnCloseOnClick(evt, num) };
		btnColor1.onclick 　= function(evt) { btnChooseColorOnClick(evt, num, COLOR_1) };
		btnColor2.onclick 　= function(evt) { btnChooseColorOnClick(evt, num, COLOR_2) };
		btnColor3.onclick 　= function(evt) { btnChooseColorOnClick(evt, num, COLOR_3) };
		btnColor4.onclick 　= function(evt) { btnChooseColorOnClick(evt, num, COLOR_4) };
		btnColor5.onclick 　= function(evt) { btnChooseColorOnClick(evt, num, COLOR_5) };
		btnColor6.onclick 　= function(evt) { btnChooseColorOnClick(evt, num, COLOR_6) };
		btnColor7.onclick 　= function(evt) { btnChooseColorOnClick(evt, num, COLOR_7) };
		btnColor8.onclick 　= function(evt) { btnChooseColorOnClick(evt, num, COLOR_8) };
		btnColor9.onclick 　= function(evt) { btnChooseColorOnClick(evt, num, COLOR_9) };

		txiValue.onblur   　= function(evt) { txiValueOnBlur(num) };
	}

	/**
	 * 初期化
	 */
	function init() {
		window.addEventListener("visibilitychange", function() { onVisibilityChange() });

		btnEdit = document.getElementById("btn_edit");
		btnAdd  = document.getElementById("btn_add");
		btnDone = document.getElementById("btn_done");

		btnEdit.onclick  = function(evt) { btnEditOnClick(evt) };
		btnAdd.onclick   = function(evt) { btnAddOnClick(evt) };
		btnDone.onclick  = function(evt) { btnDoneOnClick(evt) };

		initStorage();

		setAllEventListener();
	}

	/**
	 * ストレージ初期化
	 */
	function initStorage() {
		if(localStorage.getItem(KEY_PANEL_CNT) == null) {
			localStorage.setItem(KEY_PANEL_CNT, 1);
		}

		if(localStorage.getItem(KEY_COUNT_1) == null) {
			localStorage.setItem(KEY_COUNT_1, DEFAULT_VALUE);
		}
		
		if(localStorage.getItem(KEY_COUNT_2) == null) {
			localStorage.setItem(KEY_COUNT_2, DEFAULT_VALUE);
		}
		
		if(localStorage.getItem(KEY_COUNT_3) == null) {
			localStorage.setItem(KEY_COUNT_3, DEFAULT_VALUE);
		}
		
		if(localStorage.getItem(KEY_COUNT_4) == null) {
			localStorage.setItem(KEY_COUNT_4, DEFAULT_VALUE);
		}

		if(localStorage.getItem(KEY_NAME_1) == null) {
			localStorage.setItem(KEY_NAME_1, DEFAULT_NAME);
		}
		
		if(localStorage.getItem(KEY_NAME_2) == null) {
			localStorage.setItem(KEY_NAME_2, DEFAULT_NAME);
		}
		
		if(localStorage.getItem(KEY_NAME_3) == null) {
			localStorage.setItem(KEY_NAME_3, DEFAULT_NAME);
		}
		
		if(localStorage.getItem(KEY_NAME_4) == null) {
			localStorage.setItem(KEY_NAME_4, DEFAULT_NAME);
		}

		if(localStorage.getItem(KEY_COLOR_1) == null) {
			localStorage.setItem(KEY_COLOR_1, COLOR_1);
		}
		
		if(localStorage.getItem(KEY_COLOR_2) == null) {
			localStorage.setItem(KEY_COLOR_2, COLOR_2);
		}
		
		if(localStorage.getItem(KEY_COLOR_3) == null) {
			localStorage.setItem(KEY_COLOR_3, COLOR_3);
		}
		
		if(localStorage.getItem(KEY_COLOR_4) == null) {
			localStorage.setItem(KEY_COLOR_4, COLOR_4);
		}
	}

	/**
	 * パネル数読込み
	 */
	function loadPanelCnt() {
		panelCnt = parseInt(localStorage.getItem(KEY_PANEL_CNT));

		changeAddButtonState();
	}



	/* ====================================
	 *	更新処理
	 * ==================================== */

	/**
	 * 再描画
	 */
	function redraw() {
		switch(panelCnt) {
			case 1:
				redrawPanel1();
				break;

			case 2:
				redrawPanel2();
				break;

			case 3:
				redrawPanel3();
				break;

			case 4:
				redrawPanel4();
				break;
		}
	}

	function redrawPanel1() {
		var wrap = document.getElementById("wrap");
		var count11 = document.getElementById("counter_value_11");
		var name11  = document.getElementById("counter_name_11");
		var block11 = document.getElementById("block_11");

		count11.value = localStorage.getItem(PREFIX_KEY_COUNT + 1);
		name11.value  = localStorage.getItem(PREFIX_KEY_NAME + 1);
		block11.style.backgroundColor = localStorage.getItem(PREFIX_KEY_COLOR + 1);

		wrap.scrollLeft = 0;
	}

	function redrawPanel2() {
		var wrap = document.getElementById("wrap");
		var count21 = document.getElementById("counter_value_21");
		var count22 = document.getElementById("counter_value_22");
		var name21  = document.getElementById("counter_name_21");
		var name22  = document.getElementById("counter_name_22");
		var block21 = document.getElementById("block_21");
		var block22 = document.getElementById("block_22");

		count21.value = localStorage.getItem(PREFIX_KEY_COUNT + 1);
		count22.value = localStorage.getItem(PREFIX_KEY_COUNT + 2);
		name21.value  = localStorage.getItem(PREFIX_KEY_NAME + 1);
		name22.value  = localStorage.getItem(PREFIX_KEY_NAME + 2);
		block21.style.backgroundColor = localStorage.getItem(PREFIX_KEY_COLOR + 1);
		block22.style.backgroundColor = localStorage.getItem(PREFIX_KEY_COLOR + 2);

		wrap.scrollLeft = window.innerWidth;
	}

	function redrawPanel3() {
		var wrap = document.getElementById("wrap");
		var count31 = document.getElementById("counter_value_31");
		var count32 = document.getElementById("counter_value_32");
		var count33 = document.getElementById("counter_value_33");
		var name31  = document.getElementById("counter_name_31");
		var name32  = document.getElementById("counter_name_32");
		var name33  = document.getElementById("counter_name_33");
		var block31 = document.getElementById("block_31");
		var block32 = document.getElementById("block_32");
		var block33 = document.getElementById("block_33");

		count31.value = localStorage.getItem(PREFIX_KEY_COUNT + 1);
		count32.value = localStorage.getItem(PREFIX_KEY_COUNT + 2);
		count33.value = localStorage.getItem(PREFIX_KEY_COUNT + 3);
		name31.value  = localStorage.getItem(PREFIX_KEY_NAME + 1);
		name32.value  = localStorage.getItem(PREFIX_KEY_NAME + 2);
		name33.value  = localStorage.getItem(PREFIX_KEY_NAME + 3);
		block31.style.backgroundColor = localStorage.getItem(PREFIX_KEY_COLOR + 1);
		block32.style.backgroundColor = localStorage.getItem(PREFIX_KEY_COLOR + 2);
		block33.style.backgroundColor = localStorage.getItem(PREFIX_KEY_COLOR + 3);

		wrap.scrollLeft = window.innerWidth * 2;
	}

	function redrawPanel4() {
		var wrap = document.getElementById("wrap");
		var count41 = document.getElementById("counter_value_41");
		var count42 = document.getElementById("counter_value_42");
		var count43 = document.getElementById("counter_value_43");
		var count44 = document.getElementById("counter_value_44");
		var name41  = document.getElementById("counter_name_41");
		var name42  = document.getElementById("counter_name_42");
		var name43  = document.getElementById("counter_name_43");
		var name44  = document.getElementById("counter_name_44");
		var block41 = document.getElementById("block_41");
		var block42 = document.getElementById("block_42");
		var block43 = document.getElementById("block_43");
		var block44 = document.getElementById("block_44");

		count41.value = localStorage.getItem(PREFIX_KEY_COUNT + 1);
		count42.value = localStorage.getItem(PREFIX_KEY_COUNT + 2);
		count43.value = localStorage.getItem(PREFIX_KEY_COUNT + 3);
		count44.value = localStorage.getItem(PREFIX_KEY_COUNT + 4);
		name41.value  = localStorage.getItem(PREFIX_KEY_NAME + 1);
		name42.value  = localStorage.getItem(PREFIX_KEY_NAME + 2);
		name43.value  = localStorage.getItem(PREFIX_KEY_NAME + 3);
		name44.value  = localStorage.getItem(PREFIX_KEY_NAME + 4);
		block41.style.backgroundColor = localStorage.getItem(PREFIX_KEY_COLOR + 1);
		block42.style.backgroundColor = localStorage.getItem(PREFIX_KEY_COLOR + 2);
		block43.style.backgroundColor = localStorage.getItem(PREFIX_KEY_COLOR + 3);
		block44.style.backgroundColor = localStorage.getItem(PREFIX_KEY_COLOR + 4);

		wrap.scrollLeft = window.innerWidth * 3;
	}

	/**
	 * モード更新
	 */
	function changeMode() {
		var imgName;
		var visibilityState;
		var displayState;

		if(editMode) {
			imgName         = IMG_ICON_RESET;
			visibilityState = "visible";
			displayState    = "none";
		} else {
			imgName         = IMG_ICON_MINUS;
			visibilityState = "hidden";
			displayState    = "block";
		}

		changeMode1(imgName, visibilityState, displayState);
		changeMode2(imgName, visibilityState, displayState);
		changeMode3(imgName, visibilityState, displayState);
		changeMode4(imgName, visibilityState, displayState);

		document.getElementById(PREFIX_MENU + 11).style.display = "none";
		document.getElementById(PREFIX_MENU + 21).style.display = "none";
		document.getElementById(PREFIX_MENU + 22).style.display = "none";
		document.getElementById(PREFIX_MENU + 31).style.display = "none";
		document.getElementById(PREFIX_MENU + 32).style.display = "none";
		document.getElementById(PREFIX_MENU + 33).style.display = "none";
		document.getElementById(PREFIX_MENU + 41).style.display = "none";
		document.getElementById(PREFIX_MENU + 42).style.display = "none";
		document.getElementById(PREFIX_MENU + 43).style.display = "none";
		document.getElementById(PREFIX_MENU + 44).style.display = "none";
	}

	function changeMode1(imgName, visibilityState, displayState) {
		document.getElementById("layer_11").style.display        = displayState;
		document.getElementById("btn_control_icon_11").src       = imgName;
		document.getElementById("btn_color_11").style.visibility = visibilityState;	
	}

	function changeMode2(imgName, visibilityState, displayState) {
		document.getElementById("layer_21").style.display         = displayState;
		document.getElementById("layer_22").style.display         = displayState;

		document.getElementById("btn_control_icon_21").src        = imgName;
		document.getElementById("btn_control_icon_22").src        = imgName;

		document.getElementById("btn_color_21").style.visibility  = visibilityState;
		document.getElementById("btn_color_22").style.visibility  = visibilityState;

		document.getElementById("btn_delete_21").style.visibility = visibilityState;
		document.getElementById("btn_delete_22").style.visibility = visibilityState;
	}

	function changeMode3(imgName, visibilityState, displayState) {
		document.getElementById("layer_31").style.display         = displayState;
		document.getElementById("layer_32").style.display         = displayState;
		document.getElementById("layer_33").style.display         = displayState;

		document.getElementById("btn_control_icon_31").src        = imgName;
		document.getElementById("btn_control_icon_32").src        = imgName;
		document.getElementById("btn_control_icon_33").src        = imgName;

		document.getElementById("btn_color_31").style.visibility  = visibilityState;
		document.getElementById("btn_color_32").style.visibility  = visibilityState;
		document.getElementById("btn_color_33").style.visibility  = visibilityState;

		document.getElementById("btn_delete_31").style.visibility = visibilityState;
		document.getElementById("btn_delete_32").style.visibility = visibilityState;
		document.getElementById("btn_delete_33").style.visibility = visibilityState;
	}

	function changeMode4(imgName, visibilityState, displayState) {
		document.getElementById("layer_41").style.display         = displayState;
		document.getElementById("layer_42").style.display         = displayState;
		document.getElementById("layer_43").style.display         = displayState;
		document.getElementById("layer_44").style.display         = displayState;

		document.getElementById("btn_control_icon_41").src        = imgName;
		document.getElementById("btn_control_icon_42").src        = imgName;
		document.getElementById("btn_control_icon_43").src        = imgName;
		document.getElementById("btn_control_icon_44").src        = imgName;

		document.getElementById("btn_color_41").style.visibility  = visibilityState;
		document.getElementById("btn_color_42").style.visibility  = visibilityState;
		document.getElementById("btn_color_43").style.visibility  = visibilityState;
		document.getElementById("btn_color_44").style.visibility  = visibilityState;

		document.getElementById("btn_delete_41").style.visibility = visibilityState;
		document.getElementById("btn_delete_42").style.visibility = visibilityState;
		document.getElementById("btn_delete_43").style.visibility = visibilityState;
		document.getElementById("btn_delete_44").style.visibility = visibilityState;
	}

	/**
	 * ヘッダー更新
	 */
	function changeHeader() {
		if(editMode) {
			btnAdd.style.display  = "none";
			btnEdit.style.display = "none";
			btnDone.style.display = "block";
		} else {
			btnAdd.style.display  = "block";
			btnEdit.style.display = "block";
			btnDone.style.display = "none";
		}
	}

	/**
	 * 追加ボタン状態更新
	 */
	function changeAddButtonState() {
		// パネル数が最大の場合、追加ボタンは非表示
		if(panelCnt == MAX_COUNTER_COUNT) {
			btnAdd.style.visibility = "hidden";
		} else {
			btnAdd.style.visibility = "visible";
		}
	}

	/**
	 * 未使用色取得
	 * @param	groupNo	番号
	 */
	function getUnuseColor(groupNo) {
		var useList = [];
		var list = [];
		var i;
		var j;
		var exists;

		for(i = 0; i < groupNo; i++) {
			useList.push(localStorage.getItem(PREFIX_KEY_COLOR + (i + 1)));
		}

		for (i = 0; i < COLOR_LIST.length; i++) {
			exists = false;

			for (j = 0; j < useList.length; j++) {
				if(COLOR_LIST[i] == useList[j]) {
					exists = true;
					break;
				}
			}

			if(!exists) {
				list.push(COLOR_LIST[i]);
			}
		}

		return list[Math.floor( Math.random() * list.length)];
	}


	/* ====================================
	 *	データセーブ
	 * ==================================== */

	/**
	 * 情報保存
	 */
	function saveData() {
		switch(panelCnt) {
			case 1:
				saveData1();
				break;

			case 2:
				saveData2();
				break;

			case 3:
				saveData3();
				break;

			case 4:
				saveData4();
				break;
		}
	}

	function saveData1() {
		localStorage.setItem(PREFIX_KEY_COUNT + 1, document.getElementById("counter_value_11").value);
		localStorage.setItem(PREFIX_KEY_COUNT + 2, DEFAULT_VALUE);
		localStorage.setItem(PREFIX_KEY_COUNT + 3, DEFAULT_VALUE);
		localStorage.setItem(PREFIX_KEY_COUNT + 4, DEFAULT_VALUE);

		localStorage.setItem(PREFIX_KEY_NAME + 1, document.getElementById("counter_name_11").value);
		localStorage.setItem(PREFIX_KEY_NAME + 2, DEFAULT_NAME);
		localStorage.setItem(PREFIX_KEY_NAME + 3, DEFAULT_NAME);
		localStorage.setItem(PREFIX_KEY_NAME + 4, DEFAULT_NAME);
	}

	function saveData2() {
		localStorage.setItem(PREFIX_KEY_COUNT + 1, document.getElementById("counter_value_21").value);
		localStorage.setItem(PREFIX_KEY_COUNT + 2, document.getElementById("counter_value_22").value);
		localStorage.setItem(PREFIX_KEY_COUNT + 3, DEFAULT_VALUE);
		localStorage.setItem(PREFIX_KEY_COUNT + 4, DEFAULT_VALUE);

		localStorage.setItem(PREFIX_KEY_NAME + 1, document.getElementById("counter_name_21").value);
		localStorage.setItem(PREFIX_KEY_NAME + 2, document.getElementById("counter_name_22").value);
		localStorage.setItem(PREFIX_KEY_NAME + 3, DEFAULT_NAME);
		localStorage.setItem(PREFIX_KEY_NAME + 4, DEFAULT_NAME);
	}

	function saveData3() {
		localStorage.setItem(PREFIX_KEY_COUNT + 1, document.getElementById("counter_value_31").value);
		localStorage.setItem(PREFIX_KEY_COUNT + 2, document.getElementById("counter_value_32").value);
		localStorage.setItem(PREFIX_KEY_COUNT + 3, document.getElementById("counter_value_33").value);
		localStorage.setItem(PREFIX_KEY_COUNT + 4, DEFAULT_VALUE);

		localStorage.setItem(PREFIX_KEY_NAME + 1, document.getElementById("counter_name_31").value);
		localStorage.setItem(PREFIX_KEY_NAME + 2, document.getElementById("counter_name_32").value);
		localStorage.setItem(PREFIX_KEY_NAME + 3, document.getElementById("counter_name_33").value);
		localStorage.setItem(PREFIX_KEY_NAME + 4, DEFAULT_NAME);
	}

	function saveData4() {
		localStorage.setItem(PREFIX_KEY_COUNT + 1, document.getElementById("counter_value_41").value);
		localStorage.setItem(PREFIX_KEY_COUNT + 2, document.getElementById("counter_value_42").value);
		localStorage.setItem(PREFIX_KEY_COUNT + 3, document.getElementById("counter_value_43").value);
		localStorage.setItem(PREFIX_KEY_COUNT + 4, document.getElementById("counter_value_44").value);

		localStorage.setItem(PREFIX_KEY_NAME + 1, document.getElementById("counter_name_41").value);
		localStorage.setItem(PREFIX_KEY_NAME + 2, document.getElementById("counter_name_42").value);
		localStorage.setItem(PREFIX_KEY_NAME + 3, document.getElementById("counter_name_43").value);
		localStorage.setItem(PREFIX_KEY_NAME + 4, document.getElementById("counter_name_44").value);
	}

	/**
	 * 色情報保存
	 * @param	number	番号
	 * @param	color 	色情報
	 */
	function saveColor(num, color) {
		localStorage.setItem(PREFIX_KEY_COLOR + (num % 10), color);
	}

	/**
	 * 色情報保存
	 * @param	number	番号
	 * @param	color 	色情報
	 */
	function savePanelCnt() {
		localStorage.setItem(KEY_PANEL_CNT, panelCnt);
	}


	/* ====================================
	 *	起動処理
	 * ==================================== */

	window.onload = function()　{
		init();

		loadPanelCnt();

		redraw();
	}
})((this || 0).self || global);
