
var lictimer;

function touchScroll(id){
    'use strict';
    if(isTouchDevice()){ //if touch events exist...
        var el=document.getElementById(id);
        var scrollStartPos=0;

        el.addEventListener("touchstart", function(event) {
            scrollStartPos=this.scrollTop+event.touches[0].pageY;
            event.preventDefault();
        },false);

        el.addEventListener("touchmove", function(event) {
            this.scrollTop=scrollStartPos-event.touches[0].pageY;
            event.preventDefault();
        },false);
    }
}

function isTouchDevice(){
    'use strict';
    try{
        document.createEvent("TouchEvent");
        return true;
    }catch(e){
        return false;
    }
}
function onclickInfoBtn() {
    'use strict';
    var lpage = document.getElementById("licensepage");
    var hpage = document.getElementById("introPage");

    /* display the license page, hide intro-page*/
    hpage.style.display = "none";
    lpage.style.display = "block";
}

function onclickLicBack() {
    'use strict';
    var lpage = document.getElementById("licensepage");
    var hpage = document.getElementById("introPage");
    hpage.style.display = "block";
    lpage.style.display = "none";
    if (lictimer) {
        clearInterval(lictimer);
        lictimer = null;
    }
}

function loadLicenseTxt() {
    'use strict';
    $.get('README.txt', function (data) {
        var divLicense = document.getElementById("licensetext");
        divLicense.innerText = data;
    });
}