/*jslint browser:true, devel:true, white:true, vars:true, eqeq:true, ass:true */
/*jshint eqeqeq:false */
/*global $, intel, phoneCheck, Media */

/*
* Copyright (c) 2012, Intel Corporation. All rights reserved.
*
* Please see http://software.intel.com/html5/license/samples 
* and the included README.md file for license terms and conditions.
*
* This program is licensed under the terms and conditions of the 
* Apache License, version 2.0.  The full text of the Apache License is at
* http://www.apache.org/licenses/LICENSE-2.0
*
*/

function gamesound(id, loop) {
    'use strict';
    var me = this;
    this.id = id;
    this.enable = false;
    this.infocus = true;
    this.checkPosTimer;
    this.mediaobj = null;

    if (window.device) // if phonegap is used: 
    {
        if (phoneCheck.android) { // android
            this.mediaobj = new Media("/android_asset/www/audiowav/" + id + ".wav", this.mediaCallSuccess, this.mediaCallError);
        }
    } else {
        this.mediaobj = document.getElementById(id);
    }

    // Media() success callback
    this.mediaCallSuccess = function onMediaCallSuccess() { console.log("new Media() succeeded"); }
    // Media() error callback
    this.mediaCallError = function onMediaCallError(error) {
        console.log("@@@@@@@@@@new Media() failed.");
    }

    this.loop = (loop == undefined) ? false : loop;
    this.focus = function () {
        if (!me.infocus) {
            me.infocus = true;
            if (me.enable && me.loop && me.mediaobj) {
                me.mediaobj.play();
            }
        }
    };
    this.blur = function () {
        if (me.infocus) {
            me.infocus = false;
            if (me.enable && me.loop && me.mediaobj) {
                me.mediaobj.pause();
            }
        }
    };

    window.addEventListener('focus', this.focus, false);
    window.addEventListener('blur', this.blur, false);

    this.play = function () {
        console.log("*****in media " + this.id + " play() function.");
        this.enable = true;
        if (this.infocus && this.mediaobj) {
            // me.mediaobj.play({ numberOfLoops: "infinite" }); // does not work in phonegap
            this.mediaobj.play();
            console.log("*****media " + this.id + " is playing");
        }
    };
    this.pause = function () {
        this.enable = false;
        if (this.mediaobj) {
            this.mediaobj.pause();
        }
    };
    this.stop = function () {
        this.enable = false;
        if (this.mediaobj) {
            this.mediaobj.stop();
        }
    };
}
