// Roller Coaster Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//         Example:
//              alpha: 0.5 // View will be rendered at half transparency
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Roller Coaster Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     audio
//         Available States:
//             PAYOFF: Played after the path is traced.
//             MUSIC: Loops in the background.
//      hint
//         Properties:
//             color: The color (in hex e.g. #ff0000 for red) of the hint line.
//		       speed: The speed (in pixels per second) at which the line is drawn.
//		       width: The diameter of the line.
//		       dashWidth: The length of the dash.
//		       dashGap: The length of the gap between dashes.
//         
// Round Properties
//
//     background
//         Properties:
//            filename: Filename of the background image.
//     rider: Character that will traverse the path upon round completion.
//         Available States:
//             INTRO: Initial state of the bubble.
//             RIDE: Displayed when the rider is moving along the path.
//     dataPoints (Array): Array of objects that describe the points which define the shape.
//         Example:
//             dataPoints: [ 
//			    	{ 
//                      i: 0,
//                      x: 329,
//                      y: 594
//                  }, {
//                      i: 1,
//                      x: 329,
//                      y: 192
//                  }
//             ]
//     hintPaths (Array): Array of objects that describe the hint paths by the using the index 'i' values of the dataPoints.
//          Example:
//              hintPaths: [
//				    [ 0, 1, 2 ],
//                  [ 3, 4 ]
//			    ]
//     successPath (Array): Array of index 'i' values of the dataPoints that describe the path the rider will traverse on sucess.
//          Example:
//              successPath: [ 0, 1, 2, 1, 3, 1, 4 ]
//     targetItems: Items that are activated by touch.  Target items are not visible until activated. Once all target items are activated the round is complete.
//     payoff: View that is displayed while the rider is moving along the path after the round is complete.

WM.config = {
	//showOnlyThisRound: 2,
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -96
		}
	},
	gameIcon: "icon-rollerCoaster-numbers.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "start-rollerCoaster-numbers.jpg",
	audioEnabled: true,
	audioFilename: "audio-rollerCoaster-numbers.mp3", //all audio including intro, payoff, and music is in this one file
	audio: {
		states: [
			{
				name: "music", 
				startTime: 74,
				duration: 91.2,
				loop: true
			}
		]
	},
	hint: {
		color: "#ffea00",
		speed: 10,
		width: 5, //width of the line itself. Makes the dots get bigger
		dashWidth: 10, //width of the dash in pixels. Cannot go higher than 10px
		dashGap: 10 //number of pixels between each dash. Cannot go lower than 10px
	},
	rounds: [
		{ //Round 1
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 68,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 71,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO", //poof animation
						filename: "count_poof_01.png",
						offsetX: -125,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE", //ride animation
						filename: "count_payoff_01.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10, //can find this on the stage of the .fla file
						loop: true,
						offsetX: -60,
						offsetY: -155
					}
				]
			},
			dataPoints: [ //points in the object where the coaster and dots changes direction. Make these up based on x y coordinates in Fireworks
				{ i: 0, x: 528, y: 191 }, { i: 1, x: 520, y: 191 }, { i: 2, x: 509, y: 193 }, { i: 3, x: 491, y: 197 }, { i: 4, x: 474, y: 207 }, { i: 5, x: 460, y: 216 }, { i: 6, x: 444, y: 231 }, { i: 7, x: 430, y: 248 }, { i: 8, x: 420, y: 264 }, { i: 9, x: 410, y: 282 }, { i: 10, x: 402, y: 300 }, { i: 11, x: 394, y: 323 }, { i: 12, x: 387, y: 350 }, { i: 13, x: 384, y: 371 }, { i: 14, x: 384, y: 398 }, { i: 15, x: 385, y: 423 }, { i: 16, x: 388, y: 447 }, { i: 17, x: 392, y: 469 }, { i: 18, x: 401, y: 494 }, { i: 19, x: 416, y: 530 }, { i: 20, x: 433, y: 552 }, { i: 21, x: 454, y: 572 }, { i: 22, x: 477, y: 584 }, { i: 23, x: 500, y: 592 }, { i: 24, x: 526, y: 595 }, { i: 25, x: 550, y: 591 }, { i: 26, x: 576, y: 583 }, { i: 27, x: 595, y: 570 }, { i: 28, x: 615, y: 551 }, { i: 29, x: 641, y: 514 }, { i: 30, x: 654, y: 480 }, { i: 31, x: 661, y: 455 }, { i: 32, x: 665, y: 425 }, { i: 33, x: 668, y: 394 }, { i: 34, x: 664, y: 355 }, { i: 35, x: 654, y: 316 }, { i: 36, x: 642, y: 280 }, { i: 37, x: 627, y: 255 }, { i: 38, x: 614, y: 235 }, { i: 39, x: 597, y: 217 }, { i: 40, x: 581, y: 206 }, { i: 41, x: 560, y: 196 }, { i: 42, x: 537, y: 191 }
				
			],
			hintPaths: [ //these are the dotted line points
				[ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42]
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 ], //this is the payoff rollercoaster ride path
			targetItems: [
				{ filename: "number_0_01.png", x: 376, y: 255 },
				{ filename: "number_0_02.png", x: 358, y: 318 },
				{ filename: "number_0_03.png", x: 331, y: 376 },
				{ filename: "number_0_04.png", x: 358, y: 435 },
				{ filename: "number_0_05.png", x: 358, y: 485 },
				{ filename: "number_0_06.png", x: 399, y: 532 },
				{ filename: "number_0_07.png", x: 489, y: 532 },
				{ filename: "number_0_08.png", x: 558, y: 532 },
				{ filename: "number_0_09.png", x: 558, y: 485 },
				{ filename: "number_0_10.png", x: 558, y: 435 },
				{ filename: "number_0_11.png", x: 584, y: 376 },
				{ filename: "number_0_12.png", x: 558, y: 318 },
				{ filename: "number_0_13.png", x: 558, y: 255 },
				{ filename: "number_0_14.png", x: 399, y: 171 },
				{ filename: "number_0_15.png", x: 489, y: 154 },
				{ filename: "number_0_16.png", x: 558, y: 171 },
			],
			payoff: { filename: "Rollercoaster_number_ON_0.png", x: 0, y: 0 }
		}, { //Round 2
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 0,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 3,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "count_poof_02.png",
						offsetX: -110,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "count_payoff_02.png",
						numFrames: 14,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -62,
						offsetY: -150
					}
				]
			},
			dataPoints: [
				{ i: 0, x: 527, y: 191 }, { i: 1, x: 527, y: 594 }
				
			],
			hintPaths: [
				[ 0, 1 ]
			],
			successPath: [ 0, 1 ],
			targetItems: [
				{ filename: "number_1_01.png", x: 463, y: 165 },
				{ filename: "number_1_02.png", x: 463, y: 218 },
				{ filename: "number_1_03.png", x: 463, y: 252 },
				{ filename: "number_1_04.png", x: 463, y: 297 },
				{ filename: "number_1_05.png", x: 463, y: 336 },
				{ filename: "number_1_06.png", x: 463, y: 378 },
				{ filename: "number_1_07.png", x: 463, y: 418 },
				{ filename: "number_1_08.png", x: 463, y: 455 },
				{ filename: "number_1_09.png", x: 463, y: 493 },
				{ filename: "number_1_10.png", x: 463, y: 529 },
				{ filename: "number_1_11.png", x: 463, y: 563 }
			],
			payoff: { filename: "Rollercoaster_number_ON_1.png", x: 0, y: 0 }
		}, {
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 7,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 10,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "count_poof_01.png",
						offsetX: -125,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "count_payoff_01.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -62,
						offsetY: -150
					}
				]
			},
			dataPoints: [
				{ i: 0, x: 405, y: 264 }, { i: 1, x: 406, y: 263 }, { i: 2, x: 419, y: 239 }, { i: 3, x: 434, y: 217 }, { i: 4, x: 452, y: 201 }, { i: 5, x: 471, y: 189 }, { i: 6, x: 499, y: 182 }, { i: 7, x: 522, y: 181 }, { i: 8, x: 549, y: 188 }, { i: 9, x: 578, y: 203 }, { i: 10, x: 596, y: 225 }, { i: 11, x: 610, y: 259 }, { i: 12, x: 612, y: 291 }, { i: 13, x: 600, y: 326 }, { i: 14, x: 578, y: 369 }, { i: 15, x: 552, y: 415 }, { i: 16, x: 488, y: 513 }, { i: 17, x: 449, y: 568 }, { i: 18, x: 656, y: 569 }
			],
			hintPaths: [
				[3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 ]
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 ],
			targetItems: [
				{ filename: "number_2_01.png", x: 366, y: 218 },
				{ filename: "number_2_02.png", x: 409, y: 160 },
				{ filename: "number_2_03.png", x: 499, y: 160 },
				{ filename: "number_2_04.png", x: 557, y: 175 },
				{ filename: "number_2_05.png", x: 557, y: 255 },
				{ filename: "number_2_06.png", x: 535, y: 302 },
				{ filename: "number_2_07.png", x: 506, y: 350 },
				{ filename: "number_2_08.png", x: 470, y: 393 },
				{ filename: "number_2_09.png", x: 432, y: 435 },
				{ filename: "number_2_10.png", x: 403, y: 481 },
				{ filename: "number_2_11.png", x: 386, y: 518 },
				{ filename: "number_2_12.png", x: 366, y: 549 },
				{ filename: "number_2_13.png", x: 479, y: 549 },
				{ filename: "number_2_14.png", x: 541, y: 549 },
				{ filename: "number_2_15.png", x: 603, y: 549 }
			],
			payoff: { filename: "Rollercoaster_number_ON_2.png", x: 0, y: 0 }
		},
		{
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 14,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 17,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "count_poof_02.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "count_payoff_02.png",
						numFrames: 14,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -62,
						offsetY: -150
					}
				]
			},
			dataPoints: [
				{ i: 0, x: 443, y: 272 }, { i: 1, x: 451, y: 252 }, { i: 2, x: 462, y: 234 }, { i: 3, x: 479, y: 215 }, { i: 4, x: 499, y: 203 }, { i: 5, x: 518, y: 197 }, { i: 6, x: 538, y: 193 }, { i: 7, x: 557, y: 194 }, { i: 8, x: 577, y: 198 }, { i: 9, x: 596, y: 205 }, { i: 10, x: 612, y: 214 }, { i: 11, x: 628, y: 227 }, { i: 12, x: 643, y: 247 }, { i: 13, x: 651, y: 264 }, { i: 14, x: 654, y: 280 }, { i: 15, x: 656, y: 296 }, { i: 16, x: 656, y: 309 }, { i: 17, x: 653, y: 325 }, { i: 18, x: 647, y: 341 }, { i: 19, x: 640, y: 354 }, { i: 20, x: 631, y: 364 }, { i: 21, x: 617, y: 377 }, { i: 22, x: 599, y: 387 }, { i: 23, x: 585, y: 391 }, { i: 24, x: 571, y: 394 }, { i: 25, x: 536, y: 396 }, { i: 26, x: 587, y: 401 }, { i: 27, x: 602, y: 406 }, { i: 28, x: 614, y: 414 }, { i: 29, x: 624, y: 421 }, { i: 30, x: 633, y: 429 }, { i: 31, x: 641, y: 439 }, { i: 32, x: 647, y: 450 }, { i: 33, x: 653, y: 466 }, { i: 34, x: 656, y: 482 }, { i: 35, x: 656, y: 498 }, { i: 36, x: 654, y: 515 }, { i: 37, x: 649, y: 531 }, { i: 38, x: 638, y: 549 }, { i: 39, x: 629, y: 559 }, { i: 40, x: 618, y: 569 }, { i: 41, x: 606, y: 578 }, { i: 42, x: 592, y: 584 }, { i: 43, x: 575, y: 590 }, { i: 44, x: 559, y: 594 }, { i: 45, x: 543, y: 594 }, { i: 46, x: 529, y: 593 }, { i: 47, x: 514, y: 589 }, { i: 48, x: 499, y: 583 }, { i: 49, x: 485, y: 575 }, { i: 50, x: 474, y: 566 }, { i: 51, x: 462, y: 552 }, { i: 52, x: 452, y: 538 }, { i: 53, x: 443, y: 517 } 	
			],
			hintPaths: [
				[ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 ], 
				[ 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 ]
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 ],
			targetItems: [
				{ filename: "number_3_01.png", x: 383, y: 153 },
				{ filename: "number_3_02.png", x: 454, y: 129 },
				{ filename: "number_3_03.png", x: 512, y: 107 },
				{ filename: "number_3_04.png", x: 574, y: 129 },
				{ filename: "number_3_05.png", x: 620, y: 153 },
				{ filename: "number_3_06.png", x: 620, y: 242 },
				{ filename: "number_3_07.png", x: 597, y: 299 },
				{ filename: "number_3_08.png", x: 574, y: 349 },
				{ filename: "number_3_09.png", x: 519, y: 384 },
				{ filename: "number_3_10.png", x: 607, y: 384 },
				{ filename: "number_3_11.png", x: 607, y: 437 },
				{ filename: "number_3_12.png", x: 607, y: 477 },
				{ filename: "number_3_13.png", x: 589, y: 523 },
				{ filename: "number_3_14.png", x: 563, y: 570 },
				{ filename: "number_3_15.png", x: 519, y: 570 },
				{ filename: "number_3_16.png", x: 483, y: 540 },
				{ filename: "number_3_17.png", x: 454, y: 506 },
				{ filename: "number_3_18.png", x: 383, y: 488 }
			],
			payoff: { filename: "Rollercoaster_number_ON_3.png", x: 0, y: 0 }
		},
		{
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 20,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 23,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "count_poof_01.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "count_payoff_01.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -62,
						offsetY: -150
					}
				]
			},
			dataPoints: [
				{ i: 0, x: 408, y: 192 }, { i: 1, x: 408, y: 380 }, { i: 2, x: 671, y: 380 }, { i: 3, x: 594, y: 380 }, { i: 4, x: 595, y: 193 }, { i: 5, x: 595, y: 594 }
			],
			hintPaths: [
				[ 0, 1, 2 ],
				[ 4, 5 ]
			],
			successPath: [ 0, 1, 2, 3, 4, 5 ],
			targetItems: [
				{ filename: "number_4_01.png", x: 368, y: 174 },
				{ filename: "number_4_02.png", x: 368, y: 228 },
				{ filename: "number_4_03.png", x: 368, y: 278 },
				{ filename: "number_4_04.png", x: 368, y: 325 },
				{ filename: "number_4_05.png", x: 368, y: 365 },
				{ filename: "number_4_06.png", x: 461, y: 365 },
				{ filename: "number_4_07.png", x: 522, y: 365 },
				{ filename: "number_4_08.png", x: 575, y: 365 },
				{ filename: "number_4_09.png", x: 640, y: 365 },
				{ filename: "number_4_10.png", x: 575, y: 435 },
				{ filename: "number_4_11.png", x: 575, y: 486 },
				{ filename: "number_4_12.png", x: 575, y: 533 },
				{ filename: "number_4_13.png", x: 575, y: 571 },
				{ filename: "number_4_14.png", x: 575, y: 325 },
				{ filename: "number_4_15.png", x: 575, y: 278 },
				{ filename: "number_4_16.png", x: 575, y: 228 },
				{ filename: "number_4_17.png", x: 575, y: 174 }
			],
			payoff: { filename: "Rollercoaster_number_ON_4.png", x: 0, y: 0 }
		},
		{
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 27,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 30,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "count_poof_02.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "count_payoff_02.png",
						numFrames: 14,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -62,
						offsetY: -150
					}
				]
			},
			dataPoints: [
				{ i: 0, x: 654, y: 192 }, { i: 1, x: 419, y: 192 }, { i: 2, x: 420, y: 402 }, { i: 3, x: 436, y: 389 }, { i: 4, x: 450, y: 380 }, { i: 5, x: 464, y: 374 }, { i: 6, x: 483, y: 364 }, { i: 7, x: 503, y: 358 }, { i: 8, x: 523, y: 354 }, { i: 9, x: 541, y: 352 }, { i: 10, x: 562, y: 355 }, { i: 11, x: 580, y: 359 }, { i: 12, x: 598, y: 367 }, { i: 13, x: 614, y: 377 }, { i: 14, x: 631, y: 395 }, { i: 15, x: 644, y: 416 }, { i: 16, x: 650, y: 434 }, { i: 17, x: 654, y: 454 }, { i: 18, x: 654, y: 480 }, { i: 19, x: 651, y: 500 }, { i: 20, x: 646, y: 520 }, { i: 21, x: 635, y: 541 }, { i: 22, x: 624, y: 558 }, { i: 23, x: 609, y: 570 }, { i: 24, x: 593, y: 581 }, { i: 25, x: 572, y: 589 }, { i: 26, x: 551, y: 593 }, { i: 27, x: 519, y: 591 }, { i: 28, x: 499, y: 586 }, { i: 29, x: 481, y: 577 }, { i: 30, x: 465, y: 568 }, { i: 31, x: 447, y: 555 }, { i: 32, x: 432, y: 541 }, { i: 33, x: 424, y: 533 }	
			],
			hintPaths: [
				[ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 ],
				[ 1, 0]
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 ],
			targetItems: [
				{ filename: "number_5_01.png", x: 609, y: 173 },
				{ filename: "number_5_02.png", x: 569, y: 173 },
				{ filename: "number_5_03.png", x: 521, y: 173 },
				{ filename: "number_5_04.png", x: 477, y: 173 },
				{ filename: "number_5_05.png", x: 396, y: 173 },
				{ filename: "number_5_06.png", x: 396, y: 240 },
				{ filename: "number_5_07.png", x: 396, y: 276 },
				{ filename: "number_5_08.png", x: 396, y: 308 },
				{ filename: "number_5_09.png", x: 396, y: 347 },
				{ filename: "number_5_10.png", x: 477, y: 292 },
				{ filename: "number_5_11.png", x: 521, y: 292 },
				{ filename: "number_5_12.png", x: 569, y: 292 },
				{ filename: "number_5_13.png", x: 609, y: 308 },
				{ filename: "number_5_14.png", x: 609, y: 389 },
				{ filename: "number_5_15.png", x: 609, y: 430 },
				{ filename: "number_5_16.png", x: 609, y: 475 },
				{ filename: "number_5_17.png", x: 594, y: 520 },
				{ filename: "number_5_18.png", x: 575, y: 561 },
				{ filename: "number_5_19.png", x: 528, y: 561 },
				{ filename: "number_5_20.png", x: 477, y: 540 },
				{ filename: "number_5_21.png", x: 436, y: 511 },
				{ filename: "number_5_22.png", x: 363, y: 497 }
			],
			payoff: { filename: "Rollercoaster_number_ON_5.png", x: 0, y: 0 }
		},
		{
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 34,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 37,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "count_poof_01.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "count_payoff_01.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -62,
						offsetY: -150
					}
				]
			},
			dataPoints: [
				{ i: 0, x: 552, y: 174 }, { i: 1, x: 523, y: 203 }, { i: 2, x: 493, y: 241 }, { i: 3, x: 467, y: 279 }, { i: 4, x: 441, y: 327 }, { i: 5, x: 412, y: 388 }, { i: 6, x: 400, y: 438 }, { i: 7, x: 398, y: 471 }, { i: 8, x: 399, y: 491 }, { i: 9, x: 407, y: 513 }, { i: 10, x: 413, y: 529 }, { i: 11, x: 423, y: 543 }, { i: 12, x: 435, y: 556 }, { i: 13, x: 447, y: 566 }, { i: 14, x: 460, y: 576 }, { i: 15, x: 474, y: 584 }, { i: 16, x: 491, y: 589 }, { i: 17, x: 512, y: 593 }, { i: 18, x: 537, y: 594 }, { i: 19, x: 557, y: 591 }, { i: 20, x: 575, y: 587 }, { i: 21, x: 593, y: 578 }, { i: 22, x: 607, y: 569 }, { i: 23, x: 622, y: 557 }, { i: 24, x: 632, y: 544 }, { i: 25, x: 643, y: 528 }, { i: 26, x: 651, y: 511 }, { i: 27, x: 657, y: 489 }, { i: 28, x: 659, y: 464 }, { i: 29, x: 656, y: 438 }, { i: 30, x: 649, y: 416 }, { i: 31, x: 643, y: 402 }, { i: 32, x: 633, y: 387 }, { i: 33, x: 621, y: 373 }, { i: 34, x: 602, y: 359 }, { i: 35, x: 578, y: 348 }, { i: 36, x: 553, y: 341 }, { i: 37, x: 524, y: 340 }, { i: 38, x: 502, y: 343 }, { i: 39, x: 479, y: 350 }, { i: 40, x: 461, y: 358 }, { i: 41, x: 438, y: 376 }, { i: 42, x: 421, y: 392 }
			],
			hintPaths: [
				[ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 ]
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 ],
			targetItems: [
				{ filename: "number_6_01.png", x: 464, y: 143 },
				{ filename: "number_6_02.png", x: 448, y: 201 },
				{ filename: "number_6_03.png", x: 412, y: 242 },
				{ filename: "number_6_04.png", x: 412, y: 283 },
				{ filename: "number_6_05.png", x: 382, y: 322 },
				{ filename: "number_6_06.png", x: 364, y: 364 },
				{ filename: "number_6_07.png", x: 364, y: 410 },
				{ filename: "number_6_08.png", x: 364, y: 449 },
				{ filename: "number_6_09.png", x: 364, y: 489 },
				{ filename: "number_6_10.png", x: 391, y: 524 },
				{ filename: "number_6_11.png", x: 464, y: 524 },
				{ filename: "number_6_12.png", x: 506, y: 524 },
				{ filename: "number_6_13.png", x: 549, y: 524 },
				{ filename: "number_6_14.png", x: 588, y: 524 },
				{ filename: "number_6_15.png", x: 588, y: 489 },
				{ filename: "number_6_16.png", x: 588, y: 449 },
				{ filename: "number_6_17.png", x: 588, y: 410 },
				{ filename: "number_6_18.png", x: 588, y: 333 },
				{ filename: "number_6_19.png", x: 539, y: 322 },
				{ filename: "number_6_20.png", x: 484, y: 322 }
			],
			payoff: { filename: "Rollercoaster_number_ON_6.png", x: 0, y: 0 }
		},
		{
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 41,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 44,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "count_poof_02.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "count_payoff_02.png",
						numFrames: 14,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -62,
						offsetY: -150
					}
				]
			},
			dataPoints: [
				{ i: 0, x: 393, y: 193 }, { i: 1, x: 651, y: 193 }, { i: 2, x: 483, y: 595 }
			],
			hintPaths: [
				[ 0, 1, 2 ]
			],
			successPath: [ 0, 1, 2 ],
			targetItems: [
				{ filename: "number_7_01.png", x: 366, y: 171 },
				{ filename: "number_7_02.png", x: 446, y: 171 },
				{ filename: "number_7_03.png", x: 505, y: 171 },
				{ filename: "number_7_04.png", x: 559, y: 171 },
				{ filename: "number_7_05.png", x: 619, y: 171 },
				{ filename: "number_7_06.png", x: 538, y: 242 },
				{ filename: "number_7_07.png", x: 512, y: 293 },
				{ filename: "number_7_08.png", x: 492, y: 339 },
				{ filename: "number_7_09.png", x: 475, y: 384 },
				{ filename: "number_7_10.png", x: 440, y: 427 },
				{ filename: "number_7_11.png", x: 427, y: 477 },
				{ filename: "number_7_12.png", x: 406, y: 520 },
				{ filename: "number_7_13.png", x: 406, y: 564 }
			],
			payoff: { filename: "Rollercoaster_number_ON_7.png", x: 0, y: 0 }
		},
		{
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 48,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 51,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "count_poof_01.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "count_payoff_01.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -62,
						offsetY: -150
					}
				]
			},
			dataPoints: [
				{ i: 0, x: 614, y: 237 }, { i: 1, x: 468, y: 395 }, { i: 2, x: 450, y: 417 }, { i: 3, x: 436, y: 439 }, { i: 4, x: 427, y: 465 }, { i: 5, x: 425, y: 483 }, { i: 6, x: 425, y: 506 }, { i: 7, x: 429, y: 524 }, { i: 8, x: 437, y: 543 }, { i: 9, x: 450, y: 559 }, { i: 10, x: 461, y: 571 }, { i: 11, x: 477, y: 581 }, { i: 12, x: 501, y: 591 }, { i: 13, x: 524, y: 595 }, { i: 14, x: 550, y: 594 }, { i: 15, x: 574, y: 589 }, { i: 16, x: 603, y: 575 }, { i: 17, x: 618, y: 563 }, { i: 18, x: 632, y: 541 }, { i: 19, x: 640, y: 523 }, { i: 20, x: 642, y: 505 }, { i: 21, x: 642, y: 485 }, { i: 22, x: 634, y: 464 }, { i: 23, x: 623, y: 447 }, { i: 24, x: 610, y: 435 }, { i: 25, x: 596, y: 424 }, { i: 26, x: 581, y: 414 }, { i: 27, x: 570, y: 408 }, { i: 28, x: 558, y: 401 }, { i: 29, x: 542, y: 394 }, { i: 30, x: 525, y: 386 }, { i: 31, x: 491, y: 373 }, { i: 32, x: 475, y: 366 }, { i: 33, x: 463, y: 354 }, { i: 34, x: 450, y: 340 }, { i: 35, x: 441, y: 322 }, { i: 36, x: 436, y: 311 }, { i: 37, x: 433, y: 299 }, { i: 38, x: 432, y: 286 }, { i: 39, x: 434, y: 268 }, { i: 40, x: 439, y: 253 }, { i: 41, x: 448, y: 238 }, { i: 42, x: 456, y: 227 }, { i: 43, x: 465, y: 217 }, { i: 44, x: 479, y: 206 }, { i: 45, x: 490, y: 200 }, { i: 46, x: 500, y: 195 }, { i: 47, x: 516, y: 191 }, { i: 48, x: 530, y: 190 }, { i: 49, x: 543, y: 191 }, { i: 50, x: 555, y: 194 }, { i: 51, x: 573, y: 201 }, { i: 52, x: 588, y: 210 }, { i: 53, x: 600, y: 221 }, { i: 54, x: 610, y: 231 } 
			],
			hintPaths: [
				[ 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 ]
			],
			successPath: [ 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 ],
			targetItems: [
				{ filename: "number_8_01.png", x: 568, y: 234 },
				{ filename: "number_8_02.png", x: 525, y: 268 },
				{ filename: "number_8_03.png", x: 488, y: 307 },
				{ filename: "number_8_04.png", x: 488, y: 338 },
				{ filename: "number_8_05.png", x: 488, y: 375 },
				{ filename: "number_8_06.png", x: 543, y: 412 },
				{ filename: "number_8_07.png", x: 586, y: 452 },
				{ filename: "number_8_08.png", x: 609, y: 494 },
				{ filename: "number_8_09.png", x: 586, y: 530 },
				{ filename: "number_8_10.png", x: 586, y: 563 },
				{ filename: "number_8_11.png", x: 543, y: 563 },
				{ filename: "number_8_12.png", x: 488, y: 563 },
				{ filename: "number_8_13.png", x: 457, y: 539 },
				{ filename: "number_8_14.png", x: 352, y: 539 },
				{ filename: "number_8_15.png", x: 352, y: 494 },
				{ filename: "number_8_16.png", x: 352, y: 452 },
				{ filename: "number_8_17.png", x: 352, y: 412 },
				{ filename: "number_8_18.png", x: 385, y: 375 },
				{ filename: "number_8_19.png", x: 385, y: 338 },
				{ filename: "number_8_20.png", x: 352, y: 307 },
				{ filename: "number_8_21.png", x: 352, y: 268 },
				{ filename: "number_8_22.png", x: 352, y: 234 },
				{ filename: "number_8_23.png", x: 370, y: 137 },
				{ filename: "number_8_24.png", x: 473, y: 137 },
				{ filename: "number_8_25.png", x: 512, y: 137 },
				{ filename: "number_8_26.png", x: 558, y: 137 },
				{ filename: "number_8_27.png", x: 599, y: 137 }
			],
			payoff: { filename: "Rollercoaster_number_ON_8.png", x: 0, y: 0 }
		},
		{
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 55,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 58,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "count_poof_02.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "count_payoff_02.png",
						numFrames: 14,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -62,
						offsetY: -150
					}
				]
			},
			dataPoints: [
				{ i: 0, x: 638, y: 342 }, { i: 1, x: 629, y: 360 }, { i: 2, x: 615, y: 377 }, { i: 3, x: 601, y: 391 }, { i: 4, x: 578, y: 406 }, { i: 5, x: 557, y: 413 }, { i: 6, x: 533, y: 417 }, { i: 7, x: 507, y: 414 }, { i: 8, x: 481, y: 406 }, { i: 9, x: 458, y: 393 }, { i: 10, x: 438, y: 373 }, { i: 11, x: 428, y: 358 }, { i: 12, x: 419, y: 334 }, { i: 13, x: 415, y: 320 }, { i: 14, x: 414, y: 299 }, { i: 15, x: 418, y: 277 }, { i: 16, x: 425, y: 257 }, { i: 17, x: 435, y: 239 }, { i: 18, x: 452, y: 221 }, { i: 19, x: 467, y: 209 }, { i: 20, x: 483, y: 201 }, { i: 21, x: 502, y: 194 }, { i: 22, x: 521, y: 191 }, { i: 23, x: 543, y: 191 }, { i: 24, x: 564, y: 195 }, { i: 25, x: 584, y: 202 }, { i: 26, x: 600, y: 211 }, { i: 27, x: 613, y: 223 }, { i: 28, x: 625, y: 237 }, { i: 29, x: 634, y: 253 }, { i: 30, x: 639, y: 269 }, { i: 31, x: 642, y: 289 }, { i: 32, x: 644, y: 303 }, { i: 33, x: 644, y: 340 }, { i: 34, x: 644, y: 594 }	
			],
			hintPaths: [
				 [32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 32],
				 [33, 34]
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34],
			targetItems: [
				{ filename: "number_9_01.png", x: 566, y: 557 },
				{ filename: "number_9_02.png", x: 566, y: 509 },
				{ filename: "number_9_03.png", x: 566, y: 467 },
				{ filename: "number_9_04.png", x: 566, y: 434 },
				{ filename: "number_9_05.png", x: 596, y: 409 },
				{ filename: "number_9_06.png", x: 596, y: 368 },
				{ filename: "number_9_07.png", x: 596, y: 319 },
				{ filename: "number_9_08.png", x: 596, y: 278 },
				{ filename: "number_9_09.png", x: 566, y: 254 },
				{ filename: "number_9_10.png", x: 582, y: 185 },
				{ filename: "number_9_11.png", x: 547, y: 166 },
				{ filename: "number_9_12.png", x: 506, y: 166 },
				{ filename: "number_9_13.png", x: 470, y: 177 },
				{ filename: "number_9_14.png", x: 394, y: 191 },
				{ filename: "number_9_15.png", x: 394, y: 262 },
				{ filename: "number_9_16.png", x: 394, y: 305 },
				{ filename: "number_9_17.png", x: 394, y: 336 },
				{ filename: "number_9_18.png", x: 470, y: 336 },
				{ filename: "number_9_19.png", x: 506, y: 336 },
				{ filename: "number_9_20.png", x: 547, y: 336 }
			],
			payoff: { filename: "Rollercoaster_number_ON_9.png", x: 0, y: 0 }
		}
	]
};