function itemFilter(selectobj) { 
    if (window.XMLHttpRequest) {
      xmlhttp = new XMLHttpRequest();
    }
    xmlhttp.open("GET", "recipes.xml", false);
    xmlhttp.send();
    this.source = xmlhttp.responseXML;
    this.testIndex = 0;
    this.selectobj = selectobj;
    this.init = function() {
        this.optionscopy = new Array();
        if (this.selectobj && this.selectobj.options) {
          for (var i=0; i < this.selectobj.options.length; i++) {
            this.optionscopy[i] = new Option();
            this.optionscopy[i].text = selectobj.options[i].text;
            this.optionscopy[i].value = selectobj.options[i].value;
          }
        }
      }
      
  this.testRecipes = function () {
    this.loadRecipe(this.testIndex);
    this.testIndex++;
  }    
    
  this.reset = function() {
    this.set('');
  }
  
  this.set = function(pattern) {
    var loop=0, index=0, regexp, e;
    this.selectobj.options.length = 0;
    try {
      regexp = new RegExp(pattern, 'i');
    } catch(e) {
      if (typeof this.hook == 'function') {
        this.hook();
      }
      return;
    }
    for (loop=0; loop < this.optionscopy.length; loop++) {
      var option = this.optionscopy[loop];
      if ((regexp.test(option.text)) ||
          (regexp.test(option.value))) {
        this.selectobj.options[index++] =
          new Option(option.text, option.value, false);
      }
    }
    if (typeof this.hook == 'function') {
      this.hook();
    }
  }
  
  this.getName = function (str) {
      var pieces = str.split("_");
    for (var i = 0; i < pieces.length; i++) {
        var j = pieces[i].charAt(0).toUpperCase();
        pieces[i] = j + pieces[i].substr(1);
    }
    return pieces.join(" ");
  }
  
  this.removeDuplicates = function (array) {
    var results = [];
      array = array.sort();
      for (var i = 0; i < array.length - 1; i++) {
          if (array[i + 1] != array[i]) {   
              results.push(array[i]);
          }
      }    
    results.push(array[array.length - 1]);
    return results;
}

  this.loadItems = function () {
      items = this.source.getElementsByTagName("code");
      
      var options = [];      
      for (var index = 0; index < items.length; index++) {
          var name = this.getName(items[index].textContent);
          options[index] = [];
          options[index][0] = name;
          options[index][1] = index;
      }
      options.sort();
   
      for (var index = 0; index < options.length; index++) {
        this.selectobj.options[index] = new Option(options[index][0], options[index][1], false);
      } 
  }
  
  
  this.loadItems();
    
  this.init();
    
  this.loadRecipe = function (itemID) {
      var node = document.getElementById('recipes');
      while (node.hasChildNodes()) {
          node.removeChild(node.lastChild);
      }
      item = this.source.getElementsByTagName('item')[itemID];
      recipes = item.getElementsByTagName('recipe');
      for (var index = 0; index < recipes.length; index++) {
       this.displayRecipe(recipes[index], item);
    }
  }
  
  this.displayRecipe = function (recipe, item) {
      var type = recipe.getElementsByTagName('type')[0].textContent;
      var process = document.createElement('div');
      process.classList.add('process');
      var versions = document.createElement('small');
      versions.classList.add('versions');
      versions.textContent = recipe.getElementsByTagName('versions')[0].textContent;
      var h2 = document.createElement('h2');
      var table = document.createElement('table');
      table.classList.add('inline');
      process.appendChild(versions);
      process.appendChild(h2);
      process.appendChild(table);
      var description = document.createElement('div');
      description.classList.add('description');
      description.textContent = 'popis';
      description.classList.add('clear');
      var arrow = document.createElement('div');
      arrow.classList.add('inline');
      arrow.classList.add('arrow-right');
      var result = document.createElement('div');
      result.classList.add('result');
      result.classList.add('inline');
      result.classList.add(item.getElementsByTagName('code')[0].textContent);
      var desc = [];
      if (type === '2') {
          h2.textContent = 'Brewing recipe'; 
          for (var i = 0; i < 3; i++) {
              var tr = document.createElement('tr');
              for (var j = 0; j < 3; j++) {
                  var td = document.createElement('td');
                  if (i == 0) {
                      if (j == 0)
                          td.classList.add('bubbles-top');
                      else if (j == 1)
                          td.classList.add(recipe.getElementsByTagName('resource')[1].textContent);
                      else
                          td.classList.add('arrow-top');
                  } else if (i == 1) {
                      if (j == 0)
                          td.classList.add('bubbles-bottom');
                      else if (j == 1)
                          td.classList.add('pipes');
                      else
                          td.classList.add('arrow-bottom');
                  } else {
                      td.classList.add(recipe.getElementsByTagName('resource')[0].textContent)
                  }
                  tr.appendChild(td);
              }
              table.appendChild(tr);
          }
          desc.push(recipe.getElementsByTagName('resource')[0].textContent.replace(/_/g, ' '));
          desc.push(recipe.getElementsByTagName('resource')[1].textContent.replace(/_/g, ' '));
          desc.push("Blaze Rod as a Fuel (only in 1.9)");
      } else if (type === '1') {
          h2.textContent = 'Smelting recipe';
          for (var i = 0; i < 3; i++) {
              var tr = document.createElement('tr');
              var td = document.createElement('td');
              if (i == 0) {
                  td.classList.add(recipe.getElementsByTagName('resource')[0].textContent);
                  tr.appendChild(td);
                  desc.push(recipe.getElementsByTagName('resource')[0].textContent.replace(/_/g, ' '));
                  desc.push('Any Fuel');
              } else if (i == 1) {
                  td.classList.add('flame');
              } else {
                  td.classList.add('any_fuel');
              }
              tr.appendChild(td);
              table.appendChild(tr);
          }
      } else if (type === '0') {
          h2.textContent = 'Crafting recipe'; 
          for (var i = 0; i < 3; i++) {
              var tr = document.createElement('tr');
              for (var j = 0; j < 3; j++) {
                  var td = document.createElement('td');
                  if (recipe.getElementsByTagName('resource')[(i * 3) + j].textContent != '') {
                      td.classList.add(recipe.getElementsByTagName('resource')[(i * 3) + j].textContent);
                      desc.push(recipe.getElementsByTagName('resource')[(i * 3) + j].textContent.replace(/_/g, ' '));
                  }
                  tr.appendChild(td);
              }
              table.appendChild(tr);
          }         
      } 
      var amount = document.createElement('span');
      amount.classList.add('amount');
      amount.textContent = 'x' + recipe.getElementsByTagName('amount')[0].textContent;
      var d = this.removeDuplicates(desc);
      description.textContent = d.join(' + ');
      process.appendChild(arrow);
      process.appendChild(result);
      process.appendChild(amount);
      process.appendChild(description);
     document.getElementById('recipes').appendChild(process);
  }
}


