var focused = false;

$(document).ready(function() {

	$(window).focus(function() {
		focused = true;
	}).blur(function() {
		focused = false;
	});

	$(document).focus(function() {
		focused = true;
	}).blur(function() {
		focused = false;
	});

	$(document).delegate("a", "click", function(e) {
		e.preventDefault();
	});

	$(document).click(function(e) {
		if( $("#smiley").is(":visible") && $(e.target).parents("#smiley").length == 0 && $(e.target) != $("#smiley") ) {
			$("#smiley").hide();
			return false;
		}
	});

	$("#chats .content").delegate("a", "click", function() {
		var group = $(this).data("group");
		$("#chats").addClass("out");
		$("#chat").removeClass("out");
		$("#chat").data("group", group);
		updateChat();
	});

	$(".header a").click(function() {
		var href = $(this).attr("href");
		if(href == "#chats") {
			$("#chat").data("group", "");
			updateChatList();
		}
		if(href == "#new" && $(this).parents("#add").length==0) {
			$("#new .content").html("");
		}
		if(href == "#add") {
			addContacts();
		}
		if(href == "#smiley") {
			setTimeout(function() {
				$("#smiley").slideDown("slow");
			}, 500);
		}

		if(href != "#smiley") {
			$(this).parents(".page").addClass("out");
			$(href).removeClass("out");
		}
	});


	$("#searchcontact").on("input", function() {
		var search = ($(this).val()).trim();
		$("#add .contact").each(function() {
			var name = ($(this).find(".name").text()).toLowerCase();
			if(name.indexOf(search) == -1) {
				$(this).hide();
			}
			else {
				$(this).show();
			}
		});
	});

	$("#add").delegate(".contact a", "click", function() {
		var phone = $(this).parents(".contact").data("phone");
		var name = $(this).parents(".contact").find(".name").text();
		$(this).parents(".contact").slideUp("slow", function() {
			$(this).remove();
		});
		$("#new .content").append('<div class="contact" data-phone="'+phone+'"><span class="name">'+name+'</span><a href="#"></a></div>');
	});

	$("#new").delegate(".contact a", "click", function() {
		$(this).parents(".contact").slideUp("slow", function() {
			$(this).remove();
		});
	});


	$("#new #creategroup").click(function() {
		var added = getNew();
		added.push(local.get("mynumber"));
		added.sort();
		if(added.length < 2) {
			return;
		}
		api.createGroup(added, function(id) {
			async.get("groups", function(groups) {
				groups[id] = added;
				async.set("groups", groups, function() {
					updateChatList();
				});
				$("#new").addClass("out");
				$("#chats").removeClass("out");
			});
		});
	});

	$("#chat #sendmsg").click(function() {
		var msg = ($(this).parents(".send").find("input").val()).trim();
		$(this).parents(".send").find("input").val("");

		var d = new Date();
		var h = (d.getHours()).toString();
		var m = (d.getMinutes()).toString();
		if(m.length < 2) {
			m = "0"+m;
		}
		if(h.length < 2) {
			h = "0"+h;
		}
		var date = h+":"+m;

		var mess = msg;
		var smil = mess.match(/\[smiley-(\d+)\]/);
		if(smil) {
			mess = '<img src="img/smiley/'+smil[1]+'.png" alt>';
		}

		$("#chat .content").append('<div class="chat"> <div class="out"> <span class="text">'+mess+'</span> <span class="time">'+date+'</span> </div> </div>');

		var mynum = local.get("mynumber");
		var groupid = $(this).parents(".page").data("group");

		api.sendMessage(mynum, groupid, msg, function(id) {
			async.get("messages", function(messages) {
				messages[id] = {"group": groupid, "from": mynum, "message": msg, "time": d.getTime(), "new": false};
				async.set("messages", messages);
			});
		});
		$("#chat .content").scrollTop($("#chat .content").get(0).scrollHeight);
	});

	$("#smiley img").click(function() {
		var smiley = $(this).data("smiley");
		$("#chat .send input").val("[smiley-"+smiley+"]");
		$("#chat #sendmsg").click();
	});

});