var months = {
	0: "Jan.",
	1: "Feb.",
	2: "Mar.",
	3: "Apr.",
	4: "May",
	5: "Jun.",
	6: "Jul.",
	7: "Aug.",
	8: "Sep.",
	9: "Oct.",
	10: "Nov.",
	11: "Dec."
}

function initApp() {

	readContacts();
	updateChatList();
	
}

function updateChatList() {
	var mynum = local.get("mynumber");

	async.get("groups", function(groups) {
		async.get("contacts", function(contacts) {
			async.get("messages", function(messages) {

				$("#chats .content").html("");

				$.each(groups, function(key, val) {

					var users = [];
					$.each(val, function(k, v) {
						if(v != mynum) {
							if(contacts[v]) {
								users.push(contacts[v]);
							}
							else {
								users.push("+"+v);
							}
						}
					});

					var msg = 0;
					var unread = 0;
					$.each(messages, function(k, v) {
						if(v.group == key) {
							msg = k;

							if(v["new"] == true) {
								unread++;
							}
						}
					});

					if(msg == 0) {
						var date = "&nbsp;";
					}
					else {
						var d = new Date(parseInt(messages[msg]["time"]));
						if(d.toLocaleDateString() == (new Date()).toLocaleDateString()) {
							var h = (d.getHours()).toString();
							var m = (d.getMinutes()).toString();
							if(m.length < 2) {
								m = "0"+m;
							}
							if(h.length < 2) {
								h = "0"+h;
							}
							var date = h+":"+m;
						}
						else {
							var month = months[d.getMonth()];
							var day = (d.getDate()).toString();
							var h = (d.getHours()).toString();
							var m = (d.getMinutes()).toString();
							var date = month+" "+day+", "+h+":"+m;
						}
					}
					
					if(msg != 0) {
						var mess = messages[msg].message;
						if(mess.match(/\[smiley-(\d+)\]/)) {
							mess = "";
						}
					}

					$("#chats .content").append('<a href="#" data-group="'+key+'"> <div class="'+(val.length==2?'image':'image group')+'"></div> <div class="data"> <span class="name">'+users.join(", ")+'</span> <span class="message">'+(msg==0?'&nbsp;':mess)+'</span> </div> <div class="right"> <span class="date">'+date+'</span> '+(unread==0?'':'<span class="new">'+unread+'</span>')+' </div> </a>');

				});

			});
		});
	});
}


function updateChat() {
	var mynum = local.get("mynumber");

	var id = $("#chat").data("group");
	if(!id) {
		return;
	}

	var users = [];

	$("#chat .header h1").text("");
	$("#chat .content").html("");

	async.get("groups", function(groups) {
		async.get("contacts", function(contacts) {
			$.each(groups[id], function(key, val) {
				if(val != mynum) {
					if(contacts[val]) {
						users.push(contacts[val]);
					}
					else {
						users.push("+"+val);
					}
				}
			});
			$("#chat .header h1").text((users.join(", ")));

			async.get("messages", function(messages) {
				$.each(messages, function(key, val) {
					if(val.group == id) {
						var d = new Date(parseInt(val.time));
						if(d.toLocaleDateString() == (new Date()).toLocaleDateString()) {
							var h = (d.getHours()).toString();
							var m = (d.getMinutes()).toString();
							if(m.length < 2) {
								m = "0"+m;
							}
							if(h.length < 2) {
								h = "0"+h;
							}
							var date = h+":"+m;
						}
						else {
							var month = months[d.getMonth()];
							var day = (d.getDate()).toString();
							var h = (d.getHours()).toString();
							var m = (d.getMinutes()).toString();
							if(m.length < 2) {
								m = "0"+m;
							}
							if(h.length < 2) {
								h = "0"+h;
							}
							var date = month+" "+day+", "+h+":"+m;
						}
						
						var mess = val.message;
						var smil = mess.match(/\[smiley-(\d+)\]/);
						if(smil) {
							mess = '<img src="img/smiley/'+smil[1]+'.png" alt>';
						}

						messages[key]["new"] = false;
						$("#chat .content").append('<div class="chat"> <div class="'+(val.from==mynum?'out':'in')+'"> '+(users.length>1&&val.from!=mynum?'<div class="name">'+(contacts[val.from]?contacts[val.from]:"+"+val.from)+'</div>':'')+' <span class="text">'+mess+'</span> <span class="time">'+date+'</span> </div> </div>');
					}
				});
				$("#chat .content").scrollTop($("#chat .content").get(0).scrollHeight);
				async.set("messages", messages);
			});
		});
	});

	/*async.get("messages", function(messages) {
		$.each(messages, function(key, val) {
			if(val.group == id) {
				var d = new Date(parseInt(val.time));
				if(d.toLocaleDateString() == (new Date()).toLocaleDateString()) {
					var h = (d.getHours()).toString();
					var m = (d.getMinutes()).toString();
					if(m.length < 2) {
						m = "0"+m;
					}
					if(h.length < 2) {
						h = "0"+h;
					}
					var date = h+":"+m;
				}
				else {
					var month = months[d.getMonth()];
					var day = (d.getDate()).toString();
					var h = (d.getHours()).toString();
					var m = (d.getMinutes()).toString();
					if(m.length < 2) {
						m = "0"+m;
					}
					if(h.length < 2) {
						h = "0"+h;
					}
					var date = month+" "+day+", "+h+":"+m;
				}
				
				var mess = val.message;
				var smil = mess.match(/\[smiley-(\d+)\]/);
				if(smil) {
					mess = '<img src="img/smiley/'+smil[1]+'.png" alt>';
				}

				messages[key]["new"] = false;
				console.log(users.length);
				$("#chat .content").append('<div class="chat"> <div class="'+(val.from==mynum?'out':'in')+'"> '+(users.length>1?'<div class="name">'+(contacts[val.from]?contacts[val.from]:val.from)+'</div>':'')+' <span class="text">'+mess+'</span> <span class="time">'+date+'</span> </div> </div>');
			}
		});
		$("#chat .content").scrollTop($("#chat .content").get(0).scrollHeight);
		async.set("messages", messages);
	});*/
}


function addContacts() {
	var added = getNew();
	$("#add .content").html("");
	async.get("contacts", function(data) {
		$.each(data, function(key, val) {
			if(added.indexOf(key) == -1) {
				$("#add .content").append('<div class="contact" data-phone="'+key+'"><span class="name">'+val+'</span><a href="#"></a></div>');
			}
		});
	});
}


function getNew() {
	var res = [];
	$("#new .contact").each(function() {
		res.push(($(this).data("phone")).toString());
	});
	res.sort();
	return res;
}