var server = "http://srv.vsakos.com/chat/api.php";

var api = {

	requestSms: function(number, callback) {
		$.getJSON(server+"?p=sms&number="+number).done(function(data) {
			if(typeof callback == "function") {
				callback(data.key);
			}
		});
	},

	register: function(number, callback) {
		$.getJSON(server+"?p=add&number="+number).done(function(data) {
			if(typeof callback == "function") {
				callback();
			}
		});
	},

	sendPushEndpoint: function(number, link, callback) {
		$.getJSON(server+"?p=push&number="+number+"&endpoint="+btoa(link)).done(function(data) {
			if(typeof callback == "function") {
				callback();
			}
		});
	},

	sendMessage: function(from, to, text, callback) {
		$.getJSON(server+"?p=msg&number="+from+"&to="+to+"&text="+btoa(text)).done(function(data) {
			if(typeof callback == "function") {
				callback(data.id);
			}
		});
	},

	getMessages: function(number, callback) {
		$.getJSON(server+"?p=get&number="+number).done(function(data) {
			console.log("done");
			if(typeof callback == "function") {
				callback(data);
			}
		});
	},

	getGroup: function(id, callback) {
		$.getJSON(server+"?p=getgroup&id="+id).done(function(data) {
			if(typeof callback == "function") {
				callback(data);
			}
		});
	},

	createGroup: function(list, callback) {
		$.getJSON(server+"?p=creategroup&numbers="+list.join(",")).done(function(data) {
			if(typeof callback == "function") {
				callback(data.id);
			}
		});
	},

	checkContacts: function(contacts, callback) {
		$.getJSON(server+"?p=check&list="+contacts.join(",")).done(function(data) {
			if(typeof callback == "function") {
				callback(data);
			}
		});
	}

}