function registerPush() {
	var req = navigator.push.register();
	req.onsuccess = function(e) {
		var endpoint = e.target.result;
		//console.log(endpoint);
		api.sendPushEndpoint(local.get("mynumber"), endpoint, function() {});
	}
}

navigator.mozSetMessageHandler("push", function() {
	if(focused) {
		var p = new Audio("../sound/beep.ogg");
		p.play();
	}
	else {
		(navigator.mozNotification.createNotification("Cravox", "Hey! You got a new message.")).show();
	}

	api.getMessages(local.get("mynumber"), function(data) {
		async.get("messages", function(messages) {
			$.each(data, function(key, val) {
				messages[val.id] = {"group": val.group, "from": val.from, "message": val.text, "time": (new Date()).getTime(), "new": true};
				async.get("groups", function(groups) {
					if(!groups[val.group]) {
						api.getGroup(val.group, function(list) {
							groups[val.group] = list;
							async.set("groups", groups);
						});
					}
				});
			});
			async.set("messages", messages);
			updateChat();
			updateChatList();
		});
	});
});

navigator.mozSetMessageHandler("push-register", function() {
	if(local.get("mynumber") && local.get("myprefix")) {
		registerPush();
	}
});