var local = {
	get: function(key) {
		var temp = localStorage.getItem(key);
		try {
			var obj = JSON.parse(temp);
		}
		catch(e) {
			var obj = temp;
		}
		return obj;
	},
	set: function(key, item) {
		if(typeof item == "object") {
			localStorage.setItem(key, JSON.stringify(item));
		}
		else {
			localStorage.setItem(key, item);
		}
	},
	remove: function(key) {
		localStorage.removeItem(key);
	}
}

var async = {
	get: function(key, callback) {
		asyncStorage.getItem("chat-"+key, callback);
	},
	set: function(key, data, callback) {
		asyncStorage.setItem("chat-"+key, data, callback);
	},
	remove: function(key) {
		asyncStorage.removeItem("chat-"+key);
	}
}