'use strict';

App.colorPicker = {};

App.clickTab1 = function() {

    //console.log("----> App.clickTab1()");

    if (App.Preferences.ColorTab != 1) {
        // Enable Tab 1
        App.Preferences.ColorTab = 1;
        document.getElementById("tab1").style.opacity = "1";

        // Disable Tab 2
        document.getElementById("tab2").style.opacity = "0.3";

        // Update Colors section UI
        if (App.Preferences.Color1chk === "RANDOM") {
            document.getElementById("chk-v").style.display = "block";
            document.getElementById("colorPicker").style.opacity = "0.3";
        } else {
            document.getElementById("chk-v").style.display = "none";
            document.getElementById("colorPicker").style.opacity = "1";
        }
    }

    //console.log("App.Preferences:", App.Preferences);
};

App.clickTab2 = function() {

    if (App.Preferences.ColorTab != 2) {

        // Enable Tab 2
        App.Preferences.ColorTab = 2;
        document.getElementById("tab2").style.opacity = "1";

        // Disable Tab 1
        document.getElementById("tab1").style.opacity = "0.3";

        // Update Colors section UI
        if (App.Preferences.Color2chk === "RANDOM") {
            document.getElementById("chk-v").style.display = "block";
            document.getElementById("colorPicker").style.opacity = "0.3";
        } else {
            document.getElementById("chk-v").style.display = "none";
            document.getElementById("colorPicker").style.opacity = "1";
        }
    }

    //console.log("App.Preferences:", App.Preferences);
};

App.colorPicker.setColor = function(event) {

    var canvas = document.getElementById('colorPicker');
    var ctx = canvas.getContext('2d');
    var x;
    var y;

    if (event.x != undefined && event.y != undefined) {
        x = event.x;
        y = event.y;
    } else { // Firefox method to get the position
        x = event.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
        y = event.clientY + document.body.scrollTop + document.documentElement.scrollTop;
    }

    x -= canvas.offsetLeft;
    y -= canvas.offsetTop;

    var pixelColor = ctx.getImageData(x, y, 1, 1).data;
    var r = pixelColor[0];
    var g = pixelColor[1];
    var b = pixelColor[2];
    var a = pixelColor[3];

    //console.log("pixelColor:", pixelColor);
    //console.log(r + ", " + g + ", " + b + ", " + a);

    if (App.Preferences.ColorTab === 1) {

        if (App.Preferences.Color1chk != "RANDOM") { // Firefox method to get the position

            // Update tab label
            document.getElementById('lblColor1').style.backgroundColor = "rgba(" + r + "," + g + "," + b + "," + a + ")";

            App.ColorCircle.startColor.r = r;
            App.ColorCircle.startColor.g = g;
            App.ColorCircle.startColor.b = b;
            App.ColorCircle.startColor.o = a;
        }

    } else {

        if (App.Preferences.Color2chk != "RANDOM") { // Firefox method to get the position

            // Update tab label
            document.getElementById('lblColor2').style.backgroundColor = "rgba(" + r + "," + g + "," + b + "," + a + ")";

            App.ColorCircle.endColor.r = r;
            App.ColorCircle.endColor.g = g;
            App.ColorCircle.endColor.b = b;
            App.ColorCircle.endColor.o = a;
        }
    }

    //console.log("App.Preferences:", App.Preferences);
};

//draw image on canvas
App.loadPickerImage = function(canvasObj, callback) {

    //console.log("canvasObj:", canvasObj);

    // /*
    var canvas1 = document.getElementById(canvasObj);
    var ctx1 = canvas1.getContext('2d');
    var img1 = new Image();
    img1.src = 'img/colorPicker.jpg';
    var cw1 = canvas1.width;
    var ch1 = canvas1.height;
    img1.onload = function() {
            ctx1.drawImage(img1, 0, 0, cw1, ch1);
            //callback();
        }
        //canvas = ctx = img = cw = ch = null;
    // */
}
