'use strict';

App.Menu = {
    open: function() {
        //console.log("Open menu!");
        document.getElementById("menu-back-layer").style.display = "block";
        document.getElementById("btn-menu").style.background = "rgba(0,0,255,0.3)";
    },
    close: function(miliseconds, callback) {

        //console.log("Close menu!");

        if (miliseconds == null) {
            miliseconds = 400;
        }

        setTimeout(function() {
            document.getElementById("menu-back-layer").style.display = "none";
            document.getElementById("btn-menu").style.background = "rgba(0,0,0,0.0)";
            if (callback) {
                callback();
            }

        }, miliseconds);
    }
}

App.addMenuEvents = function() {

    //console.log("Add events to menu");

    var el;

    // Main menu events

    el = document.getElementById("btn-menu");
    el.addEventListener("click", function() {
        document.getElementById("menu-back-layer").style.display = "block";
        App.Menu.open(0);
    });

    el = document.getElementById("menu-back-layer");
    el.addEventListener("click", function() {
        document.getElementById("menu-back-layer").style.display = "none";
        App.Menu.close(0);
    });

    // Menu options events

    el = document.getElementById("mnu-about");
    el.addEventListener("click", function(ev) {
        ev.stopPropagation();
        App.Menu.close(null, function() {
            App.Router.goTo("ABOUT");
        });
    });

    el = document.getElementById("mnu-clear");
    el.addEventListener("click", function(ev) {
        App.NodesHistory = []; //Clear the list of circles
        document.getElementById("canvas-help-message").style.display = "block";
        App.resizeCanvas();
    });
/*
    el = document.getElementById("mnu-set-colors");
    el.addEventListener("click", function(ev) {
        ev.stopPropagation();
        App.Menu.close();
        App.Router.goTo("SET-COLORS");
    });

    el = document.getElementById("mnu-save-as-data");
    el.addEventListener("click", function(ev) {
        ev.stopPropagation();
        App.Menu.close();
        App.Router.goTo("SAVE-JSON");
    });

    el = document.getElementById("mnu-save-picture");
    el.addEventListener("click", function(ev) {
        ev.stopPropagation();
        App.Menu.close();
        App.Router.goTo("SAVE-PICTURE");
    });
*/
    el = document.getElementById("mnu-invert-colors");
    el.addEventListener("click", function(ev) {
        ev.stopPropagation();
        App.Menu.close();
        App.ImageFilters.invertImage();
    });

    el = document.getElementById("mnu-grayscale");
    el.addEventListener("click", function(ev) {
        ev.stopPropagation();
        App.Menu.close();
        App.ImageFilters.grayscale();
    });

    el = document.getElementById("mnu-quit");
    el.addEventListener("click", function(ev) {
        ev.stopPropagation();
        App.Menu.close();
        window.close();
    });

    el = null;
}
