'use strict';

App.addEventsToUI = function() {

    //console.log("Add events to UI");

    function addEvent(eventType, htmlId, func) {
        var el = document.getElementById(htmlId);
        if (eventType == null) {
            eventType = "click";
        }
        //console.log("Add event " + eventType + " to element '" + htmlId + "' ");
        el.addEventListener(eventType, func);
        el = null;
    }

    var el;

    // Orientation events

    // (1)
    screen.addEventListener("orientationchange", function() { // This is not working
        //console.log("The orientation of the screen is: " + screen.orientation);
    });

    // (2)
    var handleOrientation = function() { // This is not working! 
        //console.log("Orientation change!");
    }
    window.addEventListener("deviceorientation", handleOrientation, true);

    // Startup screen events

    el = document.getElementById("scr-startupScreen");
    el.addEventListener("click", function(ev) {

        App.Router.close("scr-startupScreen", App.Transitions.DISOLVE);
        App.Router.goTo("PAINT");
    });

    // About screen OK

    el = document.getElementById("btn-about-topBar-goBack");
    el.addEventListener("click", function(ev) {

        App.Router.goTo("PAINT");
    });

    // Set colors

    el = document.getElementById("btn-setColors-topBar-goBack");
    el.addEventListener("click", function(ev) {

        App.Router.goTo("PAINT");
    });

    el = document.getElementById("chk-color");
    el.addEventListener("click", function(ev) {

        if ( App.Preferences.ColorTab === 1 ) {
            
            if ( App.Preferences.Color1chk === "RANDOM") {

                App.Preferences.Color1chk = "DEFINED";
                document.getElementById("chk-v").style.display = "none";
                document.getElementById("colorPicker").style.opacity = "1";

            } else {

                App.Preferences.Color1chk = "RANDOM";
                document.getElementById("chk-v").style.display = "block";
                document.getElementById("colorPicker").style.opacity = "0.3";
            }

        } else {

            if ( App.Preferences.Color2chk === "RANDOM") {

                App.Preferences.Color2chk = "DEFINED";
                document.getElementById("chk-v").style.display = "none";
                document.getElementById("colorPicker").style.opacity = "1";

            } else {

                App.Preferences.Color2chk = "RANDOM";
                document.getElementById("chk-v").style.display = "block";
                document.getElementById("colorPicker").style.opacity = "0.3";
            }
        }

    });

    addEvent(null, "tab1", App.clickTab1);
    addEvent(null, "tab2", App.clickTab2);

    // Canvas Paint
    var el = document.getElementById("myCanvas"); //document.getElementsByTagName("canvas")[0];
    el.addEventListener("click", function(e) {

        App.Mouse.x = e.pageX;
        App.Mouse.y = e.pageY;

        //console.log("Click! x:" + App.Mouse.x + "y:" + App.Mouse.y);

        // PAINT A CIRCLE
        App.ColorCircle.paint(App.Mouse.x, App.Mouse.y);

        // SAVE HISTORY OF CIRCLES

        //App.addToHistory (x,y,z,r1,g1,b1,r2,g2,b2,r,w);
        App.addToHistory(
            App.ColorCircle.epicenterX,
            App.ColorCircle.epicenterY,
            0,
            App.ColorCircle.startColor.r,
            App.ColorCircle.startColor.g,
            App.ColorCircle.startColor.b,
            App.ColorCircle.startColor.o,
            App.ColorCircle.startColor.r,
            App.ColorCircle.startColor.g,
            App.ColorCircle.startColor.b,
            App.ColorCircle.startColor.o,
            App.ColorCircle.radio,
            App.ColorCircle.waveLong
        );

        //console.log( "App.NodesHistory:", App.NodesHistory );

        if ( App.NodesHistory.length > 0 ) {
            document.getElementById("canvas-help-message").style.display = "none";
        }

        //App.Status.nodesList.push( ColorCircle.paint(App.Mouse.x , App.Mouse.y) );
        return false;
    });
    
    // Color Picker events
    App.loadPickerImage("colorPicker");
    addEvent(null, "colorPicker", App.colorPicker.setColor );

    addEvent(null, "btn-saveAsPicture-topBar-goBack", function() {
        console.log("Goto PAINT");
        App.Router.goTo("PAINT");
    });

    addEvent(null, "btn-saveAsData-topBar-goBack", function() {
        console.log("Goto PAINT");
        App.Router.goTo("PAINT");
    });

    el = null;
}

App.ImageFilters = {};

App.ImageFilters.invertImage = function() {

    var canvas = document.getElementById("myCanvas");
    var ctx = canvas.getContext('2d');
    var imageData = ctx.getImageData(0,0,canvas.width, canvas.height);
    var data = imageData.data;
        
    var invert = function() {
        for (var i = 0; i < data.length; i += 4) {
          data[i]     = 225 - data[i];     // red
          data[i + 1] = 225 - data[i + 1]; // green
          data[i + 2] = 225 - data[i + 2]; // blue
        }
        ctx.putImageData(imageData, 0, 0);
    };

    invert();
};

App.ImageFilters.grayscale = function() {

    var canvas = document.getElementById("myCanvas");
    var ctx = canvas.getContext('2d');
    var imageData = ctx.getImageData(0,0,canvas.width, canvas.height);
    var data = imageData.data;

    for (var i = 0; i < data.length; i += 4) {
        var avg = (data[i] + data[i +1] + data[i +2]) / 3;
        data[i]     = avg; // red
        data[i + 1] = avg; // green
        data[i + 2] = avg; // blue
    }
    
    ctx.putImageData(imageData, 0, 0);
};


