'use strict';

var App = {};

window.addEventListener("load", function() {
    //console.log("load");
    App.addMenuEvents();
    App.addEventsToUI();
    //App.getScreenSize();

    App.resizeCanvas();
    //App.clickTab1();
});

window.addEventListener('DOMContentLoaded', function() {

  //console.log("DOMContentLoaded");
/*
  // We'll ask the browser to use strict code to help us catch errors earlier.
  // https://developer.mozilla.org/Web/JavaScript/Reference/Functions_and_function_scope/Strict_mode
  'use strict';

  var translate = navigator.mozL10n.get;

  // We want to wait until the localisations library has loaded all the strings.
  // So we'll tell it to let us know once it's ready.
  navigator.mozL10n.once(start);

  function start() {
    console.log("start");
  }
*/
})

App.Preferences = {
    appWidth: 0,
    appHeight: 0,
    Color1chk: "RANDOM",
    Color2chk: "RANDOM",
    ColorTab: null // Selected tab in choose-color section
}

App.Mouse = {
    x: 0,
    y: 0
};

App.resizeCanvas = function() {

    var canvas = document.getElementById("myCanvas");
    var ctx = canvas.getContext('2d');
    ctx.canvas.width = window.innerWidth;
    ctx.canvas.height = window.innerHeight;
    var centerX = Math.round(ctx.canvas.width / 2);
    var centerY = Math.round(ctx.canvas.height / 2);
    canvas = ctx = null;
}

App.Transitions = {
    "DISOLVE": 1,
    "SLIDE": 2,
    "ZOOM": 3
};

App.Screens = [{
    id: "scr-startupScreen",
    routerName: "STARTUP-SCREEN"
}, {
    id: "scr-about",
    routerName: "ABOUT"
}, {
    id: "scr-setColors",
    routerName: "SET-COLORS"
}, {
    id: "scr-paintZone",
    routerName: "PAINT"
}, {
    id: "scr-saveAsPicture",
    routerName: "SAVE-PICTURE"
}, {
    id: "scr-saveAsData",
    routerName: "SAVE-JSON"
}];

App.Router = {

    currentSection: null, //"STARTUPSCREEN",
    close: function(sectionName, transition) {
        //console.log("Close! transition:", transition);
        document.getElementById(sectionName).style.display = "none"; // TODO: Attach a css3 transforms/transition
    },
    open: function(sectionName) {

    },
    display: function(layerName, boolean) {
        if (boolean) {
            document.getElementById(layerName).style.display = "block";
        } else {
            document.getElementById(layerName).style.display = "none";
        }
    },
    goTo: function(place) {

        switch (place) {
            case "STARTUP-SCREEN":

                break;

            case "PAINT":
                //console.log("Check if we've got nodes.");

                if ( App.NodesHistory.length == 0) {
                    //console.log("We dont have nodes so we mus show instructions in the canvas.");
                }

                break;

            case "ABOUT":
                
                // Set section screen size:
                var w = window.innerWidth;
                var h = window.innerHeight - 60; // 60 is the top bar
                document.getElementById("about-content").style.height = h + "px"; 

                break;

            case "SET-COLORS":
                //App.SetColorsCotroller.init();

                App.loadPickerImage( "colorPicker" );
                App.clickTab1();

                break;

            case "SAVE-JSON":
                
                // Set section screen size:
                var w = window.innerWidth;
                var h = window.innerHeight - 60;
                document.getElementById("JSONdataContent").style.height = h + "px"; 
                
                // draw json on the screen
                document.getElementById("JSONdataContent").innerHTML = App.historyToJSON();
                App.SaveFile(null, App.historyToJSON() );

                break;

            case "SAVE-PICTURE":

                break;

            case "QUIT":

                break;

            default:

        } // switch ends here

        //App.Router.hideAll();
        App.Router.hideAllUnless(place); // Hides all layers and shows the one I am navigating to. 

    },
    hideAll: function() {

        var i;
        var lon = App.Screens.length;
        var layerName = null;

        for (i = 0; i < lon; i++) {
            layerName = App.Screens[i].id;
            //console.log("layerName:", layerName);
            document.getElementById(layerName).style.display = "none";
        }

        i = lon = layerName = null;
    },
    hideAllUnless: function(routerSection) {

        var i;
        var lon = App.Screens.length;
        var layerName = null;

        // This must be improved this way: (1) Show the layer, (2) hide the rest.
        for (i = 0; i < lon; i++) {

            layerName = App.Screens[i].id;

            if (routerSection === App.Screens[i].routerName) {
                App.Router.display(layerName, true);
                //console.log("Hide layer:", layerName);
            } else {
                App.Router.display(layerName, false);
                //console.log("Show layer:", layerName);
            }
        }

        i = lon = layerName = null;
    }

}; // Router ends here

