'use strict';

App.Utils = {
    getRandomInt: function(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }
}

App.ColorCircle = {

    epicenterX: 0,
    epicenterY: 0,
    radio: 100,
    startColor: {
        r: 0,
        g: 0,
        b: 0,
        o: 1
    },
    endColor: {
        r: 255,
        g: 255,
        b: 255,
        o: 1
    },
    waveLong: 10,
    paint: function(x, y, canvas) {

        var canvas = document.getElementById("myCanvas");
        var c = canvas.getContext('2d');

        /*
        var canvasW = canvas.width
        var canvasH = canvas.height
        var canvasCenterX = canvasW/2;
        var canvasCenterY = canvasH/2;
        */

        if ((this.epicenterX != App.Mouse.x) || (this.epicenterY != App.Mouse.y)) {

            this.epicenterX = App.Mouse.x;
            this.epicenterY = App.Mouse.y;
            this.radio = App.Utils.getRandomInt(50, 500);

            /*
            this.startColor.r=App.Utils.getRandomInt (0, 255);
            this.startColor.g=App.Utils.getRandomInt (0, 255);
            this.startColor.b=App.Utils.getRandomInt (0, 255);

            this.endColor.r=App.Utils.getRandomInt (0, 255);
            this.endColor.g=App.Utils.getRandomInt (0, 255);
            this.endColor.b=App.Utils.getRandomInt (0, 255);
            */

            if (App.Preferences.Color1chk === "RANDOM") {
                this.startColor.r = App.Utils.getRandomInt(0, 255);
                this.startColor.g = App.Utils.getRandomInt(0, 255);
                this.startColor.b = App.Utils.getRandomInt(0, 255);
            } else {
                this.startColor.r = this.startColor.r;
                this.startColor.g = this.startColor.g;
                this.startColor.b = this.startColor.b;
            }

            if (App.Preferences.Color2chk === "RANDOM") {
                this.endColor.r = App.Utils.getRandomInt(0, 255);
                this.endColor.g = App.Utils.getRandomInt(0, 255);
                this.endColor.b = App.Utils.getRandomInt(0, 255);
            } else {
                this.endColor.r = this.endColor.r;
                this.endColor.g = this.endColor.g;
                this.endColor.b = this.endColor.b;
            }

            this.waveLong = App.Utils.getRandomInt(10, 100);
        }

        var stepR = this.setStep(this.startColor.r, this.endColor.r, this.waveLong / 2);
        var stepG = this.setStep(this.startColor.g, this.endColor.g, this.waveLong / 2);
        var stepB = this.setStep(this.startColor.b, this.endColor.b, this.waveLong / 2);
        var stepOpacity = this.setStep(0, 1, this.radio);
        //console.log("Pasos RGBA: "+ stepR +", "+ stepR +", "+stepR+", "+stepOpacity );

        var cont = 0;
        var colR = this.startColor.r;
        var colG = this.startColor.g;
        var colB = this.startColor.b;
        var colOpacity = 1;

        var cR, cG, cB, cO;

        for (var i = 0; i < this.radio; i++) {

            cR = this.limitFigure(colR);
            cG = this.limitFigure(colG);
            cB = this.limitFigure(colB);
            cO = colOpacity;

            // PAINT
            //c.fillStyle = "rgba("+ cR +","+ cG +","+ cB +","+ cO +")";
            c.strokeStyle = "rgba(" + cR + "," + cG + "," + cB + "," + cO + ")";
            c.beginPath();
            c.arc(this.epicenterX, this.epicenterY, i, 0, 2 * Math.PI, false);
            c.lineWidth = 1; //0.5;
            c.stroke();

            colOpacity = colOpacity - stepOpacity;
            if (stepOpacity < 0) stepOpacity = 0;

            if (cont < (this.waveLong / 2)) { //Wave goes up ...

                var colR = colR + stepR;
                var colG = colG + stepG;
                var colB = colB + stepB;

            } else { // Wave goes down ...

                var colR = colR - stepR;
                var colG = colG - stepG;
                var colB = colB - stepB;
            }

            if (cont >= this.waveLong - 1) cont = 0;
            else cont++;
        }

    },
    limitFigure: function(num) {

        if (num < 0) {
            return 0;
        } else if (num > 255) {
            return 255;
        } else {
            return Math.floor(num);
        }
    },
    setStep: function(a, b, longitud) {
        if (longitud <= 0) return 0;
        if (a == b) {
            return 0;
        } else {
            if (a < b) {
                return (b - a) / longitud;
            } else {
                return -(a - b) / longitud
            }
        }
    }

}
